/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntity;
import org.apache.hive.druid.org.apache.druid.data.input.InputEntityReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ByteEntity;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedInputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DelimitedReaderTest {
    private static final InputRowSchema INPUT_ROW_SCHEMA = new InputRowSchema(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("ts", "name"))), Collections.emptyList());

    @BeforeClass
    public static void setup() {
        NullHandling.initializeForTests();
    }

    @Test
    public void testWithoutHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score"), null, null, null, Boolean.valueOf(false), 0);
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumn() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), null, null, null, Boolean.valueOf(true), 0);
        this.assertResult(source, format);
    }

    @Test
    public void testSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this\tis\ta\trow\tto\tskip", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"score"), null, null, null, Boolean.valueOf(false), 1);
        this.assertResult(source, format);
    }

    @Test
    public void testFindColumnAndSkipHeaders() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"this\tis\ta\trow\tto\tskip", (Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5", (Object)"2019-01-01T00:00:20Z\tname_2\t10", (Object)"2019-01-01T00:00:30Z\tname_3\t15"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), null, null, null, Boolean.valueOf(true), 1);
        this.assertResult(source, format);
    }

    @Test
    public void testMultiValues() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts\tname\tscore", (Object)"2019-01-01T00:00:10Z\tname_1\t5|1", (Object)"2019-01-01T00:00:20Z\tname_2\t10|2", (Object)"2019-01-01T00:00:30Z\tname_3\t15|3"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), "|", null, null, Boolean.valueOf(true), 0);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)ImmutableList.of((Object)Integer.toString((numResults + 1) * 5), (Object)Integer.toString(numResults + 1)), (Object)row.getDimension("score"));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }

    @Test
    public void testCustomizeSeparator() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"ts|name|score", (Object)"2019-01-01T00:00:10Z|name_1|5\t1", (Object)"2019-01-01T00:00:20Z|name_2|10\t2", (Object)"2019-01-01T00:00:30Z|name_3|15\t3"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of(), "\t", "|", null, Boolean.valueOf(true), 0);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)ImmutableList.of((Object)Integer.toString((numResults + 1) * 5), (Object)Integer.toString(numResults + 1)), (Object)row.getDimension("score"));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }

    @Test
    public void testRussianTextMess() throws IOException {
        ByteEntity source = this.writeData((List<String>)ImmutableList.of((Object)"2019-01-01T00:00:10Z\tname_1\t\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442 \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430"));
        DelimitedInputFormat format = new DelimitedInputFormat((List)ImmutableList.of((Object)"ts", (Object)"name", (Object)"Comment"), null, null, null, Boolean.valueOf(false), 0);
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        try (CloseableIterator iterator = reader.read();){
            Assert.assertTrue((boolean)iterator.hasNext());
            InputRow row = (InputRow)iterator.next();
            Assert.assertEquals((Object)DateTimes.of((String)"2019-01-01T00:00:10Z"), (Object)row.getTimestamp());
            Assert.assertEquals((Object)"name_1", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
            Assert.assertEquals((Object)"\u041a\u0430\u043a \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0441\u044f: \\\"\u0432\u0441\u0451 \u0442\u0435\u0447\u0435\u0442 \u0432\u0441\u0451 \u0438\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f\\\". \u0423\u043a\u0440\u0430\u0438\u043d\u0430 \u043a\u0430\u043a \u0432\u0441\u0435\u0433\u0434\u0430 \u043e\u0431\u0432\u0438\u043d\u044f\u0435\u0442 \u0420\u043e\u0441\u0441\u0438\u044e \u0432 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u043f\u0440\u043e\u0431\u043b\u0435\u043c\u0430\u0445. #\u041f\u0440\u043e\u0432\u043e\u043a\u0430\u0446\u0438\u044f\u041a\u0438\u0435\u0432\u0430", (Object)Iterables.getOnlyElement((Iterable)row.getDimension("Comment")));
            Assert.assertFalse((boolean)iterator.hasNext());
        }
    }

    private ByteEntity writeData(List<String> lines) throws IOException {
        List byteLines = lines.stream().map(line -> StringUtils.toUtf8((String)(line + "\n"))).collect(Collectors.toList());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(byteLines.stream().mapToInt(bytes -> ((byte[])bytes).length).sum());
        for (byte[] bytes2 : byteLines) {
            outputStream.write(bytes2);
        }
        return new ByteEntity(outputStream.toByteArray());
    }

    private void assertResult(ByteEntity source, DelimitedInputFormat format) throws IOException {
        InputEntityReader reader = format.createReader(INPUT_ROW_SCHEMA, (InputEntity)source, null);
        int numResults = 0;
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-01T00:00:%02dZ", (Object[])new Object[]{(numResults + 1) * 10})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{numResults + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString((numResults + 1) * 5), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                ++numResults;
            }
            Assert.assertEquals((long)3L, (long)numResults);
        }
    }
}

