/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.junit.Assert;
import org.junit.Test;

public class DelimitedParseSpecTest {
    private final ObjectMapper jsonMapper = new TestObjectMapper();

    @Test
    public void testSerde() throws IOException {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("abc", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("abc")), null, null), "\u0001", "\u0002", Collections.singletonList("abc"), false, 0);
        DelimitedParseSpec serde = (DelimitedParseSpec)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)spec), DelimitedParseSpec.class);
        Assert.assertEquals((Object)"abc", (Object)serde.getTimestampSpec().getTimestampColumn());
        Assert.assertEquals((Object)"iso", (Object)serde.getTimestampSpec().getTimestampFormat());
        Assert.assertEquals(Collections.singletonList("abc"), (Object)serde.getColumns());
        Assert.assertEquals((Object)"\u0001", (Object)serde.getDelimiter());
        Assert.assertEquals((Object)"\u0002", (Object)serde.getListDelimiter());
        Assert.assertEquals(Collections.singletonList("abc"), (Object)serde.getDimensionsSpec().getDimensionNames());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testComma() {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("a,", "b")), new ArrayList(), new ArrayList()), ",", null, Collections.singletonList("a,"), false, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDefaultColumnList() {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("a", "b")), new ArrayList(), new ArrayList()), ",", null, null, false, 0);
    }
}

