/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.util.HashMap;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.MapBasedRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MapBasedRowTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testGetLongMetricFromString() {
        MapBasedRow row = new MapBasedRow(DateTimes.nowUtc(), (Map)ImmutableMap.builder().put((Object)"k0", (Object)"-1.2").put((Object)"k1", (Object)"1.23").put((Object)"k2", (Object)"1.8").put((Object)"k3", (Object)"1e5").put((Object)"k4", (Object)"9223372036854775806").put((Object)"k5", (Object)"-9223372036854775807").put((Object)"k6", (Object)"+9223372036854775802").build());
        Assert.assertEquals((Object)-1.2, (Object)row.getMetric("k0"));
        Assert.assertEquals((Object)1.23, (Object)row.getMetric("k1"));
        Assert.assertEquals((Object)1.8, (Object)row.getMetric("k2"));
        Assert.assertEquals((Object)100000.0, (Object)row.getMetric("k3"));
        Assert.assertEquals((Object)0x7FFFFFFFFFFFFFFEL, (Object)row.getMetric("k4"));
        Assert.assertEquals((Object)-9223372036854775807L, (Object)row.getMetric("k5"));
        Assert.assertEquals((Object)0x7FFFFFFFFFFFFFFAL, (Object)row.getMetric("k6"));
    }

    @Test
    public void testImmutability() {
        HashMap<String, Integer> event = new HashMap<String, Integer>();
        event.put("k0", 1);
        event.put("k1", 2);
        MapBasedRow row = new MapBasedRow(DateTimes.nowUtc(), event);
        this.expectedException.expect(UnsupportedOperationException.class);
        row.getEvent().put("k2", 3);
    }
}

