/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.apache.hive.druid.org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class HandlingInputRowIteratorTest {

    public static class PresentRowTest {
        private static final InputRow INPUT_ROW1 = (InputRow)EasyMock.mock(InputRow.class);
        private static final InputRow INPUT_ROW2 = (InputRow)EasyMock.mock(InputRow.class);
        private static final List<InputRow> INPUT_ROWS = Arrays.asList(INPUT_ROW1, INPUT_ROW2);
        private TestInputRowHandler successfulHandler;
        private TestInputRowHandler unsuccessfulHandler;

        @Before
        public void setup() {
            this.successfulHandler = new TestInputRowHandler(true);
            this.unsuccessfulHandler = new TestInputRowHandler(false);
        }

        @Test
        public void hasNext() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.unsuccessfulHandler);
            Assert.assertTrue((boolean)target.hasNext());
            Assert.assertFalse((boolean)this.unsuccessfulHandler.invoked);
        }

        @Test
        public void yieldsNextIfUnhandled() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.unsuccessfulHandler);
            Assert.assertEquals((Object)INPUT_ROW1, (Object)target.next());
            Assert.assertTrue((boolean)this.unsuccessfulHandler.invoked);
        }

        @Test
        public void yieldsNullIfHandledByFirst() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.successfulHandler, this.unsuccessfulHandler);
            Assert.assertNull((Object)target.next());
            Assert.assertTrue((boolean)this.successfulHandler.invoked);
            Assert.assertFalse((boolean)this.unsuccessfulHandler.invoked);
        }

        @Test
        public void yieldsNullIfHandledBySecond() {
            HandlingInputRowIterator target = PresentRowTest.createInputRowIterator(this.unsuccessfulHandler, this.successfulHandler);
            Assert.assertNull((Object)target.next());
            Assert.assertTrue((boolean)this.unsuccessfulHandler.invoked);
            Assert.assertTrue((boolean)this.successfulHandler.invoked);
        }

        private static HandlingInputRowIterator createInputRowIterator(HandlingInputRowIterator.InputRowHandler firstHandler, HandlingInputRowIterator.InputRowHandler secondHandler) {
            CloseableIterator iterator = CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRow>(){
                private final Iterator<InputRow> delegate = PresentRowTest.access$000().iterator();

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                @Nullable
                public InputRow next() {
                    return this.delegate.next();
                }
            });
            return new HandlingInputRowIterator(iterator, Arrays.asList(firstHandler, secondHandler));
        }

        static /* synthetic */ List access$000() {
            return INPUT_ROWS;
        }

        private static class TestInputRowHandler
        implements HandlingInputRowIterator.InputRowHandler {
            boolean invoked = false;
            private final boolean successful;

            TestInputRowHandler(boolean successful) {
                this.successful = successful;
            }

            public boolean handle(InputRow inputRow) {
                this.invoked = true;
                return this.successful;
            }
        }
    }

    public static class AbsentRowTest {
        private static final CloseableIterator<InputRow> EMPTY_ITERATOR = CloseableIterators.withEmptyBaggage((Iterator)new Iterator<InputRow>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            @Nullable
            public InputRow next() {
                throw new NoSuchElementException();
            }
        });
        private HandlingInputRowIterator target;

        @Before
        public void setup() {
            this.target = new HandlingInputRowIterator(EMPTY_ITERATOR, Collections.emptyList());
        }

        @Test
        public void doesNotHaveNext() {
            Assert.assertFalse((boolean)this.target.hasNext());
        }

        @Test(expected=NoSuchElementException.class)
        public void throwsExceptionWhenYieldingNext() {
            this.target.next();
        }
    }
}

