/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.hive.druid.org.apache.druid.data.input.Firehose;
import org.apache.hive.druid.org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.InputSourceReader;
import org.apache.hive.druid.org.apache.druid.data.input.InputSplit;
import org.apache.hive.druid.org.apache.druid.data.input.SplitHintSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.junit.Assert;
import org.junit.Test;

public class FirehoseFactoryToInputSourceAdaptorTest {
    @Test
    public void testUnimplementedInputFormat() throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            lines.add(StringUtils.format((String)"%d,name_%d,%d", (Object[])new Object[]{20190101 + i, i, i + 100}));
        }
        TestFirehoseFactory firehoseFactory = new TestFirehoseFactory(lines);
        StringInputRowParser inputRowParser = new StringInputRowParser((ParseSpec)new UnimplementedInputFormatCsvParseSpec(new TimestampSpec(null, "yyyyMMdd", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "name", "score"))), ",", Arrays.asList("timestamp", "name", "score"), false, 0), StringUtils.UTF8_STRING);
        FirehoseFactoryToInputSourceAdaptor inputSourceAdaptor = new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)firehoseFactory, (InputRowParser)inputRowParser);
        InputSourceReader reader = inputSourceAdaptor.reader(new InputRowSchema(inputRowParser.getParseSpec().getTimestampSpec(), inputRowParser.getParseSpec().getDimensionsSpec(), Collections.emptyList()), null, null);
        ArrayList<Object> result = new ArrayList<Object>();
        try (CloseableIterator iterator = reader.read();){
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        Assert.assertEquals((long)10L, (long)result.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{1 + i})), (Object)((InputRow)result.get(i)).getTimestamp());
            Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i}), (Object)Iterables.getOnlyElement((Iterable)((InputRow)result.get(i)).getDimension("name")));
            Assert.assertEquals((Object)StringUtils.format((String)"%d", (Object[])new Object[]{i + 100}), (Object)Iterables.getOnlyElement((Iterable)((InputRow)result.get(i)).getDimension("score")));
        }
    }

    private static class TestFirehoseFactory
    implements FiniteFirehoseFactory<StringInputRowParser, Object> {
        private final List<String> lines;

        private TestFirehoseFactory(List<String> lines) {
            this.lines = lines;
        }

        public Firehose connect(final StringInputRowParser parser, @Nullable File temporaryDirectory) throws ParseException {
            return new Firehose(){
                final Iterator<String> iterator;
                {
                    this.iterator = lines.iterator();
                }

                public boolean hasMore() {
                    return this.iterator.hasNext();
                }

                public InputRow nextRow() {
                    return parser.parse(this.iterator.next());
                }

                public void close() {
                }
            };
        }

        public boolean isSplittable() {
            return false;
        }

        public Stream<InputSplit<Object>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
            return null;
        }

        public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
            return 0;
        }

        public FiniteFirehoseFactory withSplit(InputSplit split) {
            return null;
        }
    }

    private static class UnimplementedInputFormatCsvParseSpec
    extends CSVParseSpec {
        private UnimplementedInputFormatCsvParseSpec(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, String listDelimiter, List<String> columns, boolean hasHeaderRow, int skipHeaderRows) {
            super(timestampSpec, dimensionsSpec, listDelimiter, columns, hasHeaderRow, skipHeaderRows);
        }

        @Nullable
        public InputFormat toInputFormat() {
            return null;
        }
    }
}

