/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator.discovery;

import java.io.IOException;
import java.net.URI;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;
import org.apache.hive.druid.org.apache.druid.client.selector.Server;
import org.apache.hive.druid.org.apache.druid.curator.discovery.ServerDiscoverySelector;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerDiscoverySelectorTest {
    private ServiceProvider serviceProvider;
    private ServerDiscoverySelector serverDiscoverySelector;
    private ServiceInstance instance;
    private static final int PORT = 8080;
    private static final int SSL_PORT = 8280;
    private static final String ADDRESS = "localhost";

    @Before
    public void setUp() {
        this.serviceProvider = (ServiceProvider)EasyMock.createMock(ServiceProvider.class);
        this.instance = (ServiceInstance)EasyMock.createMock(ServiceInstance.class);
        this.serverDiscoverySelector = new ServerDiscoverySelector(this.serviceProvider, "test");
    }

    @Test
    public void testPick() throws Exception {
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn((Object)this.instance).anyTimes();
        EasyMock.expect((Object)this.instance.getAddress()).andReturn((Object)ADDRESS).anyTimes();
        EasyMock.expect((Object)this.instance.getPort()).andReturn((Object)8080).anyTimes();
        EasyMock.expect((Object)this.instance.getSslPort()).andReturn((Object)-1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.instance, this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertEquals((long)8080L, (long)server.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)server.getAddress());
        Assert.assertTrue((boolean)server.getHost().contains(Integer.toString(8080)));
        Assert.assertTrue((boolean)server.getHost().contains(ADDRESS));
        Assert.assertEquals((Object)"http", (Object)server.getScheme());
        EasyMock.verify((Object[])new Object[]{this.instance, this.serviceProvider});
        URI uri = new URI(server.getScheme(), null, server.getAddress(), server.getPort(), "/druid/indexer/v1/action", null, null);
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)uri.getHost());
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
    }

    @Test
    public void testPickWithNullSslPort() throws Exception {
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn((Object)this.instance).anyTimes();
        EasyMock.expect((Object)this.instance.getAddress()).andReturn((Object)ADDRESS).anyTimes();
        EasyMock.expect((Object)this.instance.getPort()).andReturn((Object)8080).anyTimes();
        EasyMock.expect((Object)this.instance.getSslPort()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.instance, this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertEquals((long)8080L, (long)server.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)server.getAddress());
        Assert.assertTrue((boolean)server.getHost().contains(Integer.toString(8080)));
        Assert.assertTrue((boolean)server.getHost().contains(ADDRESS));
        Assert.assertEquals((Object)"http", (Object)server.getScheme());
        EasyMock.verify((Object[])new Object[]{this.instance, this.serviceProvider});
        URI uri = new URI(server.getScheme(), null, server.getAddress(), server.getPort(), "/druid/indexer/v1/action", null, null);
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)uri.getHost());
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
    }

    @Test
    public void testPickWithSslPort() throws Exception {
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn((Object)this.instance).anyTimes();
        EasyMock.expect((Object)this.instance.getAddress()).andReturn((Object)ADDRESS).anyTimes();
        EasyMock.expect((Object)this.instance.getPort()).andReturn((Object)8080).anyTimes();
        EasyMock.expect((Object)this.instance.getSslPort()).andReturn((Object)8280).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.instance, this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertEquals((long)8280L, (long)server.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)server.getAddress());
        Assert.assertTrue((boolean)server.getHost().contains(Integer.toString(8280)));
        Assert.assertTrue((boolean)server.getHost().contains(ADDRESS));
        Assert.assertEquals((Object)"https", (Object)server.getScheme());
        EasyMock.verify((Object[])new Object[]{this.instance, this.serviceProvider});
        URI uri = new URI(server.getScheme(), null, server.getAddress(), server.getPort(), "/druid/indexer/v1/action", null, null);
        Assert.assertEquals((long)8280L, (long)uri.getPort());
        Assert.assertEquals((Object)ADDRESS, (Object)uri.getHost());
        Assert.assertEquals((Object)"https", (Object)uri.getScheme());
    }

    @Test
    public void testPickIPv6() throws Exception {
        String address = "2001:0db8:0000:0000:0000:ff00:0042:8329";
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn((Object)this.instance).anyTimes();
        EasyMock.expect((Object)this.instance.getAddress()).andReturn((Object)"2001:0db8:0000:0000:0000:ff00:0042:8329").anyTimes();
        EasyMock.expect((Object)this.instance.getPort()).andReturn((Object)8080).anyTimes();
        EasyMock.expect((Object)this.instance.getSslPort()).andReturn((Object)-1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.instance, this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertEquals((long)8080L, (long)server.getPort());
        Assert.assertEquals((Object)"2001:0db8:0000:0000:0000:ff00:0042:8329", (Object)server.getAddress());
        Assert.assertTrue((boolean)server.getHost().contains(Integer.toString(8080)));
        Assert.assertTrue((boolean)server.getHost().contains("2001:0db8:0000:0000:0000:ff00:0042:8329"));
        Assert.assertEquals((Object)"http", (Object)server.getScheme());
        EasyMock.verify((Object[])new Object[]{this.instance, this.serviceProvider});
        URI uri = new URI(server.getScheme(), null, server.getAddress(), server.getPort(), "/druid/indexer/v1/action", null, null);
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)StringUtils.format((String)"[%s]", (Object[])new Object[]{"2001:0db8:0000:0000:0000:ff00:0042:8329"}), (Object)uri.getHost());
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
    }

    @Test
    public void testPickIPv6Bracket() throws Exception {
        String address = "[2001:0db8:0000:0000:0000:ff00:0042:8329]";
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn((Object)this.instance).anyTimes();
        EasyMock.expect((Object)this.instance.getAddress()).andReturn((Object)"[2001:0db8:0000:0000:0000:ff00:0042:8329]").anyTimes();
        EasyMock.expect((Object)this.instance.getPort()).andReturn((Object)8080).anyTimes();
        EasyMock.expect((Object)this.instance.getSslPort()).andReturn((Object)-1).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.instance, this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertEquals((long)8080L, (long)server.getPort());
        Assert.assertEquals((Object)"[2001:0db8:0000:0000:0000:ff00:0042:8329]", (Object)server.getAddress());
        Assert.assertTrue((boolean)server.getHost().contains(Integer.toString(8080)));
        Assert.assertTrue((boolean)server.getHost().contains("[2001:0db8:0000:0000:0000:ff00:0042:8329]"));
        Assert.assertEquals((Object)"http", (Object)server.getScheme());
        EasyMock.verify((Object[])new Object[]{this.instance, this.serviceProvider});
        URI uri = new URI(server.getScheme(), null, server.getAddress(), server.getPort(), "/druid/indexer/v1/action", null, null);
        Assert.assertEquals((long)8080L, (long)uri.getPort());
        Assert.assertEquals((Object)"[2001:0db8:0000:0000:0000:ff00:0042:8329]", (Object)uri.getHost());
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
    }

    @Test
    public void testPickWithNullInstance() throws Exception {
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertNull((Object)server);
        EasyMock.verify((Object[])new Object[]{this.serviceProvider});
    }

    @Test
    public void testPickWithException() throws Exception {
        EasyMock.expect((Object)this.serviceProvider.getInstance()).andThrow((Throwable)new Exception()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serviceProvider});
        Server server = this.serverDiscoverySelector.pick();
        Assert.assertNull((Object)server);
        EasyMock.verify((Object[])new Object[]{this.serviceProvider});
    }

    @Test
    public void testStart() throws Exception {
        this.serviceProvider.start();
        EasyMock.replay((Object[])new Object[]{this.serviceProvider});
        this.serverDiscoverySelector.start();
        EasyMock.verify((Object[])new Object[]{this.serviceProvider});
    }

    @Test
    public void testStop() throws IOException {
        this.serviceProvider.close();
        EasyMock.replay((Object[])new Object[]{this.serviceProvider});
        this.serverDiscoverySelector.stop();
        EasyMock.verify((Object[])new Object[]{this.serviceProvider});
    }
}

