/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator.discovery;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hive.druid.org.apache.druid.curator.CuratorTestBase;
import org.apache.hive.druid.org.apache.druid.curator.discovery.CuratorDruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CuratorDruidLeaderSelectorTest
extends CuratorTestBase {
    private static final Logger logger = new Logger(CuratorDruidLeaderSelectorTest.class);

    @Before
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)((ServiceEmitter)EasyMock.createNiceMock(ServiceEmitter.class)));
        this.setupServerAndCurator();
    }

    @Test(timeout=60000L)
    public void testSimple() throws Exception {
        this.curator.start();
        this.curator.blockUntilConnected();
        final AtomicReference currLeader = new AtomicReference();
        String latchPath = "/testlatchPath";
        CuratorDruidLeaderSelector leaderSelector1 = new CuratorDruidLeaderSelector(this.curator, new DruidNode("s1", "h1", false, Integer.valueOf(8080), null, true, false), latchPath);
        leaderSelector1.registerListener(new DruidLeaderSelector.Listener(){

            public void becomeLeader() {
                logger.info("listener1.becomeLeader().", new Object[0]);
                currLeader.set("h1:8080");
                throw new RuntimeException("I am Rogue.");
            }

            public void stopBeingLeader() {
                logger.info("listener1.stopBeingLeader().", new Object[0]);
                throw new RuntimeException("I said I am Rogue.");
            }
        });
        while (!"h1:8080".equals(currLeader.get())) {
            logger.info("current leader = [%s]", new Object[]{currLeader.get()});
            Thread.sleep(100L);
        }
        Assert.assertTrue((leaderSelector1.localTerm() >= 1 ? 1 : 0) != 0);
        CuratorDruidLeaderSelector leaderSelector2 = new CuratorDruidLeaderSelector(this.curator, new DruidNode("s2", "h2", false, Integer.valueOf(8080), null, true, false), latchPath);
        leaderSelector2.registerListener(new DruidLeaderSelector.Listener(){
            private AtomicInteger attemptCount = new AtomicInteger(0);

            public void becomeLeader() {
                logger.info("listener2.becomeLeader().", new Object[0]);
                if (this.attemptCount.getAndIncrement() < 1) {
                    throw new RuntimeException("will become leader on next attempt.");
                }
                currLeader.set("h2:8080");
            }

            public void stopBeingLeader() {
                logger.info("listener2.stopBeingLeader().", new Object[0]);
                throw new RuntimeException("I am broken.");
            }
        });
        while (!"h2:8080".equals(currLeader.get())) {
            logger.info("current leader = [%s]", new Object[]{currLeader.get()});
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)leaderSelector2.isLeader());
        Assert.assertEquals((Object)"http://h2:8080", (Object)leaderSelector1.getCurrentLeader());
        Assert.assertEquals((long)2L, (long)leaderSelector2.localTerm());
        CuratorDruidLeaderSelector leaderSelector3 = new CuratorDruidLeaderSelector(this.curator, new DruidNode("s3", "h3", false, Integer.valueOf(8080), null, true, false), latchPath);
        leaderSelector3.registerListener(new DruidLeaderSelector.Listener(){

            public void becomeLeader() {
                logger.info("listener3.becomeLeader().", new Object[0]);
                currLeader.set("h3:8080");
            }

            public void stopBeingLeader() {
                logger.info("listener3.stopBeingLeader().", new Object[0]);
            }
        });
        leaderSelector2.unregisterListener();
        while (!"h3:8080".equals(currLeader.get())) {
            logger.info("current leader = [%s]", new Object[]{currLeader.get()});
            Thread.sleep(100L);
        }
        Assert.assertTrue((boolean)leaderSelector3.isLeader());
        Assert.assertEquals((Object)"http://h3:8080", (Object)leaderSelector1.getCurrentLeader());
        Assert.assertEquals((long)1L, (long)leaderSelector3.localTerm());
    }

    @After
    public void tearDown() {
        this.tearDownServerAndCurator();
    }
}

