/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hive.druid.org.apache.druid.curator.ExhibitorConfig;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigTesterBase;
import org.junit.Assert;
import org.junit.Test;

public class ExhibitorConfigTest
extends JsonConfigTesterBase<ExhibitorConfig> {
    @Test
    public void testSerde() {
        this.propertyValues.put(ExhibitorConfigTest.getPropertyKey("hosts"), "[\"hostA\",\"hostB\"]");
        this.propertyValues.put(ExhibitorConfigTest.getPropertyKey("port"), "80");
        this.propertyValues.put(ExhibitorConfigTest.getPropertyKey("restUriPath"), "/list");
        this.propertyValues.put(ExhibitorConfigTest.getPropertyKey("useSsl"), "true");
        this.propertyValues.put(ExhibitorConfigTest.getPropertyKey("pollingMs"), "1000");
        this.testProperties.putAll((Map<?, ?>)this.propertyValues);
        this.configProvider.inject(this.testProperties, this.configurator);
        ExhibitorConfig config = (ExhibitorConfig)this.configProvider.get().get();
        List hosts = config.getHosts();
        Assert.assertEquals((long)2L, (long)hosts.size());
        Assert.assertTrue((boolean)hosts.contains("hostA"));
        Assert.assertTrue((boolean)hosts.contains("hostB"));
        Assert.assertEquals((long)80L, (long)config.getRestPort());
        Assert.assertEquals((Object)"/list", (Object)config.getRestUriPath());
        Assert.assertTrue((boolean)config.getUseSsl());
        Assert.assertEquals((long)1000L, (long)config.getPollingMs());
    }

    @Test
    public void defaultValues() {
        this.configProvider.inject(new Properties(), this.configurator);
        ExhibitorConfig config = (ExhibitorConfig)this.configProvider.get().get();
        List hosts = config.getHosts();
        Assert.assertTrue((boolean)hosts.isEmpty());
        Assert.assertEquals((long)8080L, (long)config.getRestPort());
        Assert.assertEquals((Object)"/exhibitor/v1/cluster/list", (Object)config.getRestUriPath());
        Assert.assertFalse((boolean)config.getUseSsl());
        Assert.assertEquals((long)10000L, (long)config.getPollingMs());
    }
}

