/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.curator;

import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.api.CreateBackgroundModeStatACLable;
import org.apache.curator.retry.RetryOneTime;
import org.apache.curator.test.TestingServer;
import org.apache.curator.test.Timing;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.common.utils.UUIDUtils;
import org.apache.hive.druid.org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class CuratorTestBase {
    protected TestingServer server;
    protected Timing timing;
    protected CuratorFramework curator;
    private int batchCtr = 0;

    protected void setupServerAndCurator() throws Exception {
        this.server = new TestingServer();
        this.timing = new Timing();
        this.curator = CuratorFrameworkFactory.builder().connectString(this.server.getConnectString()).sessionTimeoutMs(this.timing.session()).connectionTimeoutMs(this.timing.connection()).retryPolicy((RetryPolicy)new RetryOneTime(1)).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(true)).build();
    }

    protected void setupZNodeForServer(DruidServer server, ZkPathsConfig zkPathsConfig, ObjectMapper jsonMapper) {
        String announcementsPath = zkPathsConfig.getAnnouncementsPath();
        String inventoryPath = zkPathsConfig.getLiveSegmentsPath();
        String zkPath = ZKPaths.makePath((String)announcementsPath, (String)server.getHost());
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(zkPath, jsonMapper.writeValueAsBytes((Object)server.getMetadata()));
            this.curator.create().creatingParentsIfNeeded().forPath(ZKPaths.makePath((String)inventoryPath, (String)server.getHost()));
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.curator.setData().forPath(zkPath, jsonMapper.writeValueAsBytes((Object)server.getMetadata()));
                this.curator.setData().forPath(ZKPaths.makePath((String)inventoryPath, (String)server.getHost()));
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void announceSegmentForServer(DruidServer druidServer, DataSegment segment, ZkPathsConfig zkPathsConfig, ObjectMapper jsonMapper) {
        String segmentAnnouncementPath = ZKPaths.makePath((String)zkPathsConfig.getLiveSegmentsPath(), (String)druidServer.getHost(), (String[])new String[]{segment.getId().toString()});
        try {
            ((ACLBackgroundPathAndBytesable)((CreateBackgroundModeStatACLable)this.curator.create().compressed()).withMode(CreateMode.EPHEMERAL)).forPath(segmentAnnouncementPath, jsonMapper.writeValueAsBytes((Object)ImmutableSet.of((Object)segment)));
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.curator.setData().forPath(segmentAnnouncementPath, jsonMapper.writeValueAsBytes((Object)ImmutableSet.of((Object)segment)));
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String announceBatchSegmentsForServer(DruidServer druidServer, ImmutableSet<DataSegment> segments, ZkPathsConfig zkPathsConfig, ObjectMapper jsonMapper) {
        String segmentAnnouncementPath = ZKPaths.makePath((String)zkPathsConfig.getLiveSegmentsPath(), (String)druidServer.getHost(), (String[])new String[]{UUIDUtils.generateUuid((String[])new String[]{druidServer.getHost(), druidServer.getType().toString(), druidServer.getTier(), DateTimes.nowUtc().toString()}) + this.batchCtr++});
        try {
            ((ACLBackgroundPathAndBytesable)((CreateBackgroundModeStatACLable)this.curator.create().compressed()).withMode(CreateMode.EPHEMERAL)).forPath(segmentAnnouncementPath, jsonMapper.writeValueAsBytes(segments));
        }
        catch (KeeperException.NodeExistsException e) {
            try {
                this.curator.setData().forPath(segmentAnnouncementPath, jsonMapper.writeValueAsBytes(segments));
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return segmentAnnouncementPath;
    }

    protected void unannounceSegmentForServer(DruidServer druidServer, DataSegment segment, ZkPathsConfig zkPathsConfig) throws Exception {
        String path = ZKPaths.makePath((String)zkPathsConfig.getLiveSegmentsPath(), (String)druidServer.getHost(), (String[])new String[]{segment.getId().toString()});
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(path);
    }

    protected void unannounceSegmentFromBatchForServer(DruidServer druidServer, DataSegment segment, String batchPath, ZkPathsConfig zkPathsConfig) throws Exception {
        ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(batchPath);
    }

    protected void tearDownServerAndCurator() {
        try {
            this.curator.close();
            this.server.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

