/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.org.apache.druid.concurrent.ConcurrentAwaitableCounter;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentAwaitableCounterTest {
    @Test(timeout=60000L)
    public void smokeTest() throws InterruptedException {
        ConcurrentAwaitableCounter counter = new ConcurrentAwaitableCounter();
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch finish = new CountDownLatch(7);
        for (int i = 0; i < 2; ++i) {
            new Thread(() -> {
                try {
                    start.await();
                    for (int j = 0; j < 10000; ++j) {
                        counter.increment();
                    }
                    finish.countDown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }).start();
        }
        for (int awaitCount : new int[]{0, 1, 100, 10000, 20000}) {
            new Thread(() -> {
                try {
                    start.await();
                    counter.awaitCount((long)awaitCount);
                    finish.countDown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }).start();
        }
        start.countDown();
        finish.await();
    }

    @Test
    public void testAwaitFirstUpdate() throws InterruptedException {
        int[] value = new int[1];
        ConcurrentAwaitableCounter counter = new ConcurrentAwaitableCounter();
        Thread t = new Thread(() -> {
            try {
                Assert.assertTrue((boolean)counter.awaitFirstIncrement(10L, TimeUnit.SECONDS));
                Assert.assertEquals((long)1L, (long)value[0]);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        t.start();
        Thread.sleep(2000L);
        value[0] = 1;
        counter.increment();
        t.join();
    }
}

