/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.org.apache.druid.common.utils.SerializerUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SerializerUtilsTest {
    private SerializerUtils serializerUtils;
    private final float delta = 0.0f;
    private final String[] strings = new String[]{"1#", "2", "3"};
    private final int[] ints = new int[]{1, 2, 3};
    private final float[] floats = new float[]{1.1f, 2.0f, 3.0f};
    private final long[] longs = new long[]{3L, 2L, 1L};
    private byte[] stringsByte;
    private byte[] intsByte;
    private byte[] floatsByte;
    private byte[] longsByte;
    private ByteArrayOutputStream outStream;

    @Before
    public void setUpByteArrays() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        out.writeInt(this.strings.length);
        for (String string : this.strings) {
            byte[] stringBytes = StringUtils.toUtf8((String)string);
            out.writeInt(stringBytes.length);
            out.write(StringUtils.toUtf8((String)string));
        }
        out.close();
        this.stringsByte = bos.toByteArray();
        bos.close();
        bos = new ByteArrayOutputStream();
        out = new DataOutputStream(bos);
        out.writeInt(this.ints.length);
        for (int e : this.ints) {
            out.writeInt(e);
        }
        out.close();
        this.intsByte = bos.toByteArray();
        bos.close();
        bos = new ByteArrayOutputStream();
        out = new DataOutputStream(bos);
        out.writeInt(this.floats.length);
        for (float e : this.floats) {
            out.writeFloat(e);
        }
        out.close();
        this.floatsByte = bos.toByteArray();
        bos.close();
        bos = new ByteArrayOutputStream();
        out = new DataOutputStream(bos);
        out.writeInt(this.longs.length);
        for (long e : this.longs) {
            out.writeLong(e);
        }
        out.close();
        this.longsByte = bos.toByteArray();
        bos.close();
        this.serializerUtils = new SerializerUtils();
        this.outStream = new ByteArrayOutputStream();
    }

    @Test
    public void testWriteInts() throws IOException {
        this.serializerUtils.writeInts((OutputStream)this.outStream, this.ints);
        byte[] actuals = this.outStream.toByteArray();
        Assert.assertArrayEquals((byte[])this.intsByte, (byte[])actuals);
    }

    @Test
    public void testWriteFloats() throws IOException {
        this.serializerUtils.writeFloats((OutputStream)this.outStream, this.floats);
        byte[] actuals = this.outStream.toByteArray();
        Assert.assertArrayEquals((byte[])this.floatsByte, (byte[])actuals);
    }

    @Test
    public void testChannelWritefloat() throws IOException {
        boolean index = false;
        WritableByteChannel channelOutput = Channels.newChannel(this.outStream);
        this.serializerUtils.writeFloat(channelOutput, this.floats[0]);
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.outStream.toByteArray());
        if (channelOutput != null) {
            channelOutput.close();
        }
        float expected = this.serializerUtils.readFloat((InputStream)inputstream);
        float actuals = this.floats[0];
        Assert.assertEquals((float)expected, (float)actuals, (float)0.0f);
    }

    @Test
    public void testWriteLongs() throws IOException {
        this.serializerUtils.writeLongs((OutputStream)this.outStream, this.longs);
        byte[] actuals = this.outStream.toByteArray();
        Assert.assertArrayEquals((byte[])this.longsByte, (byte[])actuals);
    }

    @Test
    public void testChannelWritelong() throws IOException {
        boolean index = false;
        WritableByteChannel channelOutput = Channels.newChannel(this.outStream);
        this.serializerUtils.writeLong(channelOutput, this.longs[0]);
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.outStream.toByteArray());
        channelOutput.close();
        inputstream.close();
        long expected = this.serializerUtils.readLong((InputStream)inputstream);
        long actuals = this.longs[0];
        Assert.assertEquals((long)expected, (long)actuals);
    }

    @Test
    public void testReadInts() throws IOException {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.intsByte);
        int[] actuals = this.serializerUtils.readInts((InputStream)inputstream);
        inputstream.close();
        Assert.assertArrayEquals((int[])this.ints, (int[])actuals);
    }

    @Test
    public void testReadFloats() throws IOException {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.floatsByte);
        float[] actuals = this.serializerUtils.readFloats((InputStream)inputstream);
        inputstream.close();
        Assert.assertArrayEquals((float[])this.floats, (float[])actuals, (float)0.0f);
    }

    @Test
    public void testReadLongs() throws IOException {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.longsByte);
        long[] actuals = this.serializerUtils.readLongs((InputStream)inputstream);
        inputstream.close();
        Assert.assertArrayEquals((long[])this.longs, (long[])actuals);
    }

    @Test
    public void testReadStrings() throws IOException {
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.stringsByte);
        Object[] actuals = this.serializerUtils.readStrings((InputStream)inputstream);
        inputstream.close();
        Assert.assertArrayEquals((Object[])this.strings, (Object[])actuals);
    }

    @Test
    public void testChannelWriteString() throws IOException {
        boolean index = false;
        WritableByteChannel channelOutput = Channels.newChannel(this.outStream);
        this.serializerUtils.writeString(channelOutput, this.strings[0]);
        ByteArrayInputStream inputstream = new ByteArrayInputStream(this.outStream.toByteArray());
        channelOutput.close();
        inputstream.close();
        String expected = this.serializerUtils.readString((InputStream)inputstream);
        String actuals = this.strings[0];
        Assert.assertEquals((Object)expected, (Object)actuals);
    }

    @Test
    public void testByteBufferReadStrings() {
        ByteBuffer buffer = ByteBuffer.allocate(this.stringsByte.length);
        buffer.put(this.stringsByte);
        buffer.flip();
        Object[] actuals = this.serializerUtils.readStrings(buffer);
        Assert.assertArrayEquals((Object[])this.strings, (Object[])actuals);
    }

    @After
    public void tearDown() throws IOException {
        this.serializerUtils = null;
        this.outStream.close();
    }
}

