/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.common.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.JodaUtils;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class JodaUtilsTest {
    @Test
    public void testUmbrellaIntervalsSimple() {
        List<Interval> intervals = Arrays.asList(Intervals.of((String)"2011-03-03/2011-03-04"), Intervals.of((String)"2011-01-01/2011-01-02"), Intervals.of((String)"2011-02-01/2011-02-05"), Intervals.of((String)"2011-02-03/2011-02-08"), Intervals.of((String)"2011-01-01/2011-01-03"), Intervals.of((String)"2011-03-01/2011-03-02"), Intervals.of((String)"2011-03-05/2011-03-06"), Intervals.of((String)"2011-02-01/2011-02-02"));
        Assert.assertEquals((Object)Intervals.of((String)"2011-01-01/2011-03-06"), (Object)JodaUtils.umbrellaInterval(intervals));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUmbrellaIntervalsNull() {
        JodaUtils.umbrellaInterval(Collections.emptyList());
    }

    @Test
    public void testCondenseIntervalsSimple() {
        List<Interval> intervals = Arrays.asList(Intervals.of((String)"2011-01-01/2011-01-02"), Intervals.of((String)"2011-01-02/2011-01-03"), Intervals.of((String)"2011-02-01/2011-02-05"), Intervals.of((String)"2011-02-01/2011-02-02"), Intervals.of((String)"2011-02-03/2011-02-08"), Intervals.of((String)"2011-03-01/2011-03-02"), Intervals.of((String)"2011-03-03/2011-03-04"), Intervals.of((String)"2011-03-05/2011-03-06"));
        Assert.assertEquals(Arrays.asList(Intervals.of((String)"2011-01-01/2011-01-03"), Intervals.of((String)"2011-02-01/2011-02-08"), Intervals.of((String)"2011-03-01/2011-03-02"), Intervals.of((String)"2011-03-03/2011-03-04"), Intervals.of((String)"2011-03-05/2011-03-06")), (Object)JodaUtils.condenseIntervals(intervals));
    }

    @Test
    public void testCondenseIntervalsMixedUp() {
        List<Interval> intervals = Arrays.asList(Intervals.of((String)"2011-01-01/2011-01-02"), Intervals.of((String)"2011-01-02/2011-01-03"), Intervals.of((String)"2011-02-01/2011-02-05"), Intervals.of((String)"2011-02-01/2011-02-02"), Intervals.of((String)"2011-02-03/2011-02-08"), Intervals.of((String)"2011-03-01/2011-03-02"), Intervals.of((String)"2011-03-03/2011-03-04"), Intervals.of((String)"2011-03-05/2011-03-06"), Intervals.of((String)"2011-04-01/2011-04-05"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-05-01/2011-05-05"), Intervals.of((String)"2011-05-02/2011-05-07"));
        for (int i = 0; i < 20; ++i) {
            Collections.shuffle(intervals);
            Assert.assertEquals(Arrays.asList(Intervals.of((String)"2011-01-01/2011-01-03"), Intervals.of((String)"2011-02-01/2011-02-08"), Intervals.of((String)"2011-03-01/2011-03-02"), Intervals.of((String)"2011-03-03/2011-03-04"), Intervals.of((String)"2011-03-05/2011-03-06"), Intervals.of((String)"2011-04-01/2011-04-05"), Intervals.of((String)"2011-05-01/2011-05-07")), (Object)JodaUtils.condenseIntervals(intervals));
        }
    }

    @Test
    public void testMinMaxInterval() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)Intervals.ETERNITY.toDuration().getMillis());
    }

    @Test
    public void testMinMaxDuration() {
        Duration duration = Intervals.ETERNITY.toDuration();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)duration.getMillis());
        Assert.assertEquals((Object)"PT9223372036854775.807S", (Object)duration.toString());
    }

    @Test(expected=ArithmeticException.class)
    public void testMinMaxPeriod() {
        Period period = Intervals.ETERNITY.toDuration().toPeriod();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)period.getMinutes());
    }
}

