/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.spatial.split;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.Assert;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.spatial.Node;
import org.apache.hive.druid.org.apache.druid.collections.spatial.Point;
import org.apache.hive.druid.org.apache.druid.collections.spatial.RTree;
import org.apache.hive.druid.org.apache.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.hive.druid.org.apache.druid.collections.spatial.split.SplitStrategy;
import org.junit.Test;

public class LinearGutmanSplitStrategyTest {
    @Test
    public void testPickSeeds() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        LinearGutmanSplitStrategy strategy = new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf);
        Node node = new Node(new float[2], new float[2], true, (BitmapFactory)bf);
        node.addChild((Node)new Point(new float[]{3.0f, 7.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{1.0f, 6.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{9.0f, 8.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{2.0f, 5.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{4.0f, 4.0f}, 1, (BitmapFactory)bf));
        node.enclose();
        Node[] groups = strategy.split(node);
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[0]), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[1]), (Object)Float.valueOf(4.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[0]), (Object)Float.valueOf(9.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[1]), (Object)Float.valueOf(8.0f));
    }

    @Test
    public void testPickSeedsRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        LinearGutmanSplitStrategy strategy = new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf);
        Node node = new Node(new float[2], new float[2], true, (BitmapFactory)bf);
        node.addChild((Node)new Point(new float[]{3.0f, 7.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{1.0f, 6.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{9.0f, 8.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{2.0f, 5.0f}, 1, (BitmapFactory)bf));
        node.addChild((Node)new Point(new float[]{4.0f, 4.0f}, 1, (BitmapFactory)bf));
        node.enclose();
        Node[] groups = strategy.split(node);
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[0]), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[0].getMinCoordinates()[1]), (Object)Float.valueOf(4.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[0]), (Object)Float.valueOf(9.0f));
        Assert.assertEquals((Object)Float.valueOf(groups[1].getMinCoordinates()[1]), (Object)Float.valueOf(8.0f));
    }

    @Test
    public void testNumChildrenSize() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            tree.insert(new float[]{((Random)rand).nextFloat(), ((Random)rand).nextFloat()}, i);
        }
        Assert.assertTrue((this.getNumPoints(tree.getRoot()) >= tree.getSize() ? 1 : 0) != 0);
    }

    @Test
    public void testNumChildrenSizeRoaring() {
        RoaringBitmapFactory bf = new RoaringBitmapFactory();
        RTree tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            tree.insert(new float[]{((Random)rand).nextFloat(), ((Random)rand).nextFloat()}, i);
        }
        Assert.assertTrue((this.getNumPoints(tree.getRoot()) >= tree.getSize() ? 1 : 0) != 0);
    }

    private int getNumPoints(Node node) {
        int total = 0;
        if (node.isLeaf()) {
            total += node.getChildren().size();
        } else {
            for (Node child : node.getChildren()) {
                total += this.getNumPoints(child);
            }
        }
        return total;
    }
}

