/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.spatial;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import junit.framework.Assert;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.spatial.RTree;
import org.apache.hive.druid.org.apache.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.hive.druid.org.apache.druid.collections.spatial.split.SplitStrategy;
import org.junit.Before;
import org.junit.Test;

public class RTreeTest {
    private RTree tree;
    private RTree roaringtree;

    @Before
    public void setUp() {
        ConciseBitmapFactory bf = new ConciseBitmapFactory();
        this.tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)bf), (BitmapFactory)bf);
        RoaringBitmapFactory rbf = new RoaringBitmapFactory();
        this.roaringtree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, (BitmapFactory)rbf), (BitmapFactory)rbf);
    }

    @Test
    public void testInsertNoSplit() {
        float[] elem = new float[]{5.0f, 5.0f};
        this.tree.insert(elem, 1);
        Assert.assertTrue((boolean)Arrays.equals(elem, this.tree.getRoot().getMinCoordinates()));
        Assert.assertTrue((boolean)Arrays.equals(elem, this.tree.getRoot().getMaxCoordinates()));
        this.tree.insert(new float[]{6.0f, 7.0f}, 2);
        this.tree.insert(new float[]{1.0f, 3.0f}, 3);
        this.tree.insert(new float[]{10.0f, 4.0f}, 4);
        this.tree.insert(new float[]{8.0f, 2.0f}, 5);
        Assert.assertEquals((int)this.tree.getRoot().getChildren().size(), (int)5);
        float[] expectedMin = new float[]{1.0f, 2.0f};
        float[] expectedMax = new float[]{10.0f, 7.0f};
        Assert.assertTrue((boolean)Arrays.equals(expectedMin, this.tree.getRoot().getMinCoordinates()));
        Assert.assertTrue((boolean)Arrays.equals(expectedMax, this.tree.getRoot().getMaxCoordinates()));
        Assert.assertEquals((Object)this.tree.getRoot().getArea(), (Object)45.0);
    }

    @Test
    public void testInsertDuplicatesNoSplit() {
        this.tree.insert(new float[]{1.0f, 1.0f}, 1);
        this.tree.insert(new float[]{1.0f, 1.0f}, 1);
        this.tree.insert(new float[]{1.0f, 1.0f}, 1);
        Assert.assertEquals((int)this.tree.getRoot().getChildren().size(), (int)3);
    }

    @Test
    public void testInsertDuplicatesNoSplitRoaring() {
        this.roaringtree.insert(new float[]{1.0f, 1.0f}, 1);
        this.roaringtree.insert(new float[]{1.0f, 1.0f}, 1);
        this.roaringtree.insert(new float[]{1.0f, 1.0f}, 1);
        Assert.assertEquals((int)this.roaringtree.getRoot().getChildren().size(), (int)3);
    }

    @Test
    public void testSplitOccurs() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            this.tree.insert(new float[]{((Random)rand).nextFloat(), ((Random)rand).nextFloat()}, i);
        }
        Assert.assertTrue((this.tree.getRoot().getChildren().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testSplitOccursRoaring() {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 100; ++i) {
            this.roaringtree.insert(new float[]{((Random)rand).nextFloat(), ((Random)rand).nextFloat()}, i);
        }
        Assert.assertTrue((this.roaringtree.getRoot().getChildren().size() > 1 ? 1 : 0) != 0);
    }
}

