/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class WrappedRoaringBitmapTest {
    private final RoaringBitmapFactory factory;

    public WrappedRoaringBitmapTest(RoaringBitmapFactory factory) {
        this.factory = factory;
    }

    @Parameterized.Parameters
    public static List<RoaringBitmapFactory[]> factoryClasses() {
        return Arrays.asList({new RoaringBitmapFactory(false)}, {new RoaringBitmapFactory(true)});
    }

    private WrappedRoaringBitmap createWrappedRoaringBitmap() {
        WrappedRoaringBitmap set = (WrappedRoaringBitmap)this.factory.makeEmptyMutableBitmap();
        set.add(1);
        set.add(3);
        set.add(5);
        set.add(7);
        set.add(9);
        return set;
    }

    @Test
    public void testSerialize() {
        WrappedRoaringBitmap set = this.createWrappedRoaringBitmap();
        byte[] buffer = new byte[set.getSizeInBytes()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        set.serialize(byteBuffer);
        byteBuffer.flip();
        ImmutableBitmap immutableBitmap = new RoaringBitmapFactory().mapImmutableBitmap(byteBuffer);
        Assert.assertEquals((int)5, (int)immutableBitmap.size());
    }

    @Test
    public void testToByteArray() {
        WrappedRoaringBitmap set = this.createWrappedRoaringBitmap();
        ImmutableBitmap immutableBitmap = new RoaringBitmapFactory().mapImmutableBitmap(ByteBuffer.wrap(set.toBytes()));
        Assert.assertEquals((int)5, (int)immutableBitmap.size());
    }
}

