/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import java.util.BitSet;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapBenchmark;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.collections.test.annotation.Benchmark;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={Benchmark.class})
@BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20)
public class UniformBitmapBenchmarkTest
extends BitmapBenchmark {
    public static final double DENSITY = 0.01;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareMostlyUniform() throws Exception {
        int i;
        System.setProperty("jub.customkey", StringUtils.format((String)"%05.4f", (Object[])new Object[]{0.01}));
        UniformBitmapBenchmarkTest.reset();
        BitSet expectedUnion = new BitSet();
        int[] knownTrue = new int[50];
        for (i = 0; i < knownTrue.length; ++i) {
            knownTrue[i] = rand.nextInt(500000);
        }
        for (i = 0; i < 10000; ++i) {
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            for (int k = 0; k < 500000; ++k) {
                if (!(rand.nextDouble() < 0.01)) continue;
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            for (int k : knownTrue) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
            }
            UniformBitmapBenchmarkTest.CONCISE[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            UniformBitmapBenchmarkTest.OFF_HEAP_CONCISE[i] = UniformBitmapBenchmarkTest.makeOffheapConcise(CONCISE[i]);
            UniformBitmapBenchmarkTest.ROARING[i] = r;
            UniformBitmapBenchmarkTest.IMMUTABLE_ROARING[i] = UniformBitmapBenchmarkTest.makeImmutableRoaring(r);
            UniformBitmapBenchmarkTest.OFF_HEAP_ROARING[i] = UniformBitmapBenchmarkTest.makeOffheapRoaring(r);
            UniformBitmapBenchmarkTest.GENERIC_CONCISE[i] = new WrappedImmutableConciseBitmap(OFF_HEAP_CONCISE[i]);
            UniformBitmapBenchmarkTest.GENERIC_ROARING[i] = new WrappedImmutableRoaringBitmap(OFF_HEAP_ROARING[i]);
        }
        unionCount = expectedUnion.cardinality();
        minIntersection = knownTrue.length;
        UniformBitmapBenchmarkTest.printSizeStats(0.01, "Uniform Bitmap");
    }
}

