/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import java.util.BitSet;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.BitmapBenchmark;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.collections.test.annotation.Benchmark;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={Benchmark.class})
@BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20)
public class RangeBitmapBenchmarkTest
extends BitmapBenchmark {
    public static final double DENSITY = 0.001;
    public static final int MIN_INTERSECT = 50;

    @BeforeClass
    public static void prepareRandomRanges() throws Exception {
        System.setProperty("jub.customkey", StringUtils.format((String)"%06.5f", (Object[])new Object[]{0.001}));
        RangeBitmapBenchmarkTest.reset();
        BitSet expectedUnion = new BitSet();
        for (int i = 0; i < 10000; ++i) {
            int k;
            int runLength;
            ConciseSet c = new ConciseSet();
            MutableRoaringBitmap r = new MutableRoaringBitmap();
            boolean fill = true;
            for (k = 0; k < 500000; k += runLength) {
                runLength = 500 + rand.nextInt(500);
                for (int j = k; fill && j < 500000 && j < k + runLength; ++j) {
                    c.add(j);
                    r.add(j);
                    expectedUnion.set(j);
                }
                fill = !fill;
            }
            minIntersection = 50L;
            k = 250000;
            while ((long)k < 250000L + minIntersection) {
                c.add(k);
                r.add(k);
                expectedUnion.set(k);
                ++k;
            }
            RangeBitmapBenchmarkTest.CONCISE[i] = ImmutableConciseSet.newImmutableFromMutable((ConciseSet)c);
            RangeBitmapBenchmarkTest.OFF_HEAP_CONCISE[i] = RangeBitmapBenchmarkTest.makeOffheapConcise(CONCISE[i]);
            RangeBitmapBenchmarkTest.ROARING[i] = r;
            RangeBitmapBenchmarkTest.IMMUTABLE_ROARING[i] = RangeBitmapBenchmarkTest.makeImmutableRoaring(r);
            RangeBitmapBenchmarkTest.OFF_HEAP_ROARING[i] = RangeBitmapBenchmarkTest.makeOffheapRoaring(r);
            RangeBitmapBenchmarkTest.GENERIC_CONCISE[i] = new WrappedImmutableConciseBitmap(OFF_HEAP_CONCISE[i]);
            RangeBitmapBenchmarkTest.GENERIC_ROARING[i] = new WrappedImmutableRoaringBitmap(OFF_HEAP_ROARING[i]);
        }
        unionCount = expectedUnion.cardinality();
        RangeBitmapBenchmarkTest.printSizeStats(0.001, "Random Alternating Bitmap");
    }
}

