/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.junit.Test;

public class ConciseBitmapFactoryTest {
    @Test
    public void testUnwrapWithNull() {
        ConciseBitmapFactory factory = new ConciseBitmapFactory();
        ImmutableBitmap bitmap = factory.union(Iterables.transform(Collections.singletonList(new WrappedConciseBitmap()), (Function)new Function<WrappedConciseBitmap, ImmutableBitmap>(){

            public ImmutableBitmap apply(WrappedConciseBitmap input) {
                return null;
            }
        }));
        Assert.assertEquals((int)0, (int)bitmap.size());
    }

    @Test
    public void testUnwrapMerge() {
        ConciseBitmapFactory factory = new ConciseBitmapFactory();
        WrappedConciseBitmap set = new WrappedConciseBitmap();
        set.add(1);
        set.add(3);
        set.add(5);
        ImmutableBitmap bitmap = factory.union(Arrays.asList(factory.makeImmutableBitmap((MutableBitmap)set), null));
        Assert.assertEquals((int)3, (int)bitmap.size());
    }

    @Test
    public void testGetOutOfBounds() {
        ConciseSet conciseSet = new ConciseSet();
        ImmutableSet ints = ImmutableSet.of((Object)0, (Object)4, (Object)9);
        Iterator iterator = ints.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            conciseSet.add(i);
        }
        WrappedImmutableConciseBitmap immutableBitmap = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)conciseSet));
        WrappedConciseBitmap mutableBitmap = new WrappedConciseBitmap(conciseSet);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((String)Integer.toString(i), (boolean)ints.contains(i), (boolean)mutableBitmap.get(i));
            Assert.assertEquals((String)Integer.toString(i), (boolean)ints.contains(i), (boolean)immutableBitmap.get(i));
        }
    }
}

