/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import org.apache.hive.druid.org.apache.druid.collections.IntSetTestUtility;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedImmutableConciseBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.WrappedRoaringBitmap;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ConciseSet;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.roaringbitmap.PeekableIntIterator;
import org.junit.Assert;
import org.junit.Test;

public class BitmapPeekableIteratorTest {
    @Test
    public void testBitSet() {
        WrappedBitSetBitmap bitmap = new WrappedBitSetBitmap();
        this.populate((MutableBitmap)bitmap);
        this.assertPeekable(bitmap.peekableIterator());
    }

    @Test
    public void testConciseMutable() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        this.populate((MutableBitmap)bitmap);
        this.assertPeekable(bitmap.peekableIterator());
    }

    @Test
    public void testConciseImmutable() {
        WrappedConciseBitmap bitmap = new WrappedConciseBitmap();
        this.populate((MutableBitmap)bitmap);
        WrappedImmutableConciseBitmap immutable = new WrappedImmutableConciseBitmap(ImmutableConciseSet.newImmutableFromMutable((ConciseSet)bitmap.getBitmap()));
        this.assertPeekable(immutable.peekableIterator());
    }

    @Test
    public void testRoaringMutable() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        this.populate((MutableBitmap)bitmap);
        this.assertPeekable(bitmap.peekableIterator());
    }

    @Test
    public void testRoaringImmutable() {
        WrappedRoaringBitmap bitmap = new WrappedRoaringBitmap();
        this.populate((MutableBitmap)bitmap);
        this.assertPeekable(bitmap.toImmutableBitmap().peekableIterator());
    }

    private void populate(MutableBitmap bitmap) {
        for (int i : IntSetTestUtility.getSetBits()) {
            bitmap.add(i);
        }
    }

    private void assertPeekable(PeekableIntIterator iterator) {
        Assert.assertTrue((boolean)iterator.hasNext());
        int mark = -1;
        for (int i : IntSetTestUtility.getSetBits()) {
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.advanceIfNeeded(i);
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.advanceIfNeeded(i);
            Assert.assertTrue((boolean)iterator.hasNext());
            if (iterator.hasNext()) {
                Assert.assertEquals((long)i, (long)iterator.peekNext());
                mark = iterator.next();
            }
            Assert.assertEquals((long)i, (long)mark);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

