/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections.bitmap;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.Clock;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ConciseBitmapFactory;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.org.apache.druid.collections.bitmap.RoaringBitmapFactory;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.extendedset.intset.ImmutableConciseSet;
import org.apache.hive.druid.org.roaringbitmap.buffer.BufferFastAggregation;
import org.apache.hive.druid.org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.apache.hive.druid.org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

@BenchmarkOptions(clock=Clock.NANO_TIME, benchmarkRounds=50)
public class BitmapBenchmark {
    public static final int LENGTH = 500000;
    public static final int SIZE = 10000;
    static final ImmutableConciseSet[] CONCISE = new ImmutableConciseSet[10000];
    static final ImmutableConciseSet[] OFF_HEAP_CONCISE = new ImmutableConciseSet[10000];
    static final ImmutableRoaringBitmap[] ROARING = new ImmutableRoaringBitmap[10000];
    static final ImmutableRoaringBitmap[] IMMUTABLE_ROARING = new ImmutableRoaringBitmap[10000];
    static final ImmutableRoaringBitmap[] OFF_HEAP_ROARING = new ImmutableRoaringBitmap[10000];
    static final ImmutableBitmap[] GENERIC_CONCISE = new ImmutableBitmap[10000];
    static final ImmutableBitmap[] GENERIC_ROARING = new ImmutableBitmap[10000];
    static final ConciseBitmapFactory CONCISE_FACTORY = new ConciseBitmapFactory();
    static final RoaringBitmapFactory ROARING_FACTORY = new RoaringBitmapFactory();
    static Random rand = new Random(0L);
    static long totalConciseBytes = 0L;
    static long totalRoaringBytes = 0L;
    static long conciseCount = 0L;
    static long roaringCount = 0L;
    static long unionCount = 0L;
    static long minIntersection = 0L;
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();

    protected static ImmutableConciseSet makeOffheapConcise(ImmutableConciseSet concise) {
        byte[] bytes = concise.toBytes();
        totalConciseBytes += (long)bytes.length;
        ++conciseCount;
        ByteBuffer buf = ByteBuffer.allocateDirect(bytes.length).put(bytes);
        buf.rewind();
        return new ImmutableConciseSet(buf.asIntBuffer());
    }

    protected static ImmutableRoaringBitmap writeImmutable(MutableRoaringBitmap r, ByteBuffer buf) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        r.serialize((DataOutput)new DataOutputStream(out));
        byte[] bytes = out.toByteArray();
        Assert.assertEquals((long)buf.remaining(), (long)bytes.length);
        buf.put(bytes);
        buf.rewind();
        return new ImmutableRoaringBitmap(buf.asReadOnlyBuffer());
    }

    protected static void reset() {
        conciseCount = 0L;
        roaringCount = 0L;
        totalConciseBytes = 0L;
        totalRoaringBytes = 0L;
        unionCount = 0L;
        minIntersection = 0L;
        rand = new Random(0L);
    }

    protected static void printSizeStats(double density, String name) {
        System.out.println();
        System.out.println("## " + name);
        System.out.println();
        System.out.printf(Locale.ENGLISH, " d = %06.5f | Concise | Roaring%n", density);
        System.out.println("-------------|---------|---------");
        System.out.printf(Locale.ENGLISH, "Count        |   %5d |   %5d %n", conciseCount, roaringCount);
        System.out.printf(Locale.ENGLISH, "Average size |   %5d |   %5d %n", totalConciseBytes / conciseCount, totalRoaringBytes / roaringCount);
        System.out.println("-------------|---------|---------");
        System.out.println();
        System.out.flush();
    }

    protected static ImmutableRoaringBitmap makeOffheapRoaring(MutableRoaringBitmap r) throws IOException {
        int size = r.serializedSizeInBytes();
        ByteBuffer buf = ByteBuffer.allocateDirect(size);
        totalRoaringBytes += (long)size;
        ++roaringCount;
        return BitmapBenchmark.writeImmutable(r, buf);
    }

    protected static ImmutableRoaringBitmap makeImmutableRoaring(MutableRoaringBitmap r) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(r.serializedSizeInBytes());
        return BitmapBenchmark.writeImmutable(r, buf);
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeConciseUnion() {
        ImmutableConciseSet union = ImmutableConciseSet.union((ImmutableConciseSet[])CONCISE);
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeOffheapConciseUnion() {
        ImmutableConciseSet union = ImmutableConciseSet.union((ImmutableConciseSet[])OFF_HEAP_CONCISE);
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=2)
    public void timeGenericConciseUnion() {
        ImmutableBitmap union = CONCISE_FACTORY.union(Arrays.asList(GENERIC_CONCISE));
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    @BenchmarkOptions(warmupRounds=1, benchmarkRounds=5)
    public void timeGenericConciseIntersection() {
        ImmutableBitmap intersection = CONCISE_FACTORY.intersection(Arrays.asList(GENERIC_CONCISE));
        Assert.assertTrue(((long)intersection.size() >= minIntersection ? 1 : 0) != 0);
    }

    @Test
    public void timeRoaringUnion() {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Arrays.asList(ROARING).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeImmutableRoaringUnion() {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Arrays.asList(IMMUTABLE_ROARING).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeOffheapRoaringUnion() {
        MutableRoaringBitmap union = BufferFastAggregation.horizontal_or(Arrays.asList(OFF_HEAP_ROARING).iterator());
        Assert.assertEquals((long)unionCount, (long)union.getCardinality());
    }

    @Test
    public void timeGenericRoaringUnion() {
        ImmutableBitmap union = ROARING_FACTORY.union(Arrays.asList(GENERIC_ROARING));
        Assert.assertEquals((long)unionCount, (long)union.size());
    }

    @Test
    public void timeGenericRoaringIntersection() {
        ImmutableBitmap intersection = ROARING_FACTORY.intersection(Arrays.asList(GENERIC_ROARING));
        Assert.assertTrue(((long)intersection.size() >= minIntersection ? 1 : 0) != 0);
    }

    static {
        NullHandling.initializeForTests();
    }
}

