/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.collections;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hive.druid.org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.hive.druid.org.apache.druid.collections.Releaser;
import org.junit.Assert;
import org.junit.Test;

public class ReferenceCountingResourceHolderTest {
    @Test
    public void testIdiomaticUsage() {
        for (int i = 0; i < 100; ++i) {
            this.runIdiomaticUsage();
        }
    }

    private void runIdiomaticUsage() {
        AtomicBoolean released = new AtomicBoolean(false);
        ReferenceCountingResourceHolder<Closeable> resourceHolder = this.makeReleasingHandler(released);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 100; ++i) {
            Thread thread = new Thread(() -> {
                try (Releaser r = resourceHolder.increment();){
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.assertFalse((boolean)released.get());
        resourceHolder.close();
        Assert.assertTrue((boolean)released.get());
    }

    private ReferenceCountingResourceHolder<Closeable> makeReleasingHandler(final AtomicBoolean released) {
        return ReferenceCountingResourceHolder.fromCloseable((Closeable)new Closeable(){

            @Override
            public void close() {
                released.set(true);
            }
        });
    }

    @Test(timeout=60000L)
    public void testResourceHandlerClearedByJVM() throws InterruptedException {
        long initialLeakedResources = ReferenceCountingResourceHolder.leakedResources();
        AtomicBoolean released = new AtomicBoolean(false);
        this.makeReleasingHandler(released);
        this.verifyCleanerRun(released, initialLeakedResources);
    }

    @Test(timeout=60000L)
    public void testResourceHandlerWithReleaserClearedByJVM() throws InterruptedException {
        long initialLeakedResources = ReferenceCountingResourceHolder.leakedResources();
        AtomicBoolean released = new AtomicBoolean(false);
        this.createDanglingReleaser(released);
        this.verifyCleanerRun(released, initialLeakedResources);
    }

    private void createDanglingReleaser(AtomicBoolean released) {
        try (ReferenceCountingResourceHolder<Closeable> handler = this.makeReleasingHandler(released);){
            handler.increment();
        }
    }

    private void verifyCleanerRun(AtomicBoolean released, long initialLeakedResources) throws InterruptedException {
        for (int i = 0; i < 6000 && ReferenceCountingResourceHolder.leakedResources() == initialLeakedResources; ++i) {
            System.gc();
            byte[] garbage = new byte[10000000];
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)(initialLeakedResources + 1L), (long)ReferenceCountingResourceHolder.leakedResources());
        Assert.assertTrue((boolean)released.get());
    }
}

