/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.selector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.org.apache.druid.client.DirectDruidClient;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.CustomTierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.CustomTierSelectorStrategyConfig;
import org.apache.hive.druid.org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.LowestPriorityTierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelector;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class TierSelectorStrategyTest {
    @Test
    public void testHighestPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()), highPriority, lowPriority);
    }

    @Test
    public void testLowestPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new LowestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()), lowPriority, highPriority);
    }

    @Test
    public void testCustomPriorityTierSelectorStrategy() {
        DirectDruidClient client = (DirectDruidClient)EasyMock.createMock(DirectDruidClient.class);
        QueryableDruidServer lowPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", -1), (QueryRunner)client);
        QueryableDruidServer mediumPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client);
        QueryableDruidServer highPriority = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 1), (QueryRunner)client);
        this.testTierSelectorStrategy((TierSelectorStrategy)new CustomTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy(), new CustomTierSelectorStrategyConfig(){

            public List<Integer> getPriorities() {
                return Arrays.asList(2, 0, -1, 1);
            }
        }), mediumPriority, lowPriority, highPriority);
    }

    private void testTierSelectorStrategy(TierSelectorStrategy tierSelectorStrategy, QueryableDruidServer ... expectedSelection) {
        ServerSelector serverSelector = new ServerSelector(new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L), tierSelectorStrategy);
        ArrayList<QueryableDruidServer> servers = new ArrayList<QueryableDruidServer>(Arrays.asList(expectedSelection));
        ArrayList<DruidServerMetadata> expectedCandidates = new ArrayList<DruidServerMetadata>();
        for (QueryableDruidServer server : servers) {
            expectedCandidates.add(server.getServer().getMetadata());
        }
        Collections.shuffle(servers);
        for (QueryableDruidServer server : servers) {
            serverSelector.addServerAndUpdateSegment(server, serverSelector.getSegment());
        }
        Assert.assertEquals((Object)expectedSelection[0], (Object)serverSelector.pick());
        Assert.assertEquals(expectedCandidates, (Object)serverSelector.getCandidates(-1));
        Assert.assertEquals(expectedCandidates.subList(0, 2), (Object)serverSelector.getCandidates(2));
    }
}

