/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import com.google.caliper.Param;
import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.MemcachedCache;
import org.apache.hive.druid.org.apache.druid.client.cache.MemcachedCacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.MemcachedCacheTest;
import org.apache.hive.druid.org.apache.druid.collections.StupidResourceHolder;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;

public class MemcachedCacheBenchmark
extends SimpleBenchmark {
    public static final String NAMESPACE = "default";
    private static final String BASE_KEY = "test_2012-11-26T00:00:00.000Z_2012-11-27T00:00:00.000Z_2012-11-27T04:11:25.979Z_";
    private static byte[] randBytes;
    @Param(value={"localhost:11211"})
    String hosts;
    @Param(value={"1", "5", "10", "40"})
    int objectSize;
    @Param(value={"100", "1000"})
    int objectCount;
    private MemcachedCache cache;
    private MemcachedClientIF client;

    public static void main(String[] args) {
        Runner.main(MemcachedCacheBenchmark.class, (String[])args);
    }

    protected void setUp() throws Exception {
        SerializingTranscoder transcoder = new SerializingTranscoder(0x3200000);
        transcoder.setCompressionThreshold(Integer.MAX_VALUE);
        this.client = new MemcachedClient(new ConnectionFactoryBuilder().setProtocol(ConnectionFactoryBuilder.Protocol.BINARY).setHashAlg((HashAlgorithm)DefaultHashAlgorithm.FNV1A_64_HASH).setLocatorType(ConnectionFactoryBuilder.Locator.CONSISTENT).setDaemon(true).setFailureMode(FailureMode.Retry).setTranscoder((Transcoder)transcoder).setShouldOptimize(true).build(), AddrUtil.getAddresses((String)this.hosts));
        this.cache = new MemcachedCache(Suppliers.ofInstance((Object)StupidResourceHolder.create((Object)this.client)), new MemcachedCacheConfig(){

            public String getMemcachedPrefix() {
                return "druid-memcached-benchmark";
            }

            public int getTimeout() {
                return 30000;
            }

            public int getExpiration() {
                return 3600;
            }
        }, MemcachedCacheTest.NOOP_MONITOR);
        randBytes = new byte[this.objectSize * 1024];
        new Random(0L).nextBytes(randBytes);
    }

    protected void tearDown() {
        this.client.shutdown(1L, TimeUnit.MINUTES);
    }

    public void timePutObjects(int reps) {
        for (int i = 0; i < reps; ++i) {
            for (int k = 0; k < this.objectCount; ++k) {
                String key = BASE_KEY + k;
                this.cache.put(new Cache.NamedKey(NAMESPACE, StringUtils.toUtf8((String)key)), randBytes);
            }
            this.client.waitForQueues(1L, TimeUnit.HOURS);
        }
    }

    public long timeGetObject(int reps) {
        long count = 0L;
        for (int i = 0; i < reps; ++i) {
            for (int k = 0; k < this.objectCount; ++k) {
                String key = BASE_KEY + k;
                byte[] bytes = this.cache.get(new Cache.NamedKey(NAMESPACE, StringUtils.toUtf8((String)key)));
                count += (long)bytes.length;
            }
        }
        return count;
    }

    public long timeBulkGetObjects(int reps) {
        long count = 0L;
        for (int i = 0; i < reps; ++i) {
            ArrayList<Cache.NamedKey> keys = new ArrayList<Cache.NamedKey>();
            for (int k = 0; k < this.objectCount; ++k) {
                String key = BASE_KEY + k;
                keys.add(new Cache.NamedKey(NAMESPACE, StringUtils.toUtf8((String)key)));
            }
            Map results = this.cache.getBulk(keys);
            for (Cache.NamedKey key : keys) {
                byte[] bytes = (byte[])results.get(key);
                count += (long)bytes.length;
            }
        }
        return count;
    }
}

