/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.org.apache.druid.client.cache.MemcacheClientPool;
import org.junit.Assert;
import org.junit.Test;

public class MemcacheClientPoolTest {
    @Test
    public void testSimpleUsage() {
        MemcacheClientPool pool = new MemcacheClientPool(3, Suppliers.ofInstance((Object)null));
        MemcacheClientPool.IdempotentCloseableHolder first = pool.get();
        Assert.assertEquals((long)1L, (long)first.count());
        MemcacheClientPool.IdempotentCloseableHolder second = pool.get();
        Assert.assertEquals((long)1L, (long)second.count());
        MemcacheClientPool.IdempotentCloseableHolder third = pool.get();
        Assert.assertEquals((long)1L, (long)third.count());
        MemcacheClientPool.IdempotentCloseableHolder firstClientSecondRound = pool.get();
        Assert.assertEquals((long)2L, (long)firstClientSecondRound.count());
        MemcacheClientPool.IdempotentCloseableHolder secondClientSecondRound = pool.get();
        Assert.assertEquals((long)2L, (long)secondClientSecondRound.count());
        first.close();
        firstClientSecondRound.close();
        MemcacheClientPool.IdempotentCloseableHolder firstAgain = pool.get();
        Assert.assertEquals((long)1L, (long)firstAgain.count());
        firstAgain.close();
        second.close();
        third.close();
        secondClientSecondRound.close();
    }

    @Test
    public void testClientLeakDetected() throws InterruptedException {
        long initialLeakedClients = MemcacheClientPool.leakedClients();
        this.createDanglingClient();
        for (int i = 0; i < 6000 && MemcacheClientPool.leakedClients() == initialLeakedClients; ++i) {
            System.gc();
            byte[] garbage = new byte[10000000];
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)(initialLeakedClients + 1L), (long)MemcacheClientPool.leakedClients());
    }

    private void createDanglingClient() {
        MemcacheClientPool pool = new MemcacheClientPool(1, Suppliers.ofInstance((Object)null));
        pool.get();
    }
}

