/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.client.cache.ByteCountingLRUMap;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.MapCache;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MapCacheTest {
    private static final byte[] HI = StringUtils.toUtf8((String)"hi");
    private static final byte[] HO = StringUtils.toUtf8((String)"ho");
    private ByteCountingLRUMap baseMap;
    private MapCache cache;

    @Before
    public void setUp() {
        this.baseMap = new ByteCountingLRUMap(0x100000L);
        this.cache = new MapCache(this.baseMap);
    }

    @Test
    public void testSanity() {
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HI)));
        Assert.assertEquals((long)0L, (long)this.baseMap.size());
        this.put((Cache)this.cache, "a", HI, 1);
        Assert.assertEquals((long)1L, (long)this.baseMap.size());
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("the", HI)));
        this.put((Cache)this.cache, "the", HI, 2);
        Assert.assertEquals((long)2L, (long)this.baseMap.size());
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertEquals((long)2L, (long)this.get((Cache)this.cache, "the", HI));
        this.put((Cache)this.cache, "the", HO, 10);
        Assert.assertEquals((long)3L, (long)this.baseMap.size());
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HO)));
        Assert.assertEquals((long)2L, (long)this.get((Cache)this.cache, "the", HI));
        Assert.assertEquals((long)10L, (long)this.get((Cache)this.cache, "the", HO));
        this.cache.close("the");
        Assert.assertEquals((long)1L, (long)this.baseMap.size());
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HO)));
        this.cache.close("a");
        Assert.assertEquals((long)0L, (long)this.baseMap.size());
    }

    public void put(Cache cache, String namespace, byte[] key, Integer value) {
        cache.put(new Cache.NamedKey(namespace, key), Ints.toByteArray((int)value));
    }

    public int get(Cache cache, String namespace, byte[] key) {
        return Ints.fromByteArray((byte[])cache.get(new Cache.NamedKey(namespace, key)));
    }
}

