/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.client.cache.Cache;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheProvider;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheStats;
import org.apache.hive.druid.org.apache.druid.client.cache.CaffeineCache;
import org.apache.hive.druid.org.apache.druid.client.cache.CaffeineCacheConfig;
import org.apache.hive.druid.org.apache.druid.client.cache.CaffeineCacheProvider;
import org.apache.hive.druid.org.apache.druid.client.cache.CaffeineCacheProviderWithConfig;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.initialization.Initialization;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CaffeineCacheTest {
    private static final byte[] HI = StringUtils.toUtf8((String)"hiiiiiiiiiiiiiiiiiii");
    private static final byte[] HO = StringUtils.toUtf8((String)"hooooooooooooooooooo");
    private CaffeineCache cache;
    private final CaffeineCacheConfig cacheConfig = new CaffeineCacheConfig(){

        public boolean isEvictOnClose() {
            return true;
        }
    };

    @Before
    public void setUp() {
        this.cache = CaffeineCache.create((CaffeineCacheConfig)this.cacheConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicInjection() throws Exception {
        CaffeineCacheConfig config = new CaffeineCacheConfig();
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test/redis");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            binder.bind(CaffeineCacheConfig.class).toInstance((Object)config);
            binder.bind(Cache.class).toProvider(CaffeineCacheProviderWithConfig.class).in(ManageLifecycle.class);
        }));
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        lifecycle.start();
        try {
            Cache cache = (Cache)injector.getInstance(Cache.class);
            Assert.assertEquals(CaffeineCache.class, cache.getClass());
        }
        finally {
            lifecycle.stop();
        }
    }

    @Test
    public void testSimpleInjection() {
        String uuid = UUID.randomUUID().toString();
        System.setProperty(uuid + ".type", "caffeine");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test/redis");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            binder.bind(Cache.class).toProvider(CacheProvider.class);
            JsonConfigProvider.bind((Binder)binder, (String)uuid, CacheProvider.class);
        }));
        CacheProvider cacheProvider = (CacheProvider)injector.getInstance(CacheProvider.class);
        Assert.assertNotNull((Object)cacheProvider);
        Assert.assertEquals(CaffeineCacheProvider.class, cacheProvider.getClass());
    }

    @Test
    public void testBaseOps() {
        Cache.NamedKey aKey = new Cache.NamedKey("a", HI);
        Assert.assertNull((Object)this.cache.get(aKey));
        this.put((Cache)this.cache, aKey, 1);
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, aKey));
        this.cache.close("a");
        Assert.assertNull((Object)this.cache.get(aKey));
        Cache.NamedKey hiKey = new Cache.NamedKey("the", HI);
        Cache.NamedKey hoKey = new Cache.NamedKey("the", HO);
        this.put((Cache)this.cache, hiKey, 10);
        this.put((Cache)this.cache, hoKey, 20);
        Assert.assertEquals((long)10L, (long)this.get((Cache)this.cache, hiKey));
        Assert.assertEquals((long)20L, (long)this.get((Cache)this.cache, hoKey));
        this.cache.close("the");
        Assert.assertNull((Object)this.cache.get(hiKey));
        Assert.assertNull((Object)this.cache.get(hoKey));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("miss", HI)));
        CacheStats stats = this.cache.getStats();
        Assert.assertEquals((long)3L, (long)stats.getNumHits());
        Assert.assertEquals((long)5L, (long)stats.getNumMisses());
    }

    @Test
    public void testGetBulk() {
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("the", HI)));
        Cache.NamedKey key1 = new Cache.NamedKey("the", HI);
        this.put((Cache)this.cache, key1, 2);
        Cache.NamedKey key2 = new Cache.NamedKey("the", HO);
        this.put((Cache)this.cache, key2, 10);
        Map result = this.cache.getBulk((Iterable)Lists.newArrayList((Object[])new Cache.NamedKey[]{key1, key2}));
        Assert.assertEquals((long)2L, (long)Ints.fromByteArray((byte[])((byte[])result.get(key1))));
        Assert.assertEquals((long)10L, (long)Ints.fromByteArray((byte[])((byte[])result.get(key2))));
        Cache.NamedKey missingKey = new Cache.NamedKey("missing", HI);
        result = this.cache.getBulk(Collections.singletonList(missingKey));
        Assert.assertEquals((long)result.size(), (long)0L);
        result = this.cache.getBulk(new ArrayList());
        Assert.assertEquals((long)result.size(), (long)0L);
    }

    @Test
    public void testSizeEviction() throws Exception {
        CaffeineCacheConfig config = new CaffeineCacheConfig(){

            public long getSizeInBytes() {
                return 40L;
            }
        };
        Random random = new Random(843671346794319L);
        byte[] val1 = new byte[14];
        byte[] val2 = new byte[14];
        byte[] s1 = new byte[]{1};
        byte[] s2 = new byte[]{2};
        random.nextBytes(val1);
        random.nextBytes(val2);
        Cache.NamedKey key1 = new Cache.NamedKey("the", s1);
        Cache.NamedKey key2 = new Cache.NamedKey("the", s2);
        CaffeineCache cache = CaffeineCache.create((CaffeineCacheConfig)config, Runnable::run);
        Assert.assertNull((Object)cache.get(key1));
        Assert.assertNull((Object)cache.get(key2));
        cache.put(key1, val1);
        Assert.assertArrayEquals((byte[])val1, (byte[])cache.get(key1));
        Assert.assertNull((Object)cache.get(key2));
        Assert.assertEquals((long)0L, (long)cache.getCache().stats().evictionWeight());
        Assert.assertArrayEquals((byte[])val1, (byte[])cache.get(key1));
        Assert.assertNull((Object)cache.get(key2));
        cache.put(key2, val2);
        Assert.assertNull((Object)cache.get(key1));
        Assert.assertArrayEquals((byte[])val2, (byte[])cache.get(key2));
        Assert.assertEquals((long)34L, (long)cache.getCache().stats().evictionWeight());
    }

    @Test
    public void testSizeCalculation() {
        CaffeineCacheConfig config = new CaffeineCacheConfig(){

            public long getSizeInBytes() {
                return 40L;
            }
        };
        Random random = new Random(843671346794319L);
        byte[] val1 = new byte[14];
        byte[] val2 = new byte[14];
        byte[] s1 = new byte[]{1};
        byte[] s2 = new byte[]{2};
        random.nextBytes(val1);
        random.nextBytes(val2);
        Cache.NamedKey key1 = new Cache.NamedKey("the", s1);
        Cache.NamedKey key2 = new Cache.NamedKey("the", s2);
        CaffeineCache cache = CaffeineCache.create((CaffeineCacheConfig)config, Runnable::run);
        CacheStats stats = cache.getStats();
        Assert.assertEquals((long)0L, (long)stats.getNumEntries());
        Assert.assertEquals((long)0L, (long)stats.getSizeInBytes());
        cache.put(key1, val1);
        stats = cache.getStats();
        Assert.assertEquals((long)1L, (long)stats.getNumEntries());
        Assert.assertEquals((long)34L, (long)stats.getSizeInBytes());
        cache.put(key2, val2);
        stats = cache.getStats();
        Assert.assertEquals((long)1L, (long)stats.getNumEntries());
        Assert.assertEquals((long)34L, (long)stats.getSizeInBytes());
    }

    @Test
    public void testSizeCalculationAfterDelete() {
        String namespace = "the";
        CaffeineCacheConfig config = new CaffeineCacheConfig(){

            public long getSizeInBytes() {
                return 999999L;
            }

            public boolean isEvictOnClose() {
                return true;
            }
        };
        Random random = new Random(843671346794319L);
        byte[] val1 = new byte[14];
        byte[] val2 = new byte[14];
        byte[] s1 = new byte[]{1};
        byte[] s2 = new byte[]{2};
        random.nextBytes(val1);
        random.nextBytes(val2);
        Cache.NamedKey key1 = new Cache.NamedKey("the", s1);
        Cache.NamedKey key2 = new Cache.NamedKey("the", s2);
        CaffeineCache cache = CaffeineCache.create((CaffeineCacheConfig)config, Runnable::run);
        CacheStats stats = cache.getStats();
        Assert.assertEquals((long)0L, (long)stats.getNumEntries());
        Assert.assertEquals((long)0L, (long)stats.getSizeInBytes());
        cache.put(key1, val1);
        stats = cache.getStats();
        Assert.assertEquals((long)1L, (long)stats.getNumEntries());
        Assert.assertEquals((long)34L, (long)stats.getSizeInBytes());
        cache.put(key2, val2);
        stats = cache.getStats();
        Assert.assertEquals((long)2L, (long)stats.getNumEntries());
        Assert.assertEquals((long)68L, (long)stats.getSizeInBytes());
        cache.close("the");
        stats = cache.getStats();
        Assert.assertEquals((long)0L, (long)stats.getNumEntries());
        Assert.assertEquals((long)0L, (long)stats.getSizeInBytes());
    }

    @Test
    public void testSizeCalculationMore() {
        CaffeineCacheConfig config = new CaffeineCacheConfig(){

            public long getSizeInBytes() {
                return 400L;
            }
        };
        Random random = new Random(843671346794319L);
        byte[] val1 = new byte[14];
        byte[] val2 = new byte[14];
        byte[] s1 = new byte[]{1};
        byte[] s2 = new byte[]{2};
        random.nextBytes(val1);
        random.nextBytes(val2);
        Cache.NamedKey key1 = new Cache.NamedKey("the", s1);
        Cache.NamedKey key2 = new Cache.NamedKey("the", s2);
        CaffeineCache cache = CaffeineCache.create((CaffeineCacheConfig)config, Runnable::run);
        CacheStats stats = cache.getStats();
        Assert.assertEquals((long)0L, (long)stats.getNumEntries());
        Assert.assertEquals((long)0L, (long)stats.getSizeInBytes());
        cache.put(key1, val1);
        stats = cache.getStats();
        Assert.assertEquals((long)1L, (long)stats.getNumEntries());
        Assert.assertEquals((long)34L, (long)stats.getSizeInBytes());
        cache.put(key2, val2);
        stats = cache.getStats();
        Assert.assertEquals((long)2L, (long)stats.getNumEntries());
        Assert.assertEquals((long)68L, (long)stats.getSizeInBytes());
    }

    @Test
    public void testSizeCalculationNoWeight() {
        CaffeineCacheConfig config = new CaffeineCacheConfig(){

            public long getSizeInBytes() {
                return -1L;
            }
        };
        Random random = new Random(843671346794319L);
        byte[] val1 = new byte[14];
        byte[] val2 = new byte[14];
        byte[] s1 = new byte[]{1};
        byte[] s2 = new byte[]{2};
        random.nextBytes(val1);
        random.nextBytes(val2);
        Cache.NamedKey key1 = new Cache.NamedKey("the", s1);
        Cache.NamedKey key2 = new Cache.NamedKey("the", s2);
        CaffeineCache cache = CaffeineCache.create((CaffeineCacheConfig)config, Runnable::run);
        CacheStats stats = cache.getStats();
        Assert.assertEquals((long)0L, (long)stats.getNumEntries());
        Assert.assertEquals((long)0L, (long)stats.getSizeInBytes());
        cache.put(key1, val1);
        stats = cache.getStats();
        Assert.assertEquals((long)1L, (long)stats.getNumEntries());
        Assert.assertEquals((long)34L, (long)stats.getSizeInBytes());
        cache.put(key2, val2);
        stats = cache.getStats();
        Assert.assertEquals((long)2L, (long)stats.getNumEntries());
        Assert.assertEquals((long)68L, (long)stats.getSizeInBytes());
    }

    @Test
    public void testFromProperties() {
        String keyPrefix = "cache.config.prefix";
        Properties properties = new Properties();
        properties.put("cache.config.prefix.expireAfter", "10");
        properties.put("cache.config.prefix.sizeInBytes", "100");
        properties.put("cache.config.prefix.cacheExecutorFactory", "single_thread");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            JsonConfigProvider.bind((Binder)binder, (String)"cache.config.prefix", CaffeineCacheConfig.class);
        }));
        JsonConfigurator configurator = (JsonConfigurator)injector.getInstance(JsonConfigurator.class);
        JsonConfigProvider caffeineCacheConfigJsonConfigProvider = JsonConfigProvider.of((String)"cache.config.prefix", CaffeineCacheConfig.class);
        caffeineCacheConfigJsonConfigProvider.inject(properties, configurator);
        CaffeineCacheConfig config = (CaffeineCacheConfig)caffeineCacheConfigJsonConfigProvider.get().get();
        Assert.assertEquals((long)10L, (long)config.getExpireAfter());
        Assert.assertEquals((long)100L, (long)config.getSizeInBytes());
        Assert.assertNotNull((Object)config.createExecutor());
    }

    @Test
    public void testMixedCaseFromProperties() {
        String keyPrefix = "cache.config.prefix";
        Properties properties = new Properties();
        properties.put("cache.config.prefix.expireAfter", "10");
        properties.put("cache.config.prefix.sizeInBytes", "100");
        properties.put("cache.config.prefix.cacheExecutorFactory", "CoMmON_FjP");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            JsonConfigProvider.bind((Binder)binder, (String)"cache.config.prefix", CaffeineCacheConfig.class);
        }));
        JsonConfigurator configurator = (JsonConfigurator)injector.getInstance(JsonConfigurator.class);
        JsonConfigProvider caffeineCacheConfigJsonConfigProvider = JsonConfigProvider.of((String)"cache.config.prefix", CaffeineCacheConfig.class);
        caffeineCacheConfigJsonConfigProvider.inject(properties, configurator);
        CaffeineCacheConfig config = (CaffeineCacheConfig)caffeineCacheConfigJsonConfigProvider.get().get();
        Assert.assertEquals((long)10L, (long)config.getExpireAfter());
        Assert.assertEquals((long)100L, (long)config.getSizeInBytes());
        Assert.assertEquals((Object)ForkJoinPool.commonPool(), (Object)config.createExecutor());
    }

    @Test
    public void testDefaultFromProperties() {
        String keyPrefix = "cache.config.prefix";
        Properties properties = new Properties();
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test");
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
            binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
            JsonConfigProvider.bind((Binder)binder, (String)"cache.config.prefix", CaffeineCacheConfig.class);
        }));
        JsonConfigurator configurator = (JsonConfigurator)injector.getInstance(JsonConfigurator.class);
        JsonConfigProvider caffeineCacheConfigJsonConfigProvider = JsonConfigProvider.of((String)"cache.config.prefix", CaffeineCacheConfig.class);
        caffeineCacheConfigJsonConfigProvider.inject(properties, configurator);
        CaffeineCacheConfig config = (CaffeineCacheConfig)caffeineCacheConfigJsonConfigProvider.get().get();
        Assert.assertEquals((long)-1L, (long)config.getExpireAfter());
        Assert.assertEquals((long)-1L, (long)config.getSizeInBytes());
        Assert.assertEquals((Object)ForkJoinPool.commonPool(), (Object)config.createExecutor());
    }

    public int get(Cache cache, Cache.NamedKey key) {
        return Ints.fromByteArray((byte[])cache.get(key));
    }

    public void put(Cache cache, Cache.NamedKey key, Integer value) {
        cache.put(key, Ints.toByteArray((int)value));
    }
}

