/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.client.cache.MemcachedCache;
import org.easymock.EasyMock;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CacheDistributionTest {
    public static final int KEY_COUNT = 1000000;
    final HashAlgorithm hash;
    final int reps;

    @Parameterized.Parameters(name="repetitions={0}, hash={1}")
    public static Iterable<Object[]> data() {
        ImmutableList hash = ImmutableList.of((Object)DefaultHashAlgorithm.FNV1A_64_HASH, (Object)DefaultHashAlgorithm.KETAMA_HASH, (Object)MemcachedCache.MURMUR3_128);
        List<Integer> repetitions = Arrays.asList(160, 500, 1000, 2500, 5000);
        Set values = Sets.cartesianProduct((Set[])new Set[]{Sets.newLinkedHashSet((Iterable)hash), Sets.newLinkedHashSet(repetitions)});
        return Iterables.transform((Iterable)values, List::toArray);
    }

    @BeforeClass
    public static void header() {
        System.out.printf(Locale.ENGLISH, "%25s\t%5s\t%10s\t%10s\t%10s\t%10s\t%10s\t%7s\t%5s%n", "hash", "reps", "node 1", "node 2", "node 3", "node 4", "node 5", "min/max", "ns");
    }

    public CacheDistributionTest(HashAlgorithm hash, int reps) {
        this.hash = hash;
        this.reps = reps;
    }

    @Ignore
    @Test
    public void testDistribution() {
        KetamaNodeLocator locator = new KetamaNodeLocator((List)ImmutableList.of((Object)CacheDistributionTest.dummyNode("druid-cache.0001", 11211), (Object)CacheDistributionTest.dummyNode("druid-cache.0002", 11211), (Object)CacheDistributionTest.dummyNode("druid-cache.0003", 11211), (Object)CacheDistributionTest.dummyNode("druid-cache.0004", 11211), (Object)CacheDistributionTest.dummyNode("druid-cache.0005", 11211)), this.hash, (KetamaNodeLocatorConfiguration)new DefaultKetamaNodeLocatorConfiguration(){

            public int getNodeRepetitions() {
                return CacheDistributionTest.this.reps;
            }
        });
        HashMap<MemcachedNode, AtomicLong> counter = new HashMap<MemcachedNode, AtomicLong>();
        long t = 0L;
        for (int i = 0; i < 1000000; ++i) {
            String k = DigestUtils.sha1Hex((String)("abc" + i)) + ":" + DigestUtils.sha1Hex((String)("xyz" + i));
            long t0 = System.nanoTime();
            MemcachedNode node = locator.getPrimary(k);
            t += System.nanoTime() - t0;
            if (counter.containsKey(node)) {
                ((AtomicLong)counter.get(node)).incrementAndGet();
                continue;
            }
            counter.put(node, new AtomicLong(1L));
        }
        long min = Long.MAX_VALUE;
        long max = 0L;
        System.out.printf(Locale.ENGLISH, "%25s\t%5d\t", this.hash, this.reps);
        for (AtomicLong count : counter.values()) {
            System.out.printf(Locale.ENGLISH, "%10d\t", count.get());
            min = Math.min(min, count.get());
            max = Math.max(max, count.get());
        }
        System.out.printf(Locale.ENGLISH, "%7.2f\t%5.0f%n", (double)min / (double)max, (double)t / 1000000.0);
    }

    private static MemcachedNode dummyNode(String host, int port) {
        InetSocketAddress address = InetSocketAddress.createUnresolved(host, port);
        MemcachedNode node = (MemcachedNode)EasyMock.createNiceMock(MemcachedNode.class);
        EasyMock.expect((Object)node.getSocketAddress()).andReturn((Object)address).anyTimes();
        EasyMock.replay((Object[])new Object[]{node});
        return node;
    }
}

