/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client.cache;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import java.util.List;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.client.cache.CacheConfig;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class CacheConfigTest {
    static Injector injector;
    static JsonConfigurator configurator;
    JsonConfigProvider<CacheConfig> configProvider;
    private static final String PROPERTY_PREFIX = "org.apache.hive.druid.org.apache.druid.collections.test.cache";
    private Properties properties = new Properties();

    @BeforeClass
    public static void populateStatics() {
        injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of((Object)new CacheConfigTestModule()));
        configurator = (JsonConfigurator)injector.getBinding(JsonConfigurator.class).getProvider().get();
    }

    @Before
    public void setupTest() {
        this.properties.clear();
        this.configProvider = JsonConfigProvider.of((String)PROPERTY_PREFIX, CacheConfig.class);
    }

    @Test
    public void testInjection1() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.numBackgroundThreads", "5");
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.populateCache", "true");
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.useCache", "true");
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.unCacheable", "[\"a\",\"b\"]");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        injector.injectMembers((Object)config);
        Assert.assertEquals((long)5L, (long)config.getNumBackgroundThreads());
        Assert.assertEquals((Object)true, (Object)config.isPopulateCache());
        Assert.assertEquals((Object)true, (Object)config.isUseCache());
    }

    @Test
    public void testInjection2() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.numBackgroundThreads", "99");
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.populateCache", "false");
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.useCache", "false");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        Assert.assertEquals((long)99L, (long)config.getNumBackgroundThreads());
        Assert.assertEquals((Object)false, (Object)config.isPopulateCache());
        Assert.assertEquals((Object)false, (Object)config.isUseCache());
    }

    @Test(expected=ProvisionException.class)
    public void testValidationError() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.numBackgroundThreads", "-1");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        Assert.assertNotEquals((long)-1L, (long)config.getNumBackgroundThreads());
    }

    @Test(expected=ProvisionException.class)
    public void testValidationInsaneError() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.numBackgroundThreads", "BABBA YAGA");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        throw new IllegalStateException("Should have already failed");
    }

    @Test(expected=ProvisionException.class)
    public void testTRUE() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.populateCache", "TRUE");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        throw new IllegalStateException("Should have already failed");
    }

    @Test(expected=ProvisionException.class)
    public void testFALSE() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.populateCache", "FALSE");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        throw new IllegalStateException("Should have already failed");
    }

    @Test(expected=ProvisionException.class)
    public void testFaLse() {
        this.properties.put("org.apache.hive.druid.org.apache.druid.collections.test.cache.populateCache", "FaLse");
        this.configProvider.inject(this.properties, configurator);
        CacheConfig config = (CacheConfig)this.configProvider.get().get();
        throw new IllegalStateException("Should have already failed");
    }

    private static class CacheConfigTestModule
    implements DruidModule {
        private CacheConfigTestModule() {
        }

        public List<? extends Module> getJacksonModules() {
            return ImmutableList.of((Object)new SimpleModule());
        }

        public void configure(Binder binder) {
            JsonConfigProvider.bind((Binder)binder, (String)CacheConfigTest.PROPERTY_PREFIX, CacheConfig.class);
        }
    }
}

