/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSortedMap;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.test.utils.ImmutableDruidDataSourceTestUtils;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImmutableDruidDataSourceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        DataSegment segment = this.getTestSegment();
        ImmutableDruidDataSource dataSource = this.getImmutableDruidDataSource(segment);
        ObjectMapper objectMapper = new DefaultObjectMapper().setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT));
        String json = objectMapper.writeValueAsString((Object)dataSource);
        ImmutableDruidDataSourceTestUtils.assertEquals(dataSource, (ImmutableDruidDataSource)objectMapper.readValue(json, ImmutableDruidDataSource.class));
    }

    @Test
    public void testEqualsMethodThrowsUnsupportedOperationException() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("ImmutableDruidDataSource shouldn't be used as the key in containers");
        DataSegment segment1 = this.getTestSegment();
        ImmutableDruidDataSource dataSource1 = this.getImmutableDruidDataSource(segment1);
        DataSegment segment2 = this.getTestSegment();
        ImmutableDruidDataSource dataSource2 = this.getImmutableDruidDataSource(segment2);
        dataSource1.equals((Object)dataSource2);
    }

    private ImmutableDruidDataSource getImmutableDruidDataSource(DataSegment segment1) {
        return new ImmutableDruidDataSource("test", (Map)ImmutableMap.of((Object)"prop1", (Object)"val1", (Object)"prop2", (Object)"val2"), (Map)ImmutableSortedMap.of((Comparable)segment1.getId(), (Object)segment1));
    }

    private DataSegment getTestSegment() {
        return new DataSegment("test", Intervals.of((String)"2017/2018"), "version", null, (List)ImmutableList.of((Object)"dim1", (Object)"dim2"), (List)ImmutableList.of((Object)"met1", (Object)"met2"), null, null, Integer.valueOf(1), 100L, DataSegment.PruneSpecsHolder.DEFAULT);
    }

    @Test
    public void testHashCodeMethodThrowsUnsupportedOperationException() {
        this.expectedException.expect(UnsupportedOperationException.class);
        this.expectedException.expectMessage("ImmutableDruidDataSource shouldn't be used as the key in containers");
        DataSegment segment = this.getTestSegment();
        ImmutableDruidDataSource dataSource = this.getImmutableDruidDataSource(segment);
        dataSource.hashCode();
    }
}

