/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.HttpServerInventoryView;
import org.apache.hive.druid.org.apache.druid.client.HttpServerInventoryViewConfig;
import org.apache.hive.druid.org.apache.druid.client.ServerView;
import org.apache.hive.druid.org.apache.druid.discovery.DataNodeService;
import org.apache.hive.druid.org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.hive.druid.org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.hive.druid.org.apache.druid.discovery.NodeRole;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.RE;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestHistory;
import org.apache.hive.druid.org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.apache.hive.druid.org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.hive.druid.org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpVersion;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class HttpServerInventoryViewTest {
    @Test(timeout=60000L)
    public void testSimple() throws Exception {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        TestDruidNodeDiscovery druidNodeDiscovery = new TestDruidNodeDiscovery();
        DruidNodeDiscoveryProvider druidNodeDiscoveryProvider = (DruidNodeDiscoveryProvider)EasyMock.createMock(DruidNodeDiscoveryProvider.class);
        EasyMock.expect((Object)druidNodeDiscoveryProvider.getForService("dataNodeService")).andReturn((Object)druidNodeDiscovery);
        EasyMock.replay((Object[])new Object[]{druidNodeDiscoveryProvider});
        DataSegment segment1 = new DataSegment("test1", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment2 = new DataSegment("test2", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment3 = new DataSegment("test3", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment4 = new DataSegment("test4", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        DataSegment segment5 = new DataSegment("non-loading-datasource", Intervals.of((String)"2014/2015"), "v1", null, null, null, null, Integer.valueOf(0), 0L);
        TestHttpClient httpClient = new TestHttpClient((List<ListenableFuture>)ImmutableList.of((Object)Futures.immediateFuture((Object)new ByteArrayInputStream(jsonMapper.writerWithType(HttpServerInventoryView.SEGMENT_LIST_RESP_TYPE_REF).writeValueAsBytes((Object)new ChangeRequestsSnapshot(false, null, ChangeRequestHistory.Counter.ZERO, (List)ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1)))))), (Object)Futures.immediateFuture((Object)new ByteArrayInputStream(jsonMapper.writerWithType(HttpServerInventoryView.SEGMENT_LIST_RESP_TYPE_REF).writeValueAsBytes((Object)new ChangeRequestsSnapshot(false, null, ChangeRequestHistory.Counter.ZERO, (List)ImmutableList.of((Object)new SegmentChangeRequestDrop(segment1), (Object)new SegmentChangeRequestLoad(segment2), (Object)new SegmentChangeRequestLoad(segment3)))))), (Object)Futures.immediateFuture((Object)new ByteArrayInputStream(jsonMapper.writerWithType(HttpServerInventoryView.SEGMENT_LIST_RESP_TYPE_REF).writeValueAsBytes((Object)new ChangeRequestsSnapshot(true, "force reset counter", ChangeRequestHistory.Counter.ZERO, (List)ImmutableList.of())))), (Object)Futures.immediateFuture((Object)new ByteArrayInputStream(jsonMapper.writerWithType(HttpServerInventoryView.SEGMENT_LIST_RESP_TYPE_REF).writeValueAsBytes((Object)new ChangeRequestsSnapshot(false, null, ChangeRequestHistory.Counter.ZERO, (List)ImmutableList.of((Object)new SegmentChangeRequestLoad(segment3), (Object)new SegmentChangeRequestLoad(segment4), (Object)new SegmentChangeRequestLoad(segment5))))))));
        DiscoveryDruidNode druidNode = new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(8080), null, true, false), NodeRole.HISTORICAL, (Map)ImmutableMap.of((Object)"dataNodeService", (Object)new DataNodeService("tier", 1000L, ServerType.HISTORICAL, 0)));
        HttpServerInventoryView httpServerInventoryView = new HttpServerInventoryView(jsonMapper, (HttpClient)httpClient, druidNodeDiscoveryProvider, pair -> !((DataSegment)pair.rhs).getDataSource().equals("non-loading-datasource"), new HttpServerInventoryViewConfig(null, null, null));
        CountDownLatch initializeCallback1 = new CountDownLatch(1);
        ImmutableMap segmentAddLathces = ImmutableMap.of((Object)segment1.getId(), (Object)new CountDownLatch(1), (Object)segment2.getId(), (Object)new CountDownLatch(1), (Object)segment3.getId(), (Object)new CountDownLatch(1), (Object)segment4.getId(), (Object)new CountDownLatch(1));
        ImmutableMap segmentDropLatches = ImmutableMap.of((Object)segment1.getId(), (Object)new CountDownLatch(1), (Object)segment2.getId(), (Object)new CountDownLatch(1));
        httpServerInventoryView.registerSegmentCallback((Executor)Execs.directExecutor(), new ServerView.SegmentCallback((Map)segmentAddLathces, (Map)segmentDropLatches, initializeCallback1){
            final /* synthetic */ Map val$segmentAddLathces;
            final /* synthetic */ Map val$segmentDropLatches;
            final /* synthetic */ CountDownLatch val$initializeCallback1;
            {
                this.val$segmentAddLathces = map;
                this.val$segmentDropLatches = map2;
                this.val$initializeCallback1 = countDownLatch;
            }

            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                ((CountDownLatch)this.val$segmentAddLathces.get(segment.getId())).countDown();
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
                ((CountDownLatch)this.val$segmentDropLatches.get(segment.getId())).countDown();
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentViewInitialized() {
                this.val$initializeCallback1.countDown();
                return ServerView.CallbackAction.CONTINUE;
            }
        });
        final CountDownLatch serverRemovedCalled = new CountDownLatch(1);
        httpServerInventoryView.registerServerRemovedCallback((Executor)Execs.directExecutor(), new ServerView.ServerRemovedCallback(){

            public ServerView.CallbackAction serverRemoved(DruidServer server) {
                if (server.getName().equals("host:8080")) {
                    serverRemovedCalled.countDown();
                    return ServerView.CallbackAction.CONTINUE;
                }
                throw new RE("Unknown server [%s]", new Object[]{server.getName()});
            }
        });
        httpServerInventoryView.start();
        druidNodeDiscovery.listener.nodesAdded((Collection)ImmutableList.of((Object)druidNode));
        initializeCallback1.await();
        ((CountDownLatch)segmentAddLathces.get(segment1.getId())).await();
        ((CountDownLatch)segmentDropLatches.get(segment1.getId())).await();
        ((CountDownLatch)segmentAddLathces.get(segment2.getId())).await();
        ((CountDownLatch)segmentAddLathces.get(segment3.getId())).await();
        ((CountDownLatch)segmentAddLathces.get(segment4.getId())).await();
        ((CountDownLatch)segmentDropLatches.get(segment2.getId())).await();
        DruidServer druidServer = httpServerInventoryView.getInventoryValue("host:8080");
        Assert.assertEquals((Object)ImmutableMap.of((Object)segment3.getId(), (Object)segment3, (Object)segment4.getId(), (Object)segment4), (Object)Maps.uniqueIndex((Iterable)druidServer.iterateAllSegments(), DataSegment::getId));
        druidNodeDiscovery.listener.nodesRemoved((Collection)ImmutableList.of((Object)druidNode));
        serverRemovedCalled.await();
        Assert.assertNull((Object)httpServerInventoryView.getInventoryValue("host:8080"));
        EasyMock.verify((Object[])new Object[]{druidNodeDiscoveryProvider});
        httpServerInventoryView.stop();
    }

    private static class TestHttpClient
    implements HttpClient {
        BlockingQueue<ListenableFuture> results;
        AtomicInteger requestNum = new AtomicInteger(0);

        TestHttpClient(List<ListenableFuture> resultsList) {
            this.results = new LinkedBlockingQueue<ListenableFuture>();
            this.results.addAll(resultsList);
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler) {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public <Intermediate, Final> ListenableFuture<Final> go(Request request, HttpResponseHandler<Intermediate, Final> httpResponseHandler, Duration duration) {
            if (this.requestNum.getAndIncrement() == 0) {
                throw new RuntimeException("simulating couldn't send request to server for some reason.");
            }
            if (this.requestNum.get() == 2) {
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                httpResponse.setContent(ChannelBuffers.buffer((int)0));
                httpResponseHandler.handleResponse((HttpResponse)httpResponse, null);
                return Futures.immediateFailedFuture((Throwable)new RuntimeException("server error"));
            }
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            httpResponse.setContent(ChannelBuffers.buffer((int)0));
            httpResponseHandler.handleResponse((HttpResponse)httpResponse, null);
            try {
                return this.results.take();
            }
            catch (InterruptedException ex) {
                throw new RE((Throwable)ex, "Interrupted.", new Object[0]);
            }
        }
    }

    private static class TestDruidNodeDiscovery
    implements DruidNodeDiscovery {
        DruidNodeDiscovery.Listener listener;

        private TestDruidNodeDiscovery() {
        }

        public Collection<DiscoveryDruidNode> getAllNodes() {
            throw new UnsupportedOperationException("Not Implemented.");
        }

        public void registerListener(DruidNodeDiscovery.Listener listener) {
            listener.nodesAdded((Collection)ImmutableList.of());
            listener.nodeViewInitialized();
            this.listener = listener;
        }
    }
}

