/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.org.apache.druid.client.HttpServerInventoryViewConfig;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class HttpServerInventoryViewConfigTest {
    @Test
    public void testDeserializationWithDefaults() throws Exception {
        String json = "{}";
        HttpServerInventoryViewConfig config = (HttpServerInventoryViewConfig)TestHelper.makeJsonMapper().readValue(json, HttpServerInventoryViewConfig.class);
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(4L), (long)config.getServerTimeout());
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)config.getServerUnstabilityTimeout());
        Assert.assertEquals((long)5L, (long)config.getNumThreads());
    }

    @Test
    public void testDeserializationWithNonDefaults() throws Exception {
        String json = "{\n  \"serverTimeout\": \"PT2M\",\n  \"serverUnstabilityTimeout\": \"PT3M\",\n  \"numThreads\": 7\n}";
        HttpServerInventoryViewConfig config = (HttpServerInventoryViewConfig)TestHelper.makeJsonMapper().readValue(json, HttpServerInventoryViewConfig.class);
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(2L), (long)config.getServerTimeout());
        Assert.assertEquals((long)TimeUnit.MINUTES.toMillis(3L), (long)config.getServerUnstabilityTimeout());
        Assert.assertEquals((long)7L, (long)config.getNumThreads());
    }
}

