/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.org.apache.druid.client.DirectDruidClient;
import org.apache.hive.druid.org.apache.druid.client.DruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ConnectionCountServerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.HighestPriorityTierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelector;
import org.apache.hive.druid.org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryInterruptedException;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.ReflectionQueryToolChestWarehouse;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.org.apache.druid.server.coordination.ServerType;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DirectDruidClientTest {
    private final String hostName = "localhost:8080";
    private final DataSegment dataSegment = new DataSegment("test", Intervals.of((String)"2013-01-01/2013-01-02"), DateTimes.of((String)"2013-01-01").toString(), new HashMap(), new ArrayList(), new ArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 0L);
    private ServerSelector serverSelector;
    private HttpClient httpClient;
    private DirectDruidClient client;
    private QueryableDruidServer queryableDruidServer;

    @Before
    public void setup() {
        this.httpClient = (HttpClient)EasyMock.createMock(HttpClient.class);
        this.serverSelector = new ServerSelector(this.dataSegment, (TierSelectorStrategy)new HighestPriorityTierSelectorStrategy((ServerSelectorStrategy)new ConnectionCountServerSelectorStrategy()));
        this.client = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), this.httpClient, "http", "localhost:8080", (ServiceEmitter)new NoopServiceEmitter());
        this.queryableDruidServer = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)this.client);
        this.serverSelector.addServerAndUpdateSegment(this.queryableDruidServer, this.serverSelector.getSegment());
    }

    @Test
    public void testRun() throws Exception {
        URL url = new URL(StringUtils.format((String)"http://%s/druid/v2/", (Object[])new Object[]{"localhost:8080"}));
        SettableFuture futureResult = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)futureResult).times(1);
        SettableFuture futureException = SettableFuture.create();
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)futureException).times(1);
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)SettableFuture.create()).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.httpClient});
        DirectDruidClient client2 = new DirectDruidClient((QueryToolChestWarehouse)new ReflectionQueryToolChestWarehouse(), QueryRunnerTestHelper.NOOP_QUERYWATCHER, (ObjectMapper)new DefaultObjectMapper(), this.httpClient, "http", "foo2", (ServiceEmitter)new NoopServiceEmitter());
        QueryableDruidServer queryableDruidServer2 = new QueryableDruidServer(new DruidServer("test1", "localhost", null, 0L, ServerType.HISTORICAL, "_default_tier", 0), (QueryRunner)client2);
        this.serverSelector.addServerAndUpdateSegment(queryableDruidServer2, this.serverSelector.getSegment());
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)Long.MAX_VALUE));
        Sequence s1 = this.client.run(QueryPlus.wrap((Query)query));
        Assert.assertTrue((boolean)capturedRequest.hasCaptured());
        Assert.assertEquals((Object)url, (Object)((Request)capturedRequest.getValue()).getUrl());
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((long)1L, (long)this.client.getNumOpenConnections());
        this.client.run(QueryPlus.wrap((Query)query));
        Assert.assertEquals((long)2L, (long)this.client.getNumOpenConnections());
        futureException.setException((Throwable)new ReadTimeoutException());
        Assert.assertEquals((long)1L, (long)this.client.getNumOpenConnections());
        this.client.run(QueryPlus.wrap((Query)query));
        this.client.run(QueryPlus.wrap((Query)query));
        this.client.run(QueryPlus.wrap((Query)query));
        Assert.assertTrue((this.client.getNumOpenConnections() == 4 ? 1 : 0) != 0);
        futureResult.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"[{\"timestamp\":\"2014-01-01T01:02:03Z\", \"result\": 42.0}]")));
        List results = s1.toList();
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)DateTimes.of((String)"2014-01-01T01:02:03Z"), (Object)((Result)results.get(0)).getTimestamp());
        Assert.assertEquals((long)3L, (long)this.client.getNumOpenConnections());
        client2.run(QueryPlus.wrap((Query)query));
        client2.run(QueryPlus.wrap((Query)query));
        Assert.assertEquals((long)2L, (long)client2.getNumOpenConnections());
        Assert.assertEquals((Object)this.serverSelector.pick(), (Object)queryableDruidServer2);
        EasyMock.verify((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void testCancel() {
        Capture capturedRequest = EasyMock.newCapture();
        ListenableFuture cancelledFuture = Futures.immediateCancelledFuture();
        SettableFuture cancellationFuture = SettableFuture.create();
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)cancelledFuture).once();
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)cancellationFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.httpClient});
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)Long.MAX_VALUE));
        cancellationFuture.set((Object)new StatusResponseHolder(HttpResponseStatus.OK, new StringBuilder("cancelled")));
        Sequence results = this.client.run(QueryPlus.wrap((Query)query));
        Assert.assertEquals((Object)HttpMethod.POST, (Object)((Request)capturedRequest.getValue()).getMethod());
        Assert.assertEquals((long)0L, (long)this.client.getNumOpenConnections());
        QueryInterruptedException exception = null;
        try {
            results.toList();
        }
        catch (QueryInterruptedException e) {
            exception = e;
        }
        Assert.assertNotNull((Object)((Object)exception));
        EasyMock.verify((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void testQueryInterruptionExceptionLogMessage() {
        SettableFuture interruptionFuture = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        String hostName = "localhost:8080";
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)interruptionFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.httpClient});
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)Long.MAX_VALUE));
        interruptionFuture.set((Object)new ByteArrayInputStream(StringUtils.toUtf8((String)"{\"error\":\"testing1\",\"errorMessage\":\"testing2\"}")));
        Sequence results = this.client.run(QueryPlus.wrap((Query)query));
        QueryInterruptedException actualException = null;
        try {
            results.toList();
        }
        catch (QueryInterruptedException e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)((Object)actualException));
        Assert.assertEquals((Object)"testing1", (Object)actualException.getErrorCode());
        Assert.assertEquals((Object)"testing2", (Object)actualException.getMessage());
        Assert.assertEquals((Object)"localhost:8080", (Object)actualException.getHost());
        EasyMock.verify((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void testQueryTimeoutBeforeFuture() throws IOException, InterruptedException {
        SettableFuture timeoutFuture = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        String queryId = "timeout-before-future";
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)timeoutFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.httpClient});
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)(System.currentTimeMillis() + 250L), (Object)"queryId", (Object)"timeout-before-future"));
        Sequence results = this.client.run(QueryPlus.wrap((Query)query));
        PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        timeoutFuture.set((Object)in);
        QueryInterruptedException actualException = null;
        try {
            out.write(StringUtils.toUtf8((String)"[{\"timestamp\":\"2014-01-01T01:02:03Z\"}"));
            Thread.sleep(250L);
            out.write(StringUtils.toUtf8((String)"]"));
            out.close();
            results.toList();
        }
        catch (QueryInterruptedException e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)((Object)actualException));
        Assert.assertEquals((Object)"Query timeout", (Object)actualException.getErrorCode());
        Assert.assertEquals((Object)"url[http://localhost:8080/druid/v2/] timed out", (Object)actualException.getMessage());
        Assert.assertEquals((Object)"localhost:8080", (Object)actualException.getHost());
        EasyMock.verify((Object[])new Object[]{this.httpClient});
    }

    @Test
    public void testQueryTimeoutFromFuture() {
        SettableFuture noFuture = SettableFuture.create();
        Capture capturedRequest = EasyMock.newCapture();
        String queryId = "never-ending-future";
        EasyMock.expect((Object)this.httpClient.go((Request)EasyMock.capture((Capture)capturedRequest), (HttpResponseHandler)EasyMock.anyObject(), (Duration)EasyMock.anyObject(Duration.class))).andReturn((Object)noFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.httpClient});
        TimeBoundaryQuery query = Druids.newTimeBoundaryQueryBuilder().dataSource("test").build();
        query = query.withOverriddenContext((Map)ImmutableMap.of((Object)"queryFailTime", (Object)(System.currentTimeMillis() + 500L), (Object)"queryId", (Object)"never-ending-future"));
        Sequence results = this.client.run(QueryPlus.wrap((Query)query));
        QueryInterruptedException actualException = null;
        try {
            results.toList();
        }
        catch (QueryInterruptedException e) {
            actualException = e;
        }
        Assert.assertNotNull((Object)((Object)actualException));
        Assert.assertEquals((Object)"Query timeout", (Object)actualException.getErrorCode());
        Assert.assertEquals((Object)"Timeout waiting for task.", (Object)actualException.getMessage());
        Assert.assertEquals((Object)"localhost:8080", (Object)actualException.getHost());
        EasyMock.verify((Object[])new Object[]{this.httpClient});
    }
}

