/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.io.DruidRecordWriter;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.segment.IndexSpec;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndex;
import org.apache.hive.druid.org.apache.druid.segment.QueryableIndexStorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.StorageAdapter;
import org.apache.hive.druid.org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.data.RoaringBitmapSerdeFactory;
import org.apache.hive.druid.org.apache.druid.segment.indexing.DataSchema;
import org.apache.hive.druid.org.apache.druid.segment.indexing.RealtimeTuningConfig;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.hive.druid.org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPusher;
import org.apache.hive.druid.org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.hive.druid.org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.IngestSegmentFirehose;
import org.apache.hive.druid.org.apache.druid.segment.realtime.firehose.WindowedStorageAdapter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDruidRecordWriter {
    private final ObjectMapper objectMapper = DruidStorageHandlerUtils.JSON_MAPPER;
    private static final Interval INTERVAL_FULL = new Interval((Object)"2014-10-22T00:00:00Z/P1D");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    final List<ImmutableMap<String, Object>> expectedRows = ImmutableList.of((Object)ImmutableMap.of((Object)"__time", (Object)DateTime.parse((String)"2014-10-22T00:00:00.000Z").getMillis(), (Object)"host", (Object)ImmutableList.of((Object)"a.example.com"), (Object)"visited_sum", (Object)190L, (Object)"unique_hosts", (Object)1.0), (Object)ImmutableMap.of((Object)"__time", (Object)DateTime.parse((String)"2014-10-22T01:00:00.000Z").getMillis(), (Object)"host", (Object)ImmutableList.of((Object)"b.example.com"), (Object)"visited_sum", (Object)175L, (Object)"unique_hosts", (Object)1.0), (Object)ImmutableMap.of((Object)"__time", (Object)DateTime.parse((String)"2014-10-22T02:00:00.000Z").getMillis(), (Object)"host", (Object)ImmutableList.of((Object)"c.example.com"), (Object)"visited_sum", (Object)270L, (Object)"unique_hosts", (Object)1.0));

    @Test
    public void testTimeStampColumnName() {
        Assert.assertEquals((String)"Time column name need to match to ensure serdeser compatibility", (Object)"__time", (Object)"__time");
    }

    @Ignore
    @Test
    public void testWrite() throws IOException, SegmentLoadingException {
        String dataSourceName = "testDataSource";
        final File segmentOutputDir = this.temporaryFolder.newFolder();
        File workingDir = this.temporaryFolder.newFolder();
        Configuration config = new Configuration();
        MapInputRowParser inputRowParser = new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("__time", "auto", null), new DimensionsSpec((List)ImmutableList.of((Object)new StringDimensionSchema("host")), null, null)));
        Map parserMap = (Map)this.objectMapper.convertValue((Object)inputRowParser, (TypeReference)new TypeReference<Map<String, Object>>(){});
        DataSchema dataSchema = new DataSchema("testDataSource", parserMap, new AggregatorFactory[]{new LongSumAggregatorFactory("visited_sum", "visited_sum"), new HyperUniquesAggregatorFactory("unique_hosts", "unique_hosts")}, (GranularitySpec)new UniformGranularitySpec(Granularities.DAY, Granularities.NONE, (List)ImmutableList.of((Object)INTERVAL_FULL)), null, this.objectMapper);
        IndexSpec indexSpec = new IndexSpec((BitmapSerdeFactory)new RoaringBitmapSerdeFactory(Boolean.valueOf(true)), null, null, null);
        RealtimeTuningConfig tuningConfig = new RealtimeTuningConfig(null, null, null, null, this.temporaryFolder.newFolder(), null, null, null, null, indexSpec, null, null, 0, 0, null, null, Long.valueOf(0L), null, null);
        LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)config);
        LocalDataSegmentPusher dataSegmentPusher = new LocalDataSegmentPusher(new LocalDataSegmentPusherConfig(){

            public File getStorageDirectory() {
                return segmentOutputDir;
            }
        });
        Path segmentDescriptorPath = new Path(workingDir.getAbsolutePath(), "segmentsDescriptorDir");
        DruidRecordWriter druidRecordWriter = new DruidRecordWriter(dataSchema, tuningConfig, (DataSegmentPusher)dataSegmentPusher, 20, segmentDescriptorPath, (FileSystem)localFileSystem);
        List druidWritables = this.expectedRows.stream().map(input -> new DruidWritable((Map)ImmutableMap.builder().putAll((Map)input).put((Object)"__time_granularity", (Object)Granularities.DAY.bucketStart(new DateTime(((Long)input.get((Object)"__time")).longValue())).getMillis()).build())).collect(Collectors.toList());
        for (DruidWritable druidWritable : druidWritables) {
            druidRecordWriter.write((Writable)druidWritable);
        }
        druidRecordWriter.close(false);
        List dataSegmentList = DruidStorageHandlerUtils.getCreatedSegments((Path)segmentDescriptorPath, (Configuration)config);
        Assert.assertEquals((long)1L, (long)dataSegmentList.size());
        File tmpUnzippedSegmentDir = this.temporaryFolder.newFolder();
        new LocalDataSegmentPuller().getSegmentFiles((DataSegment)dataSegmentList.get(0), tmpUnzippedSegmentDir);
        QueryableIndex queryableIndex = DruidStorageHandlerUtils.INDEX_IO.loadIndex(tmpUnzippedSegmentDir);
        QueryableIndexStorageAdapter adapter = new QueryableIndexStorageAdapter(queryableIndex);
        IngestSegmentFirehose firehose = new IngestSegmentFirehose((List)ImmutableList.of((Object)new WindowedStorageAdapter((StorageAdapter)adapter, adapter.getInterval())), null, (List)ImmutableList.of((Object)"host"), (List)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), null);
        ArrayList rows = Lists.newArrayList();
        while (firehose.hasMore()) {
            rows.add(firehose.nextRow());
        }
        this.verifyRows(this.expectedRows, rows);
    }

    private void verifyRows(List<ImmutableMap<String, Object>> expectedRows, List<InputRow> actualRows) {
        System.out.println("actualRows = " + actualRows);
        Assert.assertEquals((long)expectedRows.size(), (long)actualRows.size());
        for (int i = 0; i < expectedRows.size(); ++i) {
            Map expected = (Map)expectedRows.get(i);
            InputRow actual = actualRows.get(i);
            Assert.assertEquals((Object)ImmutableList.of((Object)"host"), (Object)actual.getDimensions());
            Assert.assertEquals(expected.get("__time"), (Object)actual.getTimestamp().getMillis());
            Assert.assertEquals(expected.get("host"), (Object)actual.getDimension("host"));
            Assert.assertEquals(expected.get("visited_sum"), (Object)actual.getMetric("visited_sum"));
            Assert.assertEquals((double)((Double)expected.get("unique_hosts")), (double)((Double)HyperUniquesAggregatorFactory.estimateCardinality((Object)actual.getRaw("unique_hosts"), (boolean)false)), (double)0.001);
        }
    }

    @Test
    public void testSerDesr() throws IOException {
        String segment = "{\"dataSource\":\"datasource2015\",\"interval\":\"2015-06-01T00:00:00.000-04:00/2015-06-02T00:00:00.000-04:00\",\"version\":\"2016-11-04T19:24:01.732-04:00\",\"loadSpec\":{\"type\":\"hdfs\",\"path\":\"hdfs://cn105-10.l42scl.hortonworks.com:8020/apps/hive/warehouse/druid.db/.hive-staging_hive_2016-11-04_19-23-50_168_1550339856804207572-1/_task_tmp.-ext-10002/_tmp.000000_0/datasource2015/20150601T000000.000-0400_20150602T000000.000-0400/2016-11-04T19_24_01.732-04_00/0/index.zip\"},\"dimensions\":\"dimension1\",\"metrics\":\"bigint\",\"shardSpec\":{\"type\":\"linear\",\"partitionNum\":0},\"binaryVersion\":9,\"size\":1765,\"identifier\":\"datasource2015_2015-06-01T00:00:00.000-04:00_2015-06-02T00:00:00.000-04:00_2016-11-04T19:24:01.732-04:00\"}";
        DataSegment dataSegment = (DataSegment)this.objectMapper.readerFor(DataSegment.class).readValue(segment);
        Assert.assertEquals((Object)"datasource2015", (Object)dataSegment.getDataSource());
    }
}

