/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.QTestDruidSerDe;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidSerDe;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.SettableFuture;
import org.apache.hive.druid.org.apache.druid.data.input.Row;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.HttpClient;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.Request;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.scan.ScanResultValue;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.query.topn.TopNResultValue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestDruidSerDe {
    private static final String TIMESERIES_QUERY = "{  \"queryType\": \"timeseries\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"descending\": \"true\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"sample_dimension1\", \"value\": \"sample_value1\" },      { \"type\": \"or\",        \"fields\": [          { \"type\": \"selector\", \"dimension\": \"sample_dimension2\", \"value\": \"sample_value2\" },          { \"type\": \"selector\", \"dimension\": \"sample_dimension3\", \"value\": \"sample_value3\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"sample_name1\", \"fieldName\": \"sample_fieldName1\" },    { \"type\": \"doubleSum\", \"name\": \"sample_name2\", \"fieldName\": \"sample_fieldName2\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name1\", \"fieldName\": \"sample_name1\" },        { \"type\": \"fieldAccess\", \"name\": \"postAgg__sample_name2\", \"fieldName\": \"sample_name2\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ]}";
    private static final String TIMESERIES_QUERY_RESULTS = "[  {    \"timestamp\": \"2012-01-01T00:00:00.000Z\",    \"result\": { \"sample_name1\": 0, \"sample_name2\": 1.0, \"sample_divide\": 2.2222 }   },  {    \"timestamp\": \"2012-01-02T00:00:00.000Z\",    \"result\": { \"sample_name1\": 2, \"sample_name2\": 3.32, \"sample_divide\": 4 }  }]";
    private byte[] tsQueryResults;
    private byte[] topNQueryResults;
    private byte[] groupByQueryResults;
    private byte[] groupByTimeExtractQueryResults;
    private byte[] selectQueryResults;
    private byte[] groupByMonthExtractQueryResults;
    private byte[] scanQueryResults;
    private static final Object[][] TIMESERIES_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC)), 0L, Float.valueOf(1.0f), Float.valueOf(2.2222f)}, {new TimestampTZ(Instant.ofEpochMilli(1325462400000L).atZone(ZoneOffset.UTC)), 2L, Float.valueOf(3.32f), Float.valueOf(4.0f)}};
    private static final String TIMESERIES_COLUMN_NAMES = "timestamp,sample_name1,sample_name2,sample_divide";
    private static final String TIMESERIES_COLUMN_TYPES = "timestamp with local time zone,bigint,float,float";
    private static final String TOPN_QUERY = "{  \"queryType\": \"topN\",  \"dataSource\": \"sample_data\",  \"dimension\": \"sample_dim\",  \"threshold\": 5,  \"metric\": \"count\",  \"granularity\": \"all\",  \"filter\": {    \"type\": \"and\",    \"fields\": [      {        \"type\": \"selector\",        \"dimension\": \"dim1\",        \"value\": \"some_value\"      },      {        \"type\": \"selector\",        \"dimension\": \"dim2\",        \"value\": \"some_other_val\"      }    ]  },  \"aggregations\": [    {      \"type\": \"longSum\",      \"name\": \"count\",      \"fieldName\": \"count\"    },    {      \"type\": \"doubleSum\",      \"name\": \"some_metric\",      \"fieldName\": \"some_metric\"    }  ],  \"postAggregations\": [    {      \"type\": \"arithmetic\",      \"name\": \"sample_divide\",      \"fn\": \"/\",      \"fields\": [        {          \"type\": \"fieldAccess\",          \"name\": \"some_metric\",          \"fieldName\": \"some_metric\"        },        {          \"type\": \"fieldAccess\",          \"name\": \"count\",          \"fieldName\": \"count\"        }      ]    }  ],  \"intervals\": [    \"2013-08-31T00:00:00.000/2013-09-03T00:00:00.000\"  ]}";
    private static final String TOPN_QUERY_RESULTS = "[  {    \"timestamp\": \"2013-08-31T00:00:00.000Z\",    \"result\": [      {        \"sample_dim\": \"dim1_val\",        \"count\": 111,        \"some_metric\": 10669,        \"sample_divide\": 96.11711711711712      },      {        \"sample_dim\": \"another_dim1_val\",        \"count\": 88,        \"some_metric\": 28344,        \"sample_divide\": 322.09090909090907      },      {        \"sample_dim\": \"dim1_val3\",        \"count\": 70,        \"some_metric\": 871,        \"sample_divide\": 12.442857142857143      },      {        \"sample_dim\": \"dim1_val4\",        \"count\": 62,        \"some_metric\": 815,        \"sample_divide\": 13.14516129032258      },      {        \"sample_dim\": \"dim1_val5\",        \"count\": 60,        \"some_metric\": 2787,        \"sample_divide\": 46.45      }    ]  }]";
    private static final Object[][] TOPN_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "dim1_val", 111L, Float.valueOf(10669.0f), Float.valueOf(96.11712f)}, {new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "another_dim1_val", 88L, Float.valueOf(28344.0f), Float.valueOf(322.0909f)}, {new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "dim1_val3", 70L, Float.valueOf(871.0f), Float.valueOf(12.442857f)}, {new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "dim1_val4", 62L, Float.valueOf(815.0f), Float.valueOf(13.145162f)}, {new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "dim1_val5", 60L, Float.valueOf(2787.0f), Float.valueOf(46.45f)}};
    private static final String TOPN_COLUMN_NAMES = "timestamp,sample_dim,count,some_metric,sample_divide";
    private static final String TOPN_COLUMN_TYPES = "timestamp with local time zone,string,bigint,float,float";
    private static final String GROUP_BY_QUERY = "{  \"queryType\": \"groupBy\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"dimensions\": [\"country\", \"device\"],  \"limitSpec\": { \"type\": \"default\", \"limit\": 5000, \"columns\": [\"country\", \"data_transfer\"] },  \"filter\": {    \"type\": \"and\",    \"fields\": [      { \"type\": \"selector\", \"dimension\": \"carrier\", \"value\": \"AT&T\" },      { \"type\": \"or\",         \"fields\": [          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Apple\" },          { \"type\": \"selector\", \"dimension\": \"make\", \"value\": \"Samsung\" }        ]      }    ]  },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"total_usage\", \"fieldName\": \"user_count\" },    { \"type\": \"doubleSum\", \"name\": \"data_transfer\", \"fieldName\": \"data_transfer\" }  ],  \"postAggregations\": [    { \"type\": \"arithmetic\",      \"name\": \"avg_usage\",      \"fn\": \"/\",      \"fields\": [        { \"type\": \"fieldAccess\", \"fieldName\": \"data_transfer\" },        { \"type\": \"fieldAccess\", \"fieldName\": \"total_usage\" }      ]    }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\" ],  \"having\": {    \"type\": \"greaterThan\",    \"aggregation\": \"total_usage\",    \"value\": 100  }}";
    private static final String GROUP_BY_QUERY_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"country\" : \"India\",      \"device\" : \"phone\",      \"total_usage\" : 88,      \"data_transfer\" : 29.91233453,      \"avg_usage\" : 60.32    }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"country\" : \"Spain\",      \"device\" : \"pc\",      \"total_usage\" : 16,      \"data_transfer\" : 172.93494959,      \"avg_usage\" : 6.333333    }  }]";
    private static final String GB_TIME_EXTRACTIONS = "{\"queryType\":\"groupBy\",\"dataSource\":\"sample_datasource\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'\",\"timeZone\":\"UTC\"}}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"$f1\"}],\"intervals\":[\"1900-01-01T00:00:00.000/3000-01-01T00:00:00.000\"]}";
    private static final String GB_TIME_EXTRACTIONS_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"extract\" : \"2012-01-01T00:00:00.000Z\",      \"$f1\" : 200  }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"extract\" : \"2012-01-01T00:00:12.000Z\",      \"$f1\" : 400  }   }]";
    private static final String GB_MONTH_EXTRACTIONS_RESULTS = "[   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:00.000Z\",    \"event\" : {      \"extract_month\" : \"01\",      \"$f1\" : 200  }  },   {    \"version\" : \"v1\",    \"timestamp\" : \"2012-01-01T00:00:12.000Z\",    \"event\" : {      \"extract_month\" : \"01\",      \"$f1\" : 400  }   }]";
    private static final String GB_MONTH_EXTRACTIONS = "{\"queryType\":\"groupBy\",\"dataSource\":\"sample_datasource\",\"granularity\":\"all\",\"dimensions\":[{\"type\":\"extraction\",\"dimension\":\"__time\",\"outputName\":\"extract_month\",\"extractionFn\":{\"type\":\"timeFormat\",\"format\":\"M\",\"timeZone\":\"UTC\",\"locale\":\"en-US\"}}],\"limitSpec\":{\"type\":\"default\"},\"aggregations\":[{\"type\":\"count\",\"name\":\"$f1\"}],\"intervals\":[\"1900-01-01T00:00:00.000/3000-01-01T00:00:00.000\"]}";
    private static final Object[][] GROUP_BY_QUERY_EXTRACTION_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC)), new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC)), 200L}, {new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC)), new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC)), 400L}};
    private static final Object[][] GROUP_BY_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC)), "India", "phone", 88L, 29.91233453, Float.valueOf(60.32f)}, {new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC)), "Spain", "pc", 16L, 172.93494959, Float.valueOf(6.333333f)}};
    private static final Object[][] GB_MONTH_EXTRACTION_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1325376000000L).atZone(ZoneOffset.UTC)), 1, 200L}, {new TimestampTZ(Instant.ofEpochMilli(1325376012000L).atZone(ZoneOffset.UTC)), 1, 400L}};
    private static final String GROUP_BY_COLUMN_NAMES = "timestamp,country,device,total_usage,data_transfer,avg_usage";
    private static final String GROUP_BY_COLUMN_TYPES = "timestamp with local time zone,string,string,bigint,double,float";
    private static final String GB_TIME_EXTRACTIONS_COLUMN_NAMES = "timestamp,extract,$f1";
    private static final String GB_TIME_EXTRACTIONS_COLUMN_TYPES = "timestamp with local time zone,timestamp with local time zone,bigint";
    private static final String GB_MONTH_EXTRACTIONS_COLUMN_NAMES = "timestamp,extract_month,$f1";
    private static final String GB_MONTH_EXTRACTIONS_COLUMN_TYPES = "timestamp with local time zone,int,bigint";
    private static final String SCAN_COLUMN_NAMES = "__time,robot,namespace,anonymous,unpatrolled,page,language,newpage,user,count,added,delta,variation,deleted";
    private static final String SCAN_COLUMN_TYPES = "timestamp with local time zone,boolean,string,string,string,string,string,string,string,double,double,float,float,float";
    private static final Object[][] SCAN_QUERY_RESULTS_RECORDS = new Object[][]{{new TimestampTZ(Instant.ofEpochMilli(1356998400000L).atZone(ZoneOffset.UTC)), Boolean.TRUE, "article", "0", "0", "11._korpus_(NOVJ)", "sl", "0", "EmausBot", 1.0, 39.0, Float.valueOf(39.0f), Float.valueOf(39.0f), Float.valueOf(0.0f)}, {new TimestampTZ(Instant.ofEpochMilli(1356998400000L).atZone(ZoneOffset.UTC)), Boolean.FALSE, "article", "0", "0", "112_U.S._580", "en", "1", "MZMcBride", 1.0, 70.0, Float.valueOf(70.0f), Float.valueOf(70.0f), Float.valueOf(0.0f)}, {new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC)), Boolean.FALSE, "article", "0", "0", "113_U.S._243", "en", "1", "MZMcBride", 1.0, 77.0, Float.valueOf(77.0f), Float.valueOf(77.0f), Float.valueOf(0.0f)}, {new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC)), Boolean.FALSE, "article", "0", "0", "113_U.S._73", "en", "1", "MZMcBride", 1.0, 70.0, Float.valueOf(70.0f), Float.valueOf(70.0f), Float.valueOf(0.0f)}, {new TimestampTZ(Instant.ofEpochMilli(1356998412000L).atZone(ZoneOffset.UTC)), Boolean.FALSE, "article", "0", "0", "113_U.S._756", "en", "1", "MZMcBride", 1.0, 68.0, Float.valueOf(68.0f), Float.valueOf(68.0f), Float.valueOf(0.0f)}};
    private static final String SCAN_QUERY = "{   \"queryType\": \"scan\",   \"dataSource\": \"wikipedia\",   \"descending\": \"false\",   \"columns\":[\"robot\",\"namespace\",\"anonymous\",\"unpatrolled\",\"page\",\"language\",\"newpage\",\"user\",\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],   \"granularity\": \"all\",   \"intervals\": [     \"2013-01-01/2013-01-02\"   ], \"resultFormat\": \"compactedList\", \"limit\": 5}";
    private static final String SCAN_QUERY_RESULTS = "[{\"segmentId\":\"wikipedia_2012-12-29T00:00:00.000Z_2013-01-10T08:00:00.000Z_2013-01-10T08:13:47.830Z_v9\",\"columns\":[\"__time\",\"robot\",\"namespace\",\"anonymous\",\"unpatrolled\",\"page\",\"language\",\"newpage\",\"user\",\"count\",\"added\",\"delta\",\"variation\",\"deleted\"],\"events\":[[\"2013-01-01T00:00:00.000Z\", 1,\"article\",\"0\",\"0\",\"11._korpus_(NOVJ)\",\"sl\",\"0\",\"EmausBot\",1.0,39.0,39.0,39.0,0.0],[\"2013-01-01T00:00:00.000Z\", 0,\"article\",\"0\",\"0\",\"112_U.S._580\",\"en\",\"1\",\"MZMcBride\",1.0,70.0,70.0,70.0,0.0],[\"2013-01-01T00:00:12.000Z\", 0,\"article\",\"0\",\"0\",\"113_U.S._243\",\"en\",\"1\",\"MZMcBride\",1.0,77.0,77.0,77.0,0.0],[\"2013-01-01T00:00:12.000Z\", 0,\"article\",\"0\",\"0\",\"113_U.S._73\",\"en\",\"1\",\"MZMcBride\",1.0,70.0,70.0,70.0,0.0],[\"2013-01-01T00:00:12.000Z\", 0,\"article\",\"0\",\"0\",\"113_U.S._756\",\"en\",\"1\",\"MZMcBride\",1.0,68.0,68.0,68.0,0.0]]}]";
    private static final String COLUMN_NAMES = "__time,c0,c1,c2,c3,c4,c5,c6,c7,c8";
    private static final String COLUMN_TYPES = "timestamp with local time zone,string,char(6),varchar(8),double,float,bigint,int,smallint,tinyint";
    private static final Object[] ROW_OBJECT = new Object[]{new TimestampLocalTZWritable(new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC))), new Text("dim1_val"), new HiveCharWritable(new HiveChar("dim2_v", 6)), new HiveVarcharWritable(new HiveVarchar("dim3_val", 8)), new DoubleWritable(10669.3), new FloatWritable(10669.45f), new LongWritable(1113939L), new IntWritable(1112123), new ShortWritable(12), new ByteWritable(0), new TimestampWritableV2(Timestamp.ofEpochSecond((long)1377907200L))};
    private static final DruidWritable DRUID_WRITABLE = new DruidWritable((Map)ImmutableMap.builder().put((Object)"__time", (Object)1377907200000L).put((Object)"c0", (Object)"dim1_val").put((Object)"c1", (Object)"dim2_v").put((Object)"c2", (Object)"dim3_val").put((Object)"c3", (Object)10669.3).put((Object)"c4", (Object)Float.valueOf(10669.45f)).put((Object)"c5", (Object)1113939L).put((Object)"c6", (Object)1112123).put((Object)"c7", (Object)12).put((Object)"c8", (Object)0).put((Object)"__time_granularity", (Object)1377907200000L).build());
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();
    private static final Object[] ROW_OBJECT_2 = new Object[]{new TimestampTZ(Instant.ofEpochMilli(1377907200000L).atZone(ZoneOffset.UTC)), "dim1_val", new HiveChar("dim2_v", 6), new HiveVarchar("dim3_val", 8), 10669.3, Float.valueOf(10669.45f), 1113939L, 1112123, (short)12, (byte)0};
    private static final DruidWritable DRUID_WRITABLE_2 = new DruidWritable((Map)ImmutableMap.builder().put((Object)"__time", (Object)1377907200000L).put((Object)"c0", (Object)"dim1_val").put((Object)"c1", (Object)"dim2_v").put((Object)"c2", (Object)"dim3_val").put((Object)"c3", (Object)10669.3).put((Object)"c4", (Object)Float.valueOf(10669.45f)).put((Object)"c5", (Object)1113939L).put((Object)"c6", (Object)1112123).put((Object)"c7", (Object)12).put((Object)"c8", (Object)0).build());

    @Before
    public void setup() throws IOException {
        this.tsQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(TIMESERIES_QUERY_RESULTS, (TypeReference)new TypeReference<List<Result<TimeseriesResultValue>>>(){}));
        this.topNQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(TOPN_QUERY_RESULTS, (TypeReference)new TypeReference<List<Result<TopNResultValue>>>(){}));
        this.groupByQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GROUP_BY_QUERY_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.groupByTimeExtractQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GB_TIME_EXTRACTIONS_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.groupByMonthExtractQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(GB_MONTH_EXTRACTIONS_RESULTS, (TypeReference)new TypeReference<List<Row>>(){}));
        this.scanQueryResults = DruidStorageHandlerUtils.SMILE_MAPPER.writeValueAsBytes(DruidStorageHandlerUtils.JSON_MAPPER.readValue(SCAN_QUERY_RESULTS, (TypeReference)new TypeReference<List<ScanResultValue>>(){}));
    }

    @Test
    public void testDruidDeserializer() throws SerDeException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        QTestDruidSerDe serDe = new QTestDruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "timeseries", TIMESERIES_QUERY, TIMESERIES_COLUMN_NAMES, TIMESERIES_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "timeseries", TIMESERIES_QUERY, this.tsQueryResults, TIMESERIES_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_data", "topN", TOPN_QUERY, TOPN_COLUMN_NAMES, TOPN_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "topN", TOPN_QUERY, this.topNQueryResults, TOPN_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GROUP_BY_QUERY, GROUP_BY_COLUMN_NAMES, GROUP_BY_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GROUP_BY_QUERY, this.groupByQueryResults, GROUP_BY_QUERY_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GB_TIME_EXTRACTIONS, GB_TIME_EXTRACTIONS_COLUMN_NAMES, GB_TIME_EXTRACTIONS_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GB_TIME_EXTRACTIONS, this.groupByTimeExtractQueryResults, GROUP_BY_QUERY_EXTRACTION_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("sample_datasource", "groupBy", GB_MONTH_EXTRACTIONS, GB_MONTH_EXTRACTIONS_COLUMN_NAMES, GB_MONTH_EXTRACTIONS_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "groupBy", GB_MONTH_EXTRACTIONS, this.groupByMonthExtractQueryResults, GB_MONTH_EXTRACTION_RESULTS_RECORDS);
        tbl = TestDruidSerDe.createPropertiesQuery("wikipedia", "scan", SCAN_QUERY, SCAN_COLUMN_NAMES, SCAN_COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        this.deserializeQueryResults(serDe, "scan", SCAN_QUERY, this.scanQueryResults, SCAN_QUERY_RESULTS_RECORDS);
    }

    private static Properties createPropertiesQuery(String dataSource, String queryType, String jsonQuery, String columnNames, String columnTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("druid.datasource", dataSource);
        tbl.setProperty("druid.query.json", jsonQuery);
        tbl.setProperty("druid.query.type", queryType);
        tbl.setProperty("druid.fieldNames", columnNames);
        tbl.setProperty("druid.fieldTypes", columnTypes);
        return tbl;
    }

    private void deserializeQueryResults(DruidSerDe serDe, String queryType, String jsonQuery, byte[] resultString, Object[][] records) throws SerDeException, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        Object fieldData;
        int i;
        Object[] expectedFieldsData;
        List row;
        HttpClient httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        SettableFuture futureResult = SettableFuture.create();
        futureResult.set((Object)new ByteArrayInputStream(resultString));
        Mockito.when((Object)httpClient.go((Request)ArgumentMatchers.any(), (HttpResponseHandler)ArgumentMatchers.any(HttpResponseHandler.class))).thenReturn((Object)futureResult);
        DruidQueryRecordReader reader = DruidQueryBasedInputFormat.getDruidQueryReader((String)queryType);
        HiveDruidSplit split = new HiveDruidSplit(jsonQuery, new Path("empty"), new String[]{"testing_host"});
        Configuration conf = new Configuration();
        reader.initialize((InputSplit)split, DruidStorageHandlerUtils.JSON_MAPPER, DruidStorageHandlerUtils.SMILE_MAPPER, httpClient, conf);
        StructObjectInspector oi = (StructObjectInspector)serDe.getObjectInspector();
        List fieldRefs = oi.getAllStructFieldRefs();
        DruidWritable writable = reader.createValue();
        int pos = 0;
        while (reader.next(NullWritable.get(), writable)) {
            row = (List)serDe.deserialize((Writable)writable);
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                Assert.assertEquals((String)("Field " + i + " type"), expectedFieldsData[i].getClass(), row.get(i).getClass());
                fieldData = oi.getStructFieldData((Object)row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
        futureResult = SettableFuture.create();
        futureResult.set((Object)new ByteArrayInputStream(resultString));
        Mockito.when((Object)httpClient.go((Request)ArgumentMatchers.any(), (HttpResponseHandler)ArgumentMatchers.any(HttpResponseHandler.class))).thenReturn((Object)futureResult);
        reader = DruidQueryBasedInputFormat.getDruidQueryReader((String)queryType);
        reader.initialize((InputSplit)split, DruidStorageHandlerUtils.JSON_MAPPER, DruidStorageHandlerUtils.SMILE_MAPPER, httpClient, conf);
        pos = 0;
        while (reader.nextKeyValue()) {
            row = (List)serDe.deserialize((Writable)reader.getCurrentValue());
            expectedFieldsData = records[pos];
            Assert.assertEquals((long)expectedFieldsData.length, (long)fieldRefs.size());
            for (i = 0; i < fieldRefs.size(); ++i) {
                Assert.assertEquals((String)("Field " + i + " type"), expectedFieldsData[i].getClass(), row.get(i).getClass());
                fieldData = oi.getStructFieldData((Object)row, (StructField)fieldRefs.get(i));
                Assert.assertEquals((String)("Field " + i), (Object)expectedFieldsData[i], (Object)fieldData);
            }
            ++pos;
        }
        Assert.assertEquals((long)pos, (long)records.length);
    }

    @Test
    public void testDruidObjectSerializer() throws SerDeException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        TestDruidSerDe.serializeObject(tbl, serDe, ROW_OBJECT, DRUID_WRITABLE);
    }

    @Test
    public void testDruidObjectSerializerwithNullTimestamp() throws Exception {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        Object[] row = new Object[]{null, new Text("dim1_val"), new HiveCharWritable(new HiveChar("dim2_v", 6)), new HiveVarcharWritable(new HiveVarchar("dim3_val", 8)), new DoubleWritable(10669.3), new FloatWritable(10669.45f), new LongWritable(1113939L), new IntWritable(1112123), new ShortWritable(12), new ByteWritable(0), null};
        this.expectedEx.expect(NullPointerException.class);
        this.expectedEx.expectMessage("Timestamp column cannot have null value");
        TestDruidSerDe.serializeObject(tbl, serDe, row, DRUID_WRITABLE);
    }

    private static Properties createPropertiesSource(String columnNames, String columnTypes) {
        Properties tbl = new Properties();
        tbl.setProperty("columns", columnNames);
        tbl.setProperty("columns.types", columnTypes);
        return tbl;
    }

    private static void serializeObject(Properties properties, DruidSerDe serDe, Object[] rowObject, DruidWritable druidWritable) throws SerDeException {
        ArrayList<String> columnNames = new ArrayList<String>(Utilities.getColumnNames((Properties)properties));
        columnNames.add("__time_granularity");
        List columnTypes = Utilities.getColumnTypes((Properties)properties).stream().map(TypeInfoFactory::getPrimitiveTypeInfo).collect(Collectors.toList());
        columnTypes.add(TypeInfoFactory.getPrimitiveTypeInfo((String)"timestamp"));
        List inspectors = columnTypes.stream().map(PrimitiveObjectInspectorFactory::getPrimitiveWritableObjectInspector).collect(Collectors.toList());
        StandardStructObjectInspector inspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, inspectors);
        DruidWritable writable = (DruidWritable)serDe.serialize((Object)rowObject, (ObjectInspector)inspector);
        Assert.assertEquals((long)druidWritable.getValue().size(), (long)writable.getValue().size());
        for (Map.Entry e : druidWritable.getValue().entrySet()) {
            Assert.assertEquals(e.getValue(), writable.getValue().get(e.getKey()));
        }
    }

    @Test
    public void testDruidObjectDeserializer() throws SerDeException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException, IOException, InterruptedException, NoSuchMethodException, InvocationTargetException {
        DruidSerDe serDe = new DruidSerDe();
        Configuration conf = new Configuration();
        Properties tbl = TestDruidSerDe.createPropertiesSource(COLUMN_NAMES, COLUMN_TYPES);
        serDe.initialize(conf, tbl, null);
        TestDruidSerDe.deserializeObject(serDe, ROW_OBJECT_2, DRUID_WRITABLE_2);
    }

    private static void deserializeObject(DruidSerDe serDe, Object[] rowObject, DruidWritable druidWritable) throws SerDeException {
        List object = (List)serDe.deserialize((Writable)druidWritable);
        Assert.assertEquals((long)rowObject.length, (long)object.size());
        for (int i = 0; i < rowObject.length; ++i) {
            Assert.assertEquals(rowObject[i].getClass(), object.get(i).getClass());
            Assert.assertEquals((Object)rowObject[i], object.get(i));
        }
    }
}

