/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.druid.io.DruidQueryBasedInputFormat;
import org.apache.hadoop.hive.druid.io.HiveDruidSplit;
import org.junit.Assert;
import org.junit.Test;

public class TestHiveDruidQueryBasedInputFormat {
    private static final String TIMESERIES_QUERY = "{  \"queryType\": \"timeseries\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"DAY\",  \"descending\": \"true\",  \"intervals\": [ \"2012-01-01T00:00:00.000-08:00/2012-01-03T00:00:00.000-08:00\" ]}";
    private static final String TIMESERIES_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_datasource\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2012-01-01T08:00:00.000Z/2012-01-03T08:00:00.000Z\"]},\"descending\":true,\"virtualColumns\":[],\"filter\":null,\"granularity\":\"DAY\",\"aggregations\":[],\"postAggregations\":[],\"limit\":2147483647,\"context\":{\"queryId\":\"\"}}, [localhost:8082]}]";
    private static final String TOPN_QUERY = "{  \"queryType\": \"topN\",  \"dataSource\": \"sample_data\",  \"dimension\": \"sample_dim\",  \"threshold\": 5,  \"metric\": \"count\",  \"aggregations\": [    {      \"type\": \"longSum\",      \"name\": \"count\",      \"fieldName\": \"count\"    },    {      \"type\": \"doubleSum\",      \"name\": \"some_metric\",      \"fieldName\": \"some_metric\"    }  ],  \"granularity\": \"all\",  \"intervals\": [    \"2013-08-31T00:00:00.000-07:00/2013-09-03T00:00:00.000-07:00\"  ]}";
    private static final String TOPN_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"topN\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_data\"},\"virtualColumns\":[],\"dimension\":{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"sample_dim\",\"outputName\":\"sample_dim\",\"outputType\":\"STRING\"},\"metric\":{\"type\":\"LegacyTopNMetricSpec\",\"metric\":\"count\"},\"threshold\":5,\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2013-08-31T07:00:00.000Z/2013-09-03T07:00:00.000Z\"]},\"filter\":null,\"granularity\":{\"type\":\"all\"},\"aggregations\":[{\"type\":\"longSum\",\"name\":\"count\",\"fieldName\":\"count\",\"expression\":null},{\"type\":\"doubleSum\",\"name\":\"some_metric\",\"fieldName\":\"some_metric\",\"expression\":null}],\"postAggregations\":[],\"context\":{\"queryId\":\"\"},\"descending\":false}, [localhost:8082]}]";
    private static final String GROUP_BY_QUERY = "{  \"queryType\": \"groupBy\",  \"dataSource\": \"sample_datasource\",  \"granularity\": \"day\",  \"dimensions\": [\"country\", \"device\"],  \"limitSpec\": { \"type\": \"default\", \"limit\": 5000, \"columns\": [\"country\", \"data_transfer\"] },  \"aggregations\": [    { \"type\": \"longSum\", \"name\": \"total_usage\", \"fieldName\": \"user_count\" },    { \"type\": \"doubleSum\", \"name\": \"data_transfer\", \"fieldName\": \"data_transfer\" }  ],  \"intervals\": [ \"2012-01-01T00:00:00.000-08:00/2012-01-03T00:00:00.000-08:00\" ] }";
    private static final String GROUP_BY_QUERY_SPLIT = "[HiveDruidSplit{{\"queryType\":\"groupBy\",\"dataSource\":{\"type\":\"table\",\"name\":\"sample_datasource\"},\"intervals\":{\"type\":\"LegacySegmentSpec\",\"intervals\":[\"2012-01-01T08:00:00.000Z/2012-01-03T08:00:00.000Z\"]},\"virtualColumns\":[],\"filter\":null,\"granularity\":\"DAY\",\"dimensions\":[{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"country\",\"outputName\":\"country\",\"outputType\":\"STRING\"},{\"type\":\"LegacyDimensionSpec\",\"dimension\":\"device\",\"outputName\":\"device\",\"outputType\":\"STRING\"}],\"aggregations\":[{\"type\":\"longSum\",\"name\":\"total_usage\",\"fieldName\":\"user_count\",\"expression\":null},{\"type\":\"doubleSum\",\"name\":\"data_transfer\",\"fieldName\":\"data_transfer\",\"expression\":null}],\"postAggregations\":[],\"having\":null,\"limitSpec\":{\"type\":\"default\",\"columns\":[{\"dimension\":\"country\",\"direction\":\"ascending\",\"dimensionOrder\":{\"type\":\"lexicographic\"}},{\"dimension\":\"data_transfer\",\"direction\":\"ascending\",\"dimensionOrder\":{\"type\":\"lexicographic\"}}],\"limit\":5000},\"context\":{\"queryId\":\"\"},\"descending\":false}, [localhost:8082]}]";

    @Test
    public void testTimeZone() throws Exception {
        DruidQueryBasedInputFormat input = new DruidQueryBasedInputFormat();
        Method method1 = DruidQueryBasedInputFormat.class.getDeclaredMethod("getInputSplits", Configuration.class);
        method1.setAccessible(true);
        Configuration conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "timeseries", TIMESERIES_QUERY);
        Object[] resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        Assert.assertEquals((Object)TIMESERIES_QUERY_SPLIT, (Object)Arrays.toString(resultSplits));
        conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "topN", TOPN_QUERY);
        resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        Assert.assertEquals((Object)TOPN_QUERY_SPLIT, (Object)Arrays.toString(resultSplits));
        conf = TestHiveDruidQueryBasedInputFormat.createPropertiesQuery("sample_datasource", "groupBy", GROUP_BY_QUERY);
        resultSplits = (HiveDruidSplit[])method1.invoke((Object)input, conf);
        Assert.assertEquals((Object)GROUP_BY_QUERY_SPLIT, (Object)Arrays.toString(resultSplits));
    }

    private static Configuration createPropertiesQuery(String dataSource, String queryType, String jsonQuery) {
        Configuration conf = new Configuration();
        conf.set("mapreduce.input.fileinputformat.inputdir", "/my/dir");
        conf.set(HiveConf.ConfVars.HIVE_DRUID_BROKER_DEFAULT_ADDRESS.varname, "localhost:8082");
        conf.set("druid.datasource", dataSource);
        conf.set("druid.query.json", jsonQuery);
        conf.set("druid.query.type", queryType);
        return conf;
    }
}

