/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid;

import java.sql.SQLException;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorage;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.storage.derby.DerbyConnector;
import org.apache.hive.druid.org.apache.druid.metadata.storage.derby.DerbyMetadataStorage;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class DerbyConnectorTestUtility
extends DerbyConnector {
    private final String jdbcUri;

    public DerbyConnectorTestUtility(java.util.function.Supplier<MetadataStorageConnectorConfig> config, java.util.function.Supplier<MetadataStorageTablesConfig> dbTables) {
        this(config, dbTables, "jdbc:derby:memory:druidTest" + DerbyConnectorTestUtility.dbSafeUUID());
    }

    protected DerbyConnectorTestUtility(java.util.function.Supplier<MetadataStorageConnectorConfig> config, java.util.function.Supplier<MetadataStorageTablesConfig> dbTables, String jdbcUri) {
        super((MetadataStorage)new DerbyMetadataStorage(config.get()), config::get, dbTables::get, new DBI(jdbcUri + ";create=true"));
        this.jdbcUri = jdbcUri;
    }

    public void tearDown() {
        try {
            new DBI(this.jdbcUri + ";drop=true").open().close();
        }
        catch (UnableToObtainConnectionException e) {
            SQLException cause = (SQLException)e.getCause();
            Assert.assertEquals((String)String.format("Derby not shutdown: [%s]", cause.toString()), (Object)"08006", (Object)cause.getSQLState());
        }
    }

    public static String dbSafeUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getJdbcUri() {
        return this.jdbcUri;
    }

    public static class DerbyConnectorRule
    extends ExternalResource {
        private DerbyConnectorTestUtility connector;
        private final java.util.function.Supplier<MetadataStorageTablesConfig> dbTables;
        private final MetadataStorageConnectorConfig connectorConfig;

        public DerbyConnectorRule() {
            this("druidTest" + DerbyConnectorTestUtility.dbSafeUUID());
        }

        private DerbyConnectorRule(String defaultBase) {
            this(() -> ((Supplier)Suppliers.ofInstance((Object)MetadataStorageTablesConfig.fromBase((String)defaultBase))).get());
        }

        public DerbyConnectorRule(java.util.function.Supplier<MetadataStorageTablesConfig> dbTables) {
            this.dbTables = dbTables;
            this.connectorConfig = new MetadataStorageConnectorConfig(){

                public String getConnectURI() {
                    return connector.getJdbcUri();
                }
            };
        }

        protected void before() throws Throwable {
            this.connector = new DerbyConnectorTestUtility(() -> ((Supplier)Suppliers.ofInstance((Object)this.connectorConfig)).get(), this.dbTables);
            this.connector.getDBI().open().close();
        }

        protected void after() {
            this.connector.tearDown();
        }

        public DerbyConnectorTestUtility getConnector() {
            return this.connector;
        }

        public java.util.function.Supplier<MetadataStorageTablesConfig> metadataTablesConfigSupplier() {
            return this.dbTables;
        }
    }
}

