/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DateUtilsFragmentTest {
    private static final int months = 7;
    private static final int days = 23;
    private static final int hours = 19;
    private static final int minutes = 53;
    private static final int seconds = 47;
    private static final int millis = 991;
    private Date aDate;
    private Calendar aCalendar;

    @BeforeEach
    public void setUp() {
        this.aCalendar = Calendar.getInstance();
        this.aCalendar.set(2005, 7, 23, 19, 53, 47);
        this.aCalendar.set(14, 991);
        this.aDate = this.aCalendar.getTime();
    }

    @Test
    public void testDateFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)5));
    }

    @Test
    public void testDateFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)5));
    }

    @Test
    public void testDayOfYearFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)6));
    }

    @Test
    public void testDayOfYearFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)6));
    }

    @Test
    public void testDaysOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)23L, (long)testResult);
    }

    @Test
    public void testDaysOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInDays((Date)this.aDate, (int)2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)cal.get(5), (long)testResult);
    }

    @Test
    public void testDaysOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)this.aCalendar.get(6), (long)testResult);
    }

    @Test
    public void testDaysOfYearWithDate() {
        long testResult = DateUtils.getFragmentInDays((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)cal.get(6), (long)testResult);
    }

    @Test
    public void testHourOfDayFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)11));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)11));
    }

    @Test
    public void testHourOfDayFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)11));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)11));
    }

    @Test
    public void testHoursOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)5);
        long expectedValue = 19L;
        Assertions.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)19L, (long)testResult);
    }

    @Test
    public void testHoursOfDayWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)5);
        long expectedValue = 19L;
        Assertions.assertEquals((long)19L, (long)testResult);
        testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)19L, (long)testResult);
    }

    @Test
    public void testHoursOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)547L, (long)testResult);
    }

    @Test
    public void testHoursOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)547L, (long)testResult);
    }

    @Test
    public void testHoursOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(19L + (long)(this.aCalendar.get(6) - 1) * 86400000L / 3600000L), (long)testResult);
    }

    @Test
    public void testHoursOfYearWithDate() {
        long testResult = DateUtils.getFragmentInHours((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(19L + (long)(cal.get(6) - 1) * 86400000L / 3600000L), (long)testResult);
    }

    @Test
    public void testInvalidFragmentWithCalendar() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)0));
    }

    @Test
    public void testInvalidFragmentWithDate() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInSeconds((Date)this.aDate, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMinutes((Date)this.aDate, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInHours((Date)this.aDate, (int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInDays((Date)this.aDate, (int)0));
    }

    @Test
    public void testMillisecondFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)14));
    }

    @Test
    public void testMillisecondFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)14));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)14));
    }

    @Test
    public void testMillisecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627991L;
        Assertions.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    public void testMillisecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)5);
        long expectedValue = 71627991L;
        Assertions.assertEquals((long)71627991L, (long)testresult);
        testresult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)71627991L, (long)testresult);
    }

    @Test
    public void testMillisecondsOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)3227991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMinuteWithCalender() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)12);
        Assertions.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMinuteWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)12);
        Assertions.assertEquals((long)47991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)1972427991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)1972427991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfSecondWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)13);
        Assertions.assertEquals((long)991L, (long)testResult);
        Assertions.assertEquals((long)this.aCalendar.get(14), (long)testResult);
    }

    @Test
    public void testMillisecondsOfSecondWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)13);
        Assertions.assertEquals((long)991L, (long)testResult);
    }

    @Test
    public void testMillisecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMilliseconds((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(71627991L + (long)(this.aCalendar.get(6) - 1) * 86400000L), (long)testResult);
    }

    @Test
    public void testMillisecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMilliseconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(71627991L + (long)(cal.get(6) - 1) * 86400000L), (long)testResult);
    }

    @Test
    public void testMinuteFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)12));
    }

    @Test
    public void testMinuteFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)12));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)12));
    }

    @Test
    public void testMinutesOfDayWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)5);
        long expectedValue = 1193L;
        Assertions.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    public void testMinutesOfDayWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)5);
        long expectedValue = 1193L;
        Assertions.assertEquals((long)1193L, (long)testResult);
        testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)1193L, (long)testResult);
    }

    @Test
    public void testMinutesOfHourWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)53L, (long)testResult);
    }

    @Test
    public void testMinutesOfHourWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)53L, (long)testResult);
    }

    @Test
    public void testMinutesOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)32873L, (long)testResult);
    }

    @Test
    public void testMinutesOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)32873L, (long)testResult);
    }

    @Test
    public void testMinutesOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(53L + (68400000L + (long)(this.aCalendar.get(6) - 1) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    public void testMinutesOfYearWithDate() {
        long testResult = DateUtils.getFragmentInMinutes((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(53L + (68400000L + (long)(cal.get(6) - 1) * 86400000L) / 60000L), (long)testResult);
    }

    @Test
    public void testMinutesOfYearWithWrongOffsetBugWithCalendar() {
        Calendar c = Calendar.getInstance();
        c.set(2, 0);
        c.set(6, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long testResult = DateUtils.getFragmentInMinutes((Calendar)c, (int)1);
        Assertions.assertEquals((long)0L, (long)testResult);
    }

    @Test
    public void testNullCalendar() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMilliseconds((Calendar)null, (int)14));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInSeconds((Calendar)null, (int)14));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInMinutes((Calendar)null, (int)14));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInHours((Calendar)null, (int)14));
        Assertions.assertThrows(IllegalArgumentException.class, () -> DateUtils.getFragmentInDays((Calendar)null, (int)14));
    }

    @Test
    public void testNullDate() {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.getFragmentInMilliseconds((Date)null, (int)14));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.getFragmentInSeconds((Date)null, (int)14));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.getFragmentInMinutes((Date)null, (int)14));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.getFragmentInHours((Date)null, (int)14));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.getFragmentInDays((Date)null, (int)14));
    }

    @Test
    public void testSecondFragmentInLargerUnitWithCalendar() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Calendar)this.aCalendar, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Calendar)this.aCalendar, (int)13));
    }

    @Test
    public void testSecondFragmentInLargerUnitWithDate() {
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInSeconds((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInMinutes((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInHours((Date)this.aDate, (int)13));
        Assertions.assertEquals((long)0L, (long)DateUtils.getFragmentInDays((Date)this.aDate, (int)13));
    }

    @Test
    public void testSecondsOfDayWithCalendar() {
        long testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)5);
        long expectedValue = 71627L;
        Assertions.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)6);
        Assertions.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    public void testSecondsOfDayWithDate() {
        long testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)5);
        long expectedValue = 71627L;
        Assertions.assertEquals((long)71627L, (long)testresult);
        testresult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)6);
        Assertions.assertEquals((long)71627L, (long)testresult);
    }

    @Test
    public void testSecondsofHourWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)11);
        Assertions.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    public void testSecondsofHourWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)11);
        Assertions.assertEquals((long)3227L, (long)testResult);
    }

    @Test
    public void testSecondsofMinuteWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)12);
        Assertions.assertEquals((long)47L, (long)testResult);
        Assertions.assertEquals((long)this.aCalendar.get(13), (long)testResult);
    }

    @Test
    public void testSecondsofMinuteWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)12);
        Assertions.assertEquals((long)47L, (long)testResult);
    }

    @Test
    public void testSecondsOfMonthWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)2);
        Assertions.assertEquals((long)1972427L, (long)testResult);
    }

    @Test
    public void testSecondsOfMonthWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)2);
        Assertions.assertEquals((long)1972427L, (long)testResult);
    }

    @Test
    public void testSecondsOfYearWithCalendar() {
        long testResult = DateUtils.getFragmentInSeconds((Calendar)this.aCalendar, (int)1);
        Assertions.assertEquals((long)(47L + (71580000L + (long)(this.aCalendar.get(6) - 1) * 86400000L) / 1000L), (long)testResult);
    }

    @Test
    public void testSecondsOfYearWithDate() {
        long testResult = DateUtils.getFragmentInSeconds((Date)this.aDate, (int)1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.aDate);
        Assertions.assertEquals((long)(47L + (71580000L + (long)(cal.get(6) - 1) * 86400000L) / 1000L), (long)testResult);
    }
}

