/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.function;

import java.util.function.Supplier;
import org.apache.commons.lang3.function.FailableSupplier;
import org.apache.commons.lang3.function.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ObjectsTest {
    ObjectsTest() {
    }

    @Test
    void testRequireNonNullObject() {
        Assertions.assertSame((Object)"foo", (Object)Objects.requireNonNull("foo"));
        try {
            Objects.requireNonNull(null);
            Assertions.fail((String)"Expected Exception");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"The value must not be null.", (Object)e.getMessage());
        }
    }

    @Test
    void testRequireNonNullObjectString() {
        Assertions.assertSame((Object)"foo", (Object)Objects.requireNonNull("foo", "bar"));
        try {
            Objects.requireNonNull(null, "bar");
            Assertions.fail((String)"Expected Exception");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"bar", (Object)e.getMessage());
        }
    }

    @Test
    void testRequireNonNullObjectSupplierString() {
        TestableSupplier<String> supplier = new TestableSupplier<String>(() -> "bar");
        Assertions.assertSame((Object)"foo", (Object)Objects.requireNonNull("foo", supplier));
        Assertions.assertFalse((boolean)supplier.isInvoked());
        try {
            Objects.requireNonNull(null, supplier);
            Assertions.fail((String)"Expected Exception");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"bar", (Object)e.getMessage());
            Assertions.assertTrue((boolean)supplier.isInvoked());
        }
    }

    @Test
    void testRequireNonNullObjectFailableSupplierString() {
        TestableFailableSupplier supplier = new TestableFailableSupplier(() -> null);
        Assertions.assertSame((Object)"foo", (Object)Objects.requireNonNull("foo", supplier));
        Assertions.assertFalse((boolean)supplier.isInvoked());
        try {
            Objects.requireNonNull(null, supplier);
            Assertions.fail((String)"Expected Exception");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"The supplier must not return null.", (Object)e.getMessage());
            Assertions.assertTrue((boolean)supplier.isInvoked());
        }
        TestableFailableSupplier supplier2 = new TestableFailableSupplier(() -> null);
        try {
            Objects.requireNonNull(null, supplier2);
            Assertions.fail((String)"Expected Exception");
        }
        catch (NullPointerException e) {
            Assertions.assertEquals((Object)"The supplier must not return null.", (Object)e.getMessage());
            Assertions.assertTrue((boolean)supplier2.isInvoked());
        }
        TestableFailableSupplier supplier3 = new TestableFailableSupplier(() -> "bar");
        Assertions.assertSame((Object)"bar", Objects.requireNonNull(null, supplier3));
        RuntimeException rte = new RuntimeException();
        TestableFailableSupplier supplier4 = new TestableFailableSupplier(() -> {
            throw rte;
        });
        try {
            Objects.requireNonNull(null, supplier4);
            Assertions.fail((String)"Expected Exception");
        }
        catch (RuntimeException e) {
            Assertions.assertSame((Object)rte, (Object)e);
            Assertions.assertTrue((boolean)supplier4.isInvoked());
        }
    }

    public static class TestableFailableSupplier<O, E extends Exception>
    implements FailableSupplier<O, E> {
        private final FailableSupplier<O, E> supplier;
        private boolean invoked;

        TestableFailableSupplier(FailableSupplier<O, E> pSupplier) {
            this.supplier = pSupplier;
        }

        public O get() throws E {
            this.invoked = true;
            return (O)this.supplier.get();
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }

    public static class TestableSupplier<O>
    implements Supplier<O> {
        private final Supplier<O> supplier;
        private boolean invoked;

        TestableSupplier(Supplier<O> pSupplier) {
            this.supplier = pSupplier;
        }

        @Override
        public O get() {
            this.invoked = true;
            return this.supplier.get();
        }

        public boolean isInvoked() {
            return this.invoked;
        }
    }
}

