/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.CharRange;
import org.apache.commons.lang3.SerializationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CharRangeTest {
    @Test
    public void testClass() {
        Assertions.assertFalse((boolean)Modifier.isPublic(CharRange.class.getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isFinal(CharRange.class.getModifiers()));
    }

    @Test
    public void testConstructorAccessors_is() {
        CharRange rangea = CharRange.is((char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'a', (char)rangea.getEnd());
        Assertions.assertFalse((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNot() {
        CharRange rangea = CharRange.isNot((char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'a', (char)rangea.getEnd());
        Assertions.assertTrue((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"^a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Same() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'a', (char)rangea.getEnd());
        Assertions.assertFalse((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Normal() {
        CharRange rangea = CharRange.isIn((char)'a', (char)'e');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'e', (char)rangea.getEnd());
        Assertions.assertFalse((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isIn_Reversed() {
        CharRange rangea = CharRange.isIn((char)'e', (char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'e', (char)rangea.getEnd());
        Assertions.assertFalse((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Same() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'a', (char)rangea.getEnd());
        Assertions.assertTrue((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"^a", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Normal() {
        CharRange rangea = CharRange.isNotIn((char)'a', (char)'e');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'e', (char)rangea.getEnd());
        Assertions.assertTrue((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"^a-e", (Object)rangea.toString());
    }

    @Test
    public void testConstructorAccessors_isNotIn_Reversed() {
        CharRange rangea = CharRange.isNotIn((char)'e', (char)'a');
        Assertions.assertEquals((char)'a', (char)rangea.getStart());
        Assertions.assertEquals((char)'e', (char)rangea.getEnd());
        Assertions.assertTrue((boolean)rangea.isNegated());
        Assertions.assertEquals((Object)"^a-e", (Object)rangea.toString());
    }

    @Test
    public void testEquals_Object() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        Assertions.assertNotEquals(null, (Object)rangea);
        Assertions.assertEquals((Object)rangea, (Object)rangea);
        Assertions.assertEquals((Object)rangea, (Object)CharRange.is((char)'a'));
        Assertions.assertEquals((Object)rangeae, (Object)rangeae);
        Assertions.assertEquals((Object)rangeae, (Object)CharRange.isIn((char)'a', (char)'e'));
        Assertions.assertEquals((Object)rangenotbf, (Object)rangenotbf);
        Assertions.assertEquals((Object)rangenotbf, (Object)CharRange.isIn((char)'b', (char)'f'));
        Assertions.assertNotEquals((Object)rangea, (Object)rangeae);
        Assertions.assertNotEquals((Object)rangea, (Object)rangenotbf);
        Assertions.assertNotEquals((Object)rangeae, (Object)rangea);
        Assertions.assertNotEquals((Object)rangeae, (Object)rangenotbf);
        Assertions.assertNotEquals((Object)rangenotbf, (Object)rangea);
        Assertions.assertNotEquals((Object)rangenotbf, (Object)rangeae);
    }

    @Test
    public void testHashCode() {
        CharRange rangea = CharRange.is((char)'a');
        CharRange rangeae = CharRange.isIn((char)'a', (char)'e');
        CharRange rangenotbf = CharRange.isIn((char)'b', (char)'f');
        Assertions.assertEquals((int)rangea.hashCode(), (int)rangea.hashCode());
        Assertions.assertEquals((int)rangea.hashCode(), (int)CharRange.is((char)'a').hashCode());
        Assertions.assertEquals((int)rangeae.hashCode(), (int)rangeae.hashCode());
        Assertions.assertEquals((int)rangeae.hashCode(), (int)CharRange.isIn((char)'a', (char)'e').hashCode());
        Assertions.assertEquals((int)rangenotbf.hashCode(), (int)rangenotbf.hashCode());
        Assertions.assertEquals((int)rangenotbf.hashCode(), (int)CharRange.isIn((char)'b', (char)'f').hashCode());
        Assertions.assertNotEquals((int)rangea.hashCode(), (int)rangeae.hashCode());
        Assertions.assertNotEquals((int)rangea.hashCode(), (int)rangenotbf.hashCode());
        Assertions.assertNotEquals((int)rangeae.hashCode(), (int)rangea.hashCode());
        Assertions.assertNotEquals((int)rangeae.hashCode(), (int)rangenotbf.hashCode());
        Assertions.assertNotEquals((int)rangenotbf.hashCode(), (int)rangea.hashCode());
        Assertions.assertNotEquals((int)rangenotbf.hashCode(), (int)rangeae.hashCode());
    }

    @Test
    public void testContains_Char() {
        CharRange range = CharRange.is((char)'c');
        Assertions.assertFalse((boolean)range.contains('b'));
        Assertions.assertTrue((boolean)range.contains('c'));
        Assertions.assertFalse((boolean)range.contains('d'));
        Assertions.assertFalse((boolean)range.contains('e'));
        range = CharRange.isIn((char)'c', (char)'d');
        Assertions.assertFalse((boolean)range.contains('b'));
        Assertions.assertTrue((boolean)range.contains('c'));
        Assertions.assertTrue((boolean)range.contains('d'));
        Assertions.assertFalse((boolean)range.contains('e'));
        range = CharRange.isIn((char)'d', (char)'c');
        Assertions.assertFalse((boolean)range.contains('b'));
        Assertions.assertTrue((boolean)range.contains('c'));
        Assertions.assertTrue((boolean)range.contains('d'));
        Assertions.assertFalse((boolean)range.contains('e'));
        range = CharRange.isNotIn((char)'c', (char)'d');
        Assertions.assertTrue((boolean)range.contains('b'));
        Assertions.assertFalse((boolean)range.contains('c'));
        Assertions.assertFalse((boolean)range.contains('d'));
        Assertions.assertTrue((boolean)range.contains('e'));
        Assertions.assertTrue((boolean)range.contains('\u0000'));
        Assertions.assertTrue((boolean)range.contains('\uffff'));
    }

    @Test
    public void testContains_Charrange() {
        CharRange a = CharRange.is((char)'a');
        CharRange b = CharRange.is((char)'b');
        CharRange c = CharRange.is((char)'c');
        CharRange c2 = CharRange.is((char)'c');
        CharRange d = CharRange.is((char)'d');
        CharRange e = CharRange.is((char)'e');
        CharRange cd = CharRange.isIn((char)'c', (char)'d');
        CharRange bd = CharRange.isIn((char)'b', (char)'d');
        CharRange bc = CharRange.isIn((char)'b', (char)'c');
        CharRange ab = CharRange.isIn((char)'a', (char)'b');
        CharRange de = CharRange.isIn((char)'d', (char)'e');
        CharRange ef = CharRange.isIn((char)'e', (char)'f');
        CharRange ae = CharRange.isIn((char)'a', (char)'e');
        Assertions.assertFalse((boolean)c.contains(b));
        Assertions.assertTrue((boolean)c.contains(c));
        Assertions.assertTrue((boolean)c.contains(c2));
        Assertions.assertFalse((boolean)c.contains(d));
        Assertions.assertFalse((boolean)c.contains(cd));
        Assertions.assertFalse((boolean)c.contains(bd));
        Assertions.assertFalse((boolean)c.contains(bc));
        Assertions.assertFalse((boolean)c.contains(ab));
        Assertions.assertFalse((boolean)c.contains(de));
        Assertions.assertTrue((boolean)cd.contains(c));
        Assertions.assertTrue((boolean)bd.contains(c));
        Assertions.assertTrue((boolean)bc.contains(c));
        Assertions.assertFalse((boolean)ab.contains(c));
        Assertions.assertFalse((boolean)de.contains(c));
        Assertions.assertTrue((boolean)ae.contains(b));
        Assertions.assertTrue((boolean)ae.contains(ab));
        Assertions.assertTrue((boolean)ae.contains(bc));
        Assertions.assertTrue((boolean)ae.contains(cd));
        Assertions.assertTrue((boolean)ae.contains(de));
        CharRange notb = CharRange.isNot((char)'b');
        CharRange notc = CharRange.isNot((char)'c');
        CharRange notd = CharRange.isNot((char)'d');
        CharRange notab = CharRange.isNotIn((char)'a', (char)'b');
        CharRange notbc = CharRange.isNotIn((char)'b', (char)'c');
        CharRange notbd = CharRange.isNotIn((char)'b', (char)'d');
        CharRange notcd = CharRange.isNotIn((char)'c', (char)'d');
        CharRange notde = CharRange.isNotIn((char)'d', (char)'e');
        CharRange notae = CharRange.isNotIn((char)'a', (char)'e');
        CharRange all = CharRange.isIn((char)'\u0000', (char)'\uffff');
        CharRange allbutfirst = CharRange.isIn((char)'\u0001', (char)'\uffff');
        Assertions.assertFalse((boolean)c.contains(notc));
        Assertions.assertFalse((boolean)c.contains(notbd));
        Assertions.assertTrue((boolean)all.contains(notc));
        Assertions.assertTrue((boolean)all.contains(notbd));
        Assertions.assertFalse((boolean)allbutfirst.contains(notc));
        Assertions.assertFalse((boolean)allbutfirst.contains(notbd));
        Assertions.assertTrue((boolean)notc.contains(a));
        Assertions.assertTrue((boolean)notc.contains(b));
        Assertions.assertFalse((boolean)notc.contains(c));
        Assertions.assertTrue((boolean)notc.contains(d));
        Assertions.assertTrue((boolean)notc.contains(e));
        Assertions.assertTrue((boolean)notc.contains(ab));
        Assertions.assertFalse((boolean)notc.contains(bc));
        Assertions.assertFalse((boolean)notc.contains(bd));
        Assertions.assertFalse((boolean)notc.contains(cd));
        Assertions.assertTrue((boolean)notc.contains(de));
        Assertions.assertFalse((boolean)notc.contains(ae));
        Assertions.assertFalse((boolean)notc.contains(all));
        Assertions.assertFalse((boolean)notc.contains(allbutfirst));
        Assertions.assertTrue((boolean)notbd.contains(a));
        Assertions.assertFalse((boolean)notbd.contains(b));
        Assertions.assertFalse((boolean)notbd.contains(c));
        Assertions.assertFalse((boolean)notbd.contains(d));
        Assertions.assertTrue((boolean)notbd.contains(e));
        Assertions.assertTrue((boolean)notcd.contains(ab));
        Assertions.assertFalse((boolean)notcd.contains(bc));
        Assertions.assertFalse((boolean)notcd.contains(bd));
        Assertions.assertFalse((boolean)notcd.contains(cd));
        Assertions.assertFalse((boolean)notcd.contains(de));
        Assertions.assertFalse((boolean)notcd.contains(ae));
        Assertions.assertTrue((boolean)notcd.contains(ef));
        Assertions.assertFalse((boolean)notcd.contains(all));
        Assertions.assertFalse((boolean)notcd.contains(allbutfirst));
        Assertions.assertFalse((boolean)notc.contains(notb));
        Assertions.assertTrue((boolean)notc.contains(notc));
        Assertions.assertFalse((boolean)notc.contains(notd));
        Assertions.assertFalse((boolean)notc.contains(notab));
        Assertions.assertTrue((boolean)notc.contains(notbc));
        Assertions.assertTrue((boolean)notc.contains(notbd));
        Assertions.assertTrue((boolean)notc.contains(notcd));
        Assertions.assertFalse((boolean)notc.contains(notde));
        Assertions.assertFalse((boolean)notbd.contains(notb));
        Assertions.assertFalse((boolean)notbd.contains(notc));
        Assertions.assertFalse((boolean)notbd.contains(notd));
        Assertions.assertFalse((boolean)notbd.contains(notab));
        Assertions.assertFalse((boolean)notbd.contains(notbc));
        Assertions.assertTrue((boolean)notbd.contains(notbd));
        Assertions.assertFalse((boolean)notbd.contains(notcd));
        Assertions.assertFalse((boolean)notbd.contains(notde));
        Assertions.assertTrue((boolean)notbd.contains(notae));
    }

    @Test
    public void testContainsNullArg() {
        CharRange range = CharRange.is((char)'a');
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> range.contains(null));
        Assertions.assertEquals((Object)"range", (Object)e.getMessage());
    }

    @Test
    public void testIterator() {
        CharRange a = CharRange.is((char)'a');
        CharRange ad = CharRange.isIn((char)'a', (char)'d');
        CharRange nota = CharRange.isNot((char)'a');
        CharRange emptySet = CharRange.isNotIn((char)'\u0000', (char)'\uffff');
        CharRange notFirst = CharRange.isNotIn((char)'\u0001', (char)'\uffff');
        CharRange notLast = CharRange.isNotIn((char)'\u0000', (char)'\ufffe');
        Iterator aIt = a.iterator();
        Assertions.assertNotNull((Object)aIt);
        Assertions.assertTrue((boolean)aIt.hasNext());
        Assertions.assertEquals((Character)Character.valueOf('a'), (Character)((Character)aIt.next()));
        Assertions.assertFalse((boolean)aIt.hasNext());
        Iterator adIt = ad.iterator();
        Assertions.assertNotNull((Object)adIt);
        Assertions.assertTrue((boolean)adIt.hasNext());
        Assertions.assertEquals((Character)Character.valueOf('a'), (Character)((Character)adIt.next()));
        Assertions.assertEquals((Character)Character.valueOf('b'), (Character)((Character)adIt.next()));
        Assertions.assertEquals((Character)Character.valueOf('c'), (Character)((Character)adIt.next()));
        Assertions.assertEquals((Character)Character.valueOf('d'), (Character)((Character)adIt.next()));
        Assertions.assertFalse((boolean)adIt.hasNext());
        Iterator notaIt = nota.iterator();
        Assertions.assertNotNull((Object)notaIt);
        Assertions.assertTrue((boolean)notaIt.hasNext());
        while (notaIt.hasNext()) {
            Character c = (Character)notaIt.next();
            Assertions.assertNotEquals((char)'a', (char)c.charValue());
        }
        Iterator emptySetIt = emptySet.iterator();
        Assertions.assertNotNull((Object)emptySetIt);
        Assertions.assertFalse((boolean)emptySetIt.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, emptySetIt::next);
        Iterator notFirstIt = notFirst.iterator();
        Assertions.assertNotNull((Object)notFirstIt);
        Assertions.assertTrue((boolean)notFirstIt.hasNext());
        Assertions.assertEquals((Character)Character.valueOf('\u0000'), (Character)((Character)notFirstIt.next()));
        Assertions.assertFalse((boolean)notFirstIt.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, notFirstIt::next);
        Iterator notLastIt = notLast.iterator();
        Assertions.assertNotNull((Object)notLastIt);
        Assertions.assertTrue((boolean)notLastIt.hasNext());
        Assertions.assertEquals((Character)Character.valueOf('\uffff'), (Character)((Character)notLastIt.next()));
        Assertions.assertFalse((boolean)notLastIt.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, notLastIt::next);
    }

    @Test
    public void testSerialization() {
        CharRange range = CharRange.is((char)'a');
        Assertions.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isIn((char)'a', (char)'e');
        Assertions.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
        range = CharRange.isNotIn((char)'a', (char)'e');
        Assertions.assertEquals((Object)range, (Object)SerializationUtils.clone((Serializable)range));
    }

    @Test
    public void testIteratorRemove() {
        CharRange a = CharRange.is((char)'a');
        Iterator aIt = a.iterator();
        Assertions.assertThrows(UnsupportedOperationException.class, aIt::remove);
    }
}

