/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayUtilsRemoveTest {
    @Test
    public void testRemoveAllBooleanOccurences() {
        boolean[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (boolean)true));
        a = new boolean[]{};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true));
        a = new boolean[]{true};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true));
        a = new boolean[]{true, true};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true));
        a = new boolean[]{false, true, true, false, true};
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false}, (boolean[])ArrayUtils.removeAllOccurences((boolean[])a, (boolean)true));
        a = new boolean[]{false, true, true, false, true};
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true}, (boolean[])ArrayUtils.removeAllOccurences((boolean[])a, (boolean)false));
    }

    @Test
    public void testRemoveAllBooleanOccurrences() {
        boolean[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (boolean)true));
        a = new boolean[]{};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurrences((boolean[])a, (boolean)true));
        a = new boolean[]{true};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurrences((boolean[])a, (boolean)true));
        a = new boolean[]{true, true};
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])ArrayUtils.removeAllOccurrences((boolean[])a, (boolean)true));
        a = new boolean[]{false, true, true, false, true};
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false}, (boolean[])ArrayUtils.removeAllOccurrences((boolean[])a, (boolean)true));
        a = new boolean[]{false, true, true, false, true};
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true}, (boolean[])ArrayUtils.removeAllOccurrences((boolean[])a, (boolean)false));
    }

    @Test
    public void testRemoveAllByteOccurences() {
        byte[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (byte)2));
        a = new byte[]{};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurences((byte[])a, (byte)2));
        a = new byte[]{2};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurences((byte[])a, (byte)2));
        a = new byte[]{2, 2};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurences((byte[])a, (byte)2));
        a = new byte[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3}, (byte[])ArrayUtils.removeAllOccurences((byte[])a, (byte)2));
        a = new byte[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 2, 3, 2}, (byte[])ArrayUtils.removeAllOccurences((byte[])a, (byte)4));
    }

    @Test
    public void testRemoveAllByteOccurrences() {
        byte[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (byte)2));
        a = new byte[]{};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurrences((byte[])a, (byte)2));
        a = new byte[]{2};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurrences((byte[])a, (byte)2));
        a = new byte[]{2, 2};
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])ArrayUtils.removeAllOccurrences((byte[])a, (byte)2));
        a = new byte[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3}, (byte[])ArrayUtils.removeAllOccurrences((byte[])a, (byte)2));
        a = new byte[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2, 2, 3, 2}, (byte[])ArrayUtils.removeAllOccurrences((byte[])a, (byte)4));
    }

    @Test
    public void testRemoveAllCharOccurences() {
        char[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (char)'2'));
        a = new char[]{};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurences((char[])a, (char)'2'));
        a = new char[]{'2'};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurences((char[])a, (char)'2'));
        a = new char[]{'2', '2'};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurences((char[])a, (char)'2'));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assertions.assertArrayEquals((char[])new char[]{'1', '3'}, (char[])ArrayUtils.removeAllOccurences((char[])a, (char)'2'));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assertions.assertArrayEquals((char[])new char[]{'1', '2', '2', '3', '2'}, (char[])ArrayUtils.removeAllOccurences((char[])a, (char)'4'));
    }

    @Test
    public void testRemoveAllCharOccurrences() {
        char[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (char)'2'));
        a = new char[]{};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurrences((char[])a, (char)'2'));
        a = new char[]{'2'};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurrences((char[])a, (char)'2'));
        a = new char[]{'2', '2'};
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])ArrayUtils.removeAllOccurrences((char[])a, (char)'2'));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assertions.assertArrayEquals((char[])new char[]{'1', '3'}, (char[])ArrayUtils.removeAllOccurrences((char[])a, (char)'2'));
        a = new char[]{'1', '2', '2', '3', '2'};
        Assertions.assertArrayEquals((char[])new char[]{'1', '2', '2', '3', '2'}, (char[])ArrayUtils.removeAllOccurrences((char[])a, (char)'4'));
    }

    @Test
    public void testRemoveAllDoubleOccurences() {
        double[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (double)2.0));
        a = new double[]{};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurences((double[])a, (double)2.0));
        a = new double[]{2.0};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurences((double[])a, (double)2.0));
        a = new double[]{2.0, 2.0};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurences((double[])a, (double)2.0));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0}, (double[])ArrayUtils.removeAllOccurences((double[])a, (double)2.0));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 2.0, 3.0, 2.0}, (double[])ArrayUtils.removeAllOccurences((double[])a, (double)4.0));
    }

    @Test
    public void testRemoveAllDoubleOccurrences() {
        double[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (double)2.0));
        a = new double[]{};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurrences((double[])a, (double)2.0));
        a = new double[]{2.0};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurrences((double[])a, (double)2.0));
        a = new double[]{2.0, 2.0};
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])ArrayUtils.removeAllOccurrences((double[])a, (double)2.0));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0}, (double[])ArrayUtils.removeAllOccurrences((double[])a, (double)2.0));
        a = new double[]{1.0, 2.0, 2.0, 3.0, 2.0};
        Assertions.assertArrayEquals((double[])new double[]{1.0, 2.0, 2.0, 3.0, 2.0}, (double[])ArrayUtils.removeAllOccurrences((double[])a, (double)4.0));
    }

    @Test
    public void testRemoveAllFloatOccurences() {
        float[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (float)2.0f));
        a = new float[]{};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurences((float[])a, (float)2.0f));
        a = new float[]{2.0f};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurences((float[])a, (float)2.0f));
        a = new float[]{2.0f, 2.0f};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurences((float[])a, (float)2.0f));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f}, (float[])ArrayUtils.removeAllOccurences((float[])a, (float)2.0f));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f}, (float[])ArrayUtils.removeAllOccurences((float[])a, (float)4.0f));
    }

    @Test
    public void testRemoveAllFloatOccurrences() {
        float[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (float)2.0f));
        a = new float[]{};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurrences((float[])a, (float)2.0f));
        a = new float[]{2.0f};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurrences((float[])a, (float)2.0f));
        a = new float[]{2.0f, 2.0f};
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])ArrayUtils.removeAllOccurrences((float[])a, (float)2.0f));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f}, (float[])ArrayUtils.removeAllOccurrences((float[])a, (float)2.0f));
        a = new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f};
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 2.0f, 2.0f, 3.0f, 2.0f}, (float[])ArrayUtils.removeAllOccurrences((float[])a, (float)4.0f));
    }

    @Test
    public void testRemoveAllIntOccurences() {
        int[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (int)2));
        a = new int[]{};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurences((int[])a, (int)2));
        a = new int[]{2};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurences((int[])a, (int)2));
        a = new int[]{2, 2};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurences((int[])a, (int)2));
        a = new int[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((int[])new int[]{1, 3}, (int[])ArrayUtils.removeAllOccurences((int[])a, (int)2));
        a = new int[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 2, 3, 2}, (int[])ArrayUtils.removeAllOccurences((int[])a, (int)4));
    }

    @Test
    public void testRemoveAllIntOccurrences() {
        int[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (int)2));
        a = new int[]{};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurrences((int[])a, (int)2));
        a = new int[]{2};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurrences((int[])a, (int)2));
        a = new int[]{2, 2};
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.removeAllOccurrences((int[])a, (int)2));
        a = new int[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((int[])new int[]{1, 3}, (int[])ArrayUtils.removeAllOccurrences((int[])a, (int)2));
        a = new int[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((int[])new int[]{1, 2, 2, 3, 2}, (int[])ArrayUtils.removeAllOccurrences((int[])a, (int)4));
    }

    @Test
    public void testRemoveAllLongOccurences() {
        long[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (long)2L));
        a = new long[]{};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurences((long[])a, (long)2L));
        a = new long[]{2L};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurences((long[])a, (long)2L));
        a = new long[]{2L, 2L};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurences((long[])a, (long)2L));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L}, (long[])ArrayUtils.removeAllOccurences((long[])a, (long)2L));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 2L, 3L, 2L}, (long[])ArrayUtils.removeAllOccurences((long[])a, (long)4L));
    }

    @Test
    public void testRemoveAllLongOccurrences() {
        long[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (long)2L));
        a = new long[]{};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurrences((long[])a, (long)2L));
        a = new long[]{2L};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurrences((long[])a, (long)2L));
        a = new long[]{2L, 2L};
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])ArrayUtils.removeAllOccurrences((long[])a, (long)2L));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L}, (long[])ArrayUtils.removeAllOccurrences((long[])a, (long)2L));
        a = new long[]{1L, 2L, 2L, 3L, 2L};
        Assertions.assertArrayEquals((long[])new long[]{1L, 2L, 2L, 3L, 2L}, (long[])ArrayUtils.removeAllOccurrences((long[])a, (long)4L));
    }

    @Test
    public void testRemoveAllObjectOccurences() {
        Object[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (Object)"2"));
        a = new String[]{};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurences((Object[])a, (Object)"2"));
        a = new String[]{"2"};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurences((Object[])a, (Object)"2"));
        a = new String[]{"2", "2"};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurences((Object[])a, (Object)"2"));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "3"}, (Object[])ArrayUtils.removeAllOccurences((Object[])a, (Object)"2"));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "2", "3", "2"}, (Object[])ArrayUtils.removeAllOccurences((Object[])a, (Object)"4"));
    }

    @Test
    public void testRemoveAllObjectOccurrences() {
        Object[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (Object)"2"));
        a = new String[]{};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurrences((Object[])a, (Object)"2"));
        a = new String[]{"2"};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurrences((Object[])a, (Object)"2"));
        a = new String[]{"2", "2"};
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_STRING_ARRAY, (Object[])ArrayUtils.removeAllOccurrences((Object[])a, (Object)"2"));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "3"}, (Object[])ArrayUtils.removeAllOccurrences((Object[])a, (Object)"2"));
        a = new String[]{"1", "2", "2", "3", "2"};
        Assertions.assertArrayEquals((Object[])new String[]{"1", "2", "2", "3", "2"}, (Object[])ArrayUtils.removeAllOccurrences((Object[])a, (Object)"4"));
    }

    @Test
    public void testRemoveAllShortOccurences() {
        short[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurences(a, (short)2));
        a = new short[]{};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurences((short[])a, (short)2));
        a = new short[]{2};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurences((short[])a, (short)2));
        a = new short[]{2, 2};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurences((short[])a, (short)2));
        a = new short[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((short[])new short[]{1, 3}, (short[])ArrayUtils.removeAllOccurences((short[])a, (short)2));
        a = new short[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 2, 3, 2}, (short[])ArrayUtils.removeAllOccurences((short[])a, (short)4));
    }

    @Test
    public void testRemoveAllShortOccurrences() {
        short[] a = null;
        Assertions.assertNull((Object)ArrayUtils.removeAllOccurrences(a, (short)2));
        a = new short[]{};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurrences((short[])a, (short)2));
        a = new short[]{2};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurrences((short[])a, (short)2));
        a = new short[]{2, 2};
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])ArrayUtils.removeAllOccurrences((short[])a, (short)2));
        a = new short[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((short[])new short[]{1, 3}, (short[])ArrayUtils.removeAllOccurrences((short[])a, (short)2));
        a = new short[]{1, 2, 2, 3, 2};
        Assertions.assertArrayEquals((short[])new short[]{1, 2, 2, 3, 2}, (short[])ArrayUtils.removeAllOccurrences((short[])a, (short)4));
    }

    @Test
    public void testRemoveBooleanArray() {
        boolean[] array = ArrayUtils.remove((boolean[])new boolean[]{true}, (int)0);
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)0);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)1);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((boolean[])new boolean[]{true, false, true}, (int)1);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((boolean[])new boolean[]{true, false}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((boolean[])null, (int)0));
    }

    @Test
    public void testRemoveByteArray() {
        byte[] array = ArrayUtils.remove((byte[])new byte[]{1}, (int)0);
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)0);
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)1);
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((byte[])new byte[]{1, 2, 1}, (int)1);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((byte[])new byte[]{1, 2}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((byte[])null, (int)0));
    }

    @Test
    public void testRemoveCharArray() {
        char[] array = ArrayUtils.remove((char[])new char[]{'a'}, (int)0);
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)0);
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)1);
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((char[])new char[]{'a', 'b', 'c'}, (int)1);
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((char[])new char[]{'a', 'b'}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((char[])null, (int)0));
    }

    @Test
    public void testRemoveDoubleArray() {
        double[] array = ArrayUtils.remove((double[])new double[]{1.0}, (int)0);
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)0);
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)1);
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((double[])new double[]{1.0, 2.0, 1.0}, (int)1);
        Assertions.assertArrayEquals((double[])new double[]{1.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((double[])new double[]{1.0, 2.0}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((double[])null, (int)0));
    }

    @Test
    public void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElement(null, (boolean)true);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean)true);
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true}, (boolean)true);
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false}, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((boolean[])new boolean[]{true, false, true}, (boolean)true);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElement((byte[])null, (byte)1);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte)1);
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1}, (byte)1);
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2}, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((byte[])new byte[]{1, 2, 1}, (byte)1);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElement((char[])null, (char)'a');
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char)'a');
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a'}, (char)'a');
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b'}, (char)'a');
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((char[])new char[]{'a', 'b', 'a'}, (char)'a');
        Assertions.assertArrayEquals((char[])new char[]{'b', 'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElement(null, (double)1.0);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double)1.0);
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0}, (double)1.0);
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0}, (double)1.0);
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((double[])new double[]{1.0, 2.0, 1.0}, (double)1.0);
        Assertions.assertArrayEquals((double[])new double[]{2.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElement((float[])null, (float)1.0f);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float)1.0f);
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f}, (float)1.0f);
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f}, (float)1.0f);
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((float[])new float[]{1.0f, 2.0f, 1.0f}, (float)1.0f);
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElement((int[])null, (int)1);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((int[])ArrayUtils.EMPTY_INT_ARRAY, (int)1);
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1}, (int)1);
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2}, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((int[])new int[]{1, 2, 1}, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{2, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElement((long[])null, (long)1L);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long)1L);
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L}, (long)1L);
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L}, (long)1L);
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((long[])new long[]{1L, 2L, 1L}, (long)1L);
        Assertions.assertArrayEquals((long[])new long[]{2L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementObjectArray() {
        Object[] array = ArrayUtils.removeElement(null, (Object)"a");
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object)"a");
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a"}, (Object)"a");
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b"}, (Object)"a");
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((Object[])new Object[]{"a", "b", "a"}, (Object)"a");
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElement((short[])null, (short)1);
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElement((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short)1);
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1}, (short)1);
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2}, (short)1);
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElement((short[])new short[]{1, 2, 1}, (short)1);
        Assertions.assertArrayEquals((short[])new short[]{2, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveFloatArray() {
        float[] array = ArrayUtils.remove((float[])new float[]{1.0f}, (int)0);
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)0);
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)1);
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((float[])new float[]{1.0f, 2.0f, 1.0f}, (int)1);
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((float[])new float[]{1.0f, 2.0f}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((float[])null, (int)0));
    }

    @Test
    public void testRemoveIntArray() {
        int[] array = ArrayUtils.remove((int[])new int[]{1}, (int)0);
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)0);
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2}, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((int[])new int[]{1, 2, 1}, (int)1);
        Assertions.assertArrayEquals((int[])new int[]{1, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((int[])new int[]{1, 2}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((int[])new int[]{1, 2}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((int[])null, (int)0));
    }

    @Test
    public void testRemoveLongArray() {
        long[] array = ArrayUtils.remove((long[])new long[]{1L}, (int)0);
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)0);
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)1);
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((long[])new long[]{1L, 2L, 1L}, (int)1);
        Assertions.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((long[])new long[]{1L, 2L}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((long[])null, (int)0));
    }

    @Test
    public void testRemoveNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        Assertions.assertEquals((int)3, (int)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.remove((Object[])inarray, (int)1);
        Assertions.assertEquals((int)2, (int)outarray.length);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)1);
        Assertions.assertEquals((int)1, (int)outarray.length);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.remove((Object[])outarray, (int)0);
        Assertions.assertEquals((int)0, (int)outarray.length);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    @Test
    public void testRemoveObjectArray() {
        Object[] array = ArrayUtils.remove((Object[])new Object[]{"a"}, (int)0);
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)0);
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)1);
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.remove((Object[])new Object[]{"a", "b", "c"}, (int)1);
        Assertions.assertArrayEquals((Object[])new Object[]{"a", "c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((Object[])new Object[]{"a", "b"}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((Object[])null, (int)0));
    }

    @Test
    public void testRemoveShortArray() {
        short[] array = ArrayUtils.remove((short[])new short[]{1}, (int)0);
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)0);
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2}, (int)1);
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.remove((short[])new short[]{1, 2, 1}, (int)1);
        Assertions.assertArrayEquals((short[])new short[]{1, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((short[])new short[]{1, 2}, (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((short[])new short[]{1, 2}, (int)2));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((short[])null, (int)0));
    }
}

