/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayUtilsRemoveMultipleTest {
    @Test
    public void testRemoveAllBooleanArray() {
        boolean[] array = ArrayUtils.removeAll((boolean[])new boolean[]{true}, (int[])new int[]{0});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true}, (int[])new int[]{1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, false}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true}, (int[])new int[]{1, 3, 4});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, true, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((boolean[])new boolean[]{true, false, true, false, true, false, true}, (int[])new int[]{0, 1, 2});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, false, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllBooleanArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllBooleanArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((boolean[])new boolean[]{true, false}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllBooleanArrayRemoveNone() {
        boolean[] array1 = new boolean[]{true, false};
        boolean[] array2 = ArrayUtils.removeAll((boolean[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((boolean[])array1, (boolean[])array2);
        Assertions.assertEquals(Boolean.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllByteArray() {
        byte[] array = ArrayUtils.removeAll((byte[])new byte[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{3}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3, 5}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 4}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((byte[])new byte[]{1, 3, 5, 7}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 4, 6}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllByteArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllByteArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((byte[])new byte[]{1, 2}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllByteArrayRemoveNone() {
        byte[] array1 = new byte[]{1, 2};
        byte[] array2 = ArrayUtils.removeAll((byte[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((byte[])array1, (byte[])array2);
        Assertions.assertEquals(Byte.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllCharArray() {
        char[] array = ArrayUtils.removeAll((char[])new char[]{'a'}, (int[])new int[]{0});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{1});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((char[])new char[]{'c'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c'}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c', 'e'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e'}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'd'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((char[])new char[]{'a', 'c', 'e', 'g'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((char[])new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g'}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'd', 'f'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllCharArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllCharArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((char[])new char[]{'a', 'b'}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllCharArrayRemoveNone() {
        char[] array1 = new char[]{'a', 'b'};
        char[] array2 = ArrayUtils.removeAll((char[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((char[])array1, (char[])array2);
        Assertions.assertEquals(Character.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllDoubleArray() {
        double[] array = ArrayUtils.removeAll((double[])new double[]{1.0}, (int[])new int[]{0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{1});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 1.0}, (int[])new int[]{1});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((double[])new double[]{3.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0, 5.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 4.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((double[])new double[]{1.0, 3.0, 5.0, 7.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((double[])new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 4.0, 6.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllDoubleArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllDoubleArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((double[])new double[]{1.0, 2.0}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllDoubleArrayRemoveNone() {
        double[] array1 = new double[]{1.0, 2.0};
        double[] array2 = ArrayUtils.removeAll((double[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((double[])array1, (double[])array2);
        Assertions.assertEquals(Double.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllFloatArray() {
        float[] array = ArrayUtils.removeAll((float[])new float[]{1.0f}, (int[])new int[]{0});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{1});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 1.0f}, (int[])new int[]{1});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((float[])new float[]{3.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f, 5.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 4.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((float[])new float[]{1.0f, 3.0f, 5.0f, 7.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 4.0f, 6.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllFloatArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllFloatArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((float[])new float[]{1.0f, 2.0f}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllFloatArrayRemoveNone() {
        float[] array1 = new float[]{1.0f, 2.0f};
        float[] array2 = ArrayUtils.removeAll((float[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((float[])array1, (float[])array2);
        Assertions.assertEquals(Float.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllIntArray() {
        int[] array = ArrayUtils.removeAll((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])ArrayUtils.EMPTY_INT_ARRAY);
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        array = ArrayUtils.removeAll((int[])new int[]{1}, (int[])ArrayUtils.EMPTY_INT_ARRAY);
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        array = ArrayUtils.removeAll((int[])new int[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{1, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((int[])new int[]{3}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((int[])new int[]{1, 3, 5}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((int[])new int[]{2, 4}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((int[])new int[]{1, 3, 5, 7}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((int[])new int[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((int[])new int[]{2, 4, 6}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllIntArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllIntArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((int[])new int[]{1, 2}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllIntArrayRemoveNone() {
        int[] array1 = new int[]{1, 2};
        int[] array2 = ArrayUtils.removeAll((int[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((int[])array1, (int[])array2);
        Assertions.assertEquals(Integer.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllLongArray() {
        long[] array = ArrayUtils.removeAll((long[])new long[]{1L}, (int[])new int[]{0});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{1});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 1L}, (int[])new int[]{1});
        Assertions.assertArrayEquals((long[])new long[]{1L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((long[])new long[]{3L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L, 5L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((long[])new long[]{2L, 4L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((long[])new long[]{1L, 3L, 5L, 7L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((long[])new long[]{2L, 4L, 6L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllLongArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllLongArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((long[])new long[]{1L, 2L}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllLongArrayRemoveNone() {
        long[] array1 = new long[]{1L, 2L};
        long[] array2 = ArrayUtils.removeAll((long[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((long[])array1, (long[])array2);
        Assertions.assertEquals(Long.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllNullBooleanArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((boolean[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullByteArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((byte[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullCharArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((char[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullDoubleArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((double[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullFloatArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((float[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullIntArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((int[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullLongArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((long[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNullObjectArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.remove((Object[])null, (int)0));
    }

    @Test
    public void testRemoveAllNullShortArray() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((short[])null, (int[])new int[]{0}));
    }

    @Test
    public void testRemoveAllNumberArray() {
        Object[] inarray = new Number[]{1, 2L, (byte)3};
        Assertions.assertEquals((int)3, (int)inarray.length);
        Object[] outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1});
        Assertions.assertArrayEquals((Object[])new Number[]{1, (byte)3}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{1});
        Assertions.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])outarray, (int[])new int[]{0});
        Assertions.assertEquals((int)0, (int)outarray.length);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((Object[])new Number[]{(byte)3}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((Object[])new Number[]{2L}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
        outarray = (Number[])ArrayUtils.removeAll((Object[])inarray, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Number[]{1}, (Object[])outarray);
        Assertions.assertEquals(Number.class, outarray.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllObjectArray() {
        Object[] array = ArrayUtils.removeAll((Object[])new Object[]{"a"}, (int[])new int[]{0});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c"}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((Object[])new Object[]{"a", "d"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c", "e"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d", "e"}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "d"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{0, 1, 3, 0, 1, 3});
        Assertions.assertArrayEquals((Object[])new Object[]{"c"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 1, 0, 3});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((Object[])new Object[]{"a", "b", "c", "d"}, (int[])new int[]{2, 0, 1, 3, 0, 2, 1, 3});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllObjectArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{-1}));
    }

    @Test
    public void testRemoveAllObjectArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((Object[])new Object[]{"a", "b"}, (int[])new int[]{2}));
    }

    @Test
    public void testRemoveAllObjectArrayRemoveNone() {
        Object[] array1 = new Object[]{"foo", "bar", "baz"};
        Object[] array2 = ArrayUtils.removeAll((Object[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((Object[])array1, (Object[])array2);
        Assertions.assertEquals(Object.class, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllShortArray() {
        short[] array = ArrayUtils.removeAll((short[])new short[]{1}, (int[])new int[]{0});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((short[])new short[]{1, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 1});
        Assertions.assertArrayEquals((short[])new short[]{3}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3}, (int[])new int[]{0, 2});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{1, 3});
        Assertions.assertArrayEquals((short[])new short[]{1, 3, 5}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5}, (int[])new int[]{0, 2, 4});
        Assertions.assertArrayEquals((short[])new short[]{2, 4}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{1, 3, 5});
        Assertions.assertArrayEquals((short[])new short[]{1, 3, 5, 7}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeAll((short[])new short[]{1, 2, 3, 4, 5, 6, 7}, (int[])new int[]{0, 2, 4, 6});
        Assertions.assertArrayEquals((short[])new short[]{2, 4, 6}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveAllShortArrayNegativeIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{-1, 0}));
    }

    @Test
    public void testRemoveAllShortArrayOutOfBoundsIndex() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> ArrayUtils.removeAll((short[])new short[]{1, 2}, (int[])new int[]{2, 0}));
    }

    @Test
    public void testRemoveAllShortArrayRemoveNone() {
        short[] array1 = new short[]{1, 2};
        short[] array2 = ArrayUtils.removeAll((short[])array1, (int[])new int[0]);
        Assertions.assertNotSame((Object)array1, (Object)array2);
        Assertions.assertArrayEquals((short[])array1, (short[])array2);
        Assertions.assertEquals(Short.TYPE, array2.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementBooleanArray() {
        boolean[] array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])null, (boolean[])new boolean[]{true, false});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])ArrayUtils.EMPTY_BOOLEAN_ARRAY, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false}, (boolean[])new boolean[]{true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, false});
        Assertions.assertArrayEquals((boolean[])new boolean[]{true}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((boolean[])new boolean[]{true, false, true}, (boolean[])new boolean[]{true, true, true, true});
        Assertions.assertArrayEquals((boolean[])new boolean[]{false}, (boolean[])array);
        Assertions.assertEquals(Boolean.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementByteArray() {
        byte[] array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1});
        Assertions.assertArrayEquals((byte[])new byte[]{2, 1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])null, (byte[])new byte[]{1, 2});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])ArrayUtils.EMPTY_BYTE_ARRAY, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2}, (byte[])new byte[]{1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 2});
        Assertions.assertArrayEquals((byte[])new byte[]{1}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((byte[])new byte[]{1, 2, 1}, (byte[])new byte[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((byte[])new byte[]{2}, (byte[])array);
        Assertions.assertEquals(Byte.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementCharArray() {
        char[] array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a'});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b', 'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])null, (char[])new char[]{'a', 'b'});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])ArrayUtils.EMPTY_CHAR_ARRAY, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b'}, (char[])new char[]{'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'b'});
        Assertions.assertArrayEquals((char[])new char[]{'a'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((char[])new char[]{'a', 'b', 'a'}, (char[])new char[]{'a', 'a', 'a', 'a'});
        Assertions.assertArrayEquals((char[])new char[]{'b'}, (char[])array);
        Assertions.assertEquals(Character.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementDoubleArray() {
        double[] array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0, 1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])null, (double[])new double[]{1.0, 2.0});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])ArrayUtils.EMPTY_DOUBLE_ARRAY, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0}, (double[])new double[]{1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 2.0});
        Assertions.assertArrayEquals((double[])new double[]{1.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((double[])new double[]{1.0, 2.0, 1.0}, (double[])new double[]{1.0, 1.0, 1.0, 1.0});
        Assertions.assertArrayEquals((double[])new double[]{2.0}, (double[])array);
        Assertions.assertEquals(Double.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementFloatArray() {
        float[] array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f, 1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])null, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 2.0f});
        Assertions.assertArrayEquals((float[])ArrayUtils.EMPTY_FLOAT_ARRAY, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 2.0f});
        Assertions.assertArrayEquals((float[])new float[]{1.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((float[])new float[]{1.0f, 2.0f, 1.0f}, (float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        Assertions.assertArrayEquals((float[])new float[]{2.0f}, (float[])array);
        Assertions.assertEquals(Float.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementIntArray() {
        int[] array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1});
        Assertions.assertArrayEquals((int[])new int[]{2, 1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])null, (int[])new int[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 2});
        Assertions.assertArrayEquals((int[])new int[]{1}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((int[])new int[]{1, 2, 1}, (int[])new int[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((int[])new int[]{2}, (int[])array);
        Assertions.assertEquals(Integer.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementLongArray() {
        long[] array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L});
        Assertions.assertArrayEquals((long[])new long[]{2L, 1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])null, (long[])new long[]{1L, 1L});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 2L});
        Assertions.assertArrayEquals((long[])ArrayUtils.EMPTY_LONG_ARRAY, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 2L});
        Assertions.assertArrayEquals((long[])new long[]{1L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((long[])new long[]{1L, 2L, 1L}, (long[])new long[]{1L, 1L, 1L, 1L});
        Assertions.assertArrayEquals((long[])new long[]{2L}, (long[])array);
        Assertions.assertEquals(Long.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementShortArray() {
        short[] array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1});
        Assertions.assertArrayEquals((short[])new short[]{2, 1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])null, (short[])new short[]{1, 1});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 2});
        Assertions.assertArrayEquals((short[])ArrayUtils.EMPTY_SHORT_ARRAY, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 2});
        Assertions.assertArrayEquals((short[])new short[]{1}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((short[])new short[]{1, 2, 1}, (short[])new short[]{1, 1, 1, 1});
        Assertions.assertArrayEquals((short[])new short[]{2}, (short[])array);
        Assertions.assertEquals(Short.TYPE, array.getClass().getComponentType());
    }

    @Test
    public void testRemoveElementsObjectArray() {
        Object[] array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a"});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])null, (Object[])new Object[]{"a", "b"});
        Assertions.assertNull((Object)array);
        array = ArrayUtils.removeElements((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a"}, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])ArrayUtils.EMPTY_OBJECT_ARRAY, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b"}, (Object[])new Object[]{"a", "c"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b", "a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "b"});
        Assertions.assertArrayEquals((Object[])new Object[]{"a"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
        array = ArrayUtils.removeElements((Object[])new Object[]{"a", "b", "a"}, (Object[])new Object[]{"a", "a", "a", "a"});
        Assertions.assertArrayEquals((Object[])new Object[]{"b"}, (Object[])array);
        Assertions.assertEquals(Object.class, array.getClass().getComponentType());
    }
}

