/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigInteger;
import org.apache.commons.jexl3.Arithmetic360;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.junit.Asserter;
import org.junit.Assert;
import org.junit.Test;

public class ShiftOperatorsTest
extends JexlTestCase {
    private Asserter asserter;
    private Asserter a360;

    public ShiftOperatorsTest() {
        super("ShiftOperatorsTest");
        this.asserter = new Asserter(this.JEXL);
        this.asserter.setStrict(false, false);
        JexlEngine j360 = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic360(true)).strict(true).create();
        this.a360 = new Asserter(j360);
        this.a360.setStrict(false, false);
    }

    @Test
    public void testLeftShiftIntValue() throws Exception {
        String expr = "(x, y)-> x << y";
        this.asserter.assertExpression("(x, y)-> x << y", 4L, 1L, 2);
        this.asserter.assertExpression("(x, y)-> x << y", 0x4000000000000000L, 1L, -2);
        this.asserter.assertExpression("(x, y)-> x << y", -4L, -1L, 2);
        this.asserter.assertExpression("(x, y)-> x << y", -4611686018427387904L, -1L, -2);
        this.a360.assertExpression("(x, y)-> x << y", 4L, 1L, 2);
        this.a360.assertExpression("(x, y)-> x << y", 0x4000000000000000L, 1L, -2);
        this.a360.assertExpression("(x, y)-> x << y", -4L, -1L, 2);
        this.a360.assertExpression("(x, y)-> x << y", -4611686018427387904L, -1L, -2);
        this.a360.assertExpression("(x, y)-> x << y", 4, 1, 2);
        this.a360.assertExpression("(x, y)-> x << y", 0x40000000, 1, -2);
        this.a360.assertExpression("(x, y)-> x << y", -4, -1, 2);
        this.a360.assertExpression("(x, y)-> x << y", -1073741824, -1, -2);
    }

    @Test
    public void testRightShiftIntValue() throws Exception {
        String expr = "(x, y)-> x >> y";
        this.asserter.assertExpression("(x, y)-> x >> y", 10L, 42L, 2);
        this.asserter.assertExpression("(x, y)-> x >> y", 0L, 42L, -2);
        this.asserter.assertExpression("(x, y)-> x >> y", -11L, -42L, 2);
        this.asserter.assertExpression("(x, y)-> x >> y", -1L, -42L, -2);
        this.a360.assertExpression("(x, y)-> x >> y", 10L, 42L, 2);
        this.a360.assertExpression("(x, y)-> x >> y", 0L, 42L, -2);
        this.a360.assertExpression("(x, y)-> x >> y", -11L, -42L, 2);
        this.a360.assertExpression("(x, y)-> x >> y", -1L, -42L, -2);
        this.a360.assertExpression("(x, y)-> x >> y", 10, 42, 2);
        this.a360.assertExpression("(x, y)-> x >> y", 0, 42, -2);
        this.a360.assertExpression("(x, y)-> x >> y", -11, -42, 2);
        this.a360.assertExpression("(x, y)-> x >> y", -1, -42, -2);
    }

    @Test
    public void testRightShiftUnsignedIntValue() throws Exception {
        String expr = "(x, y)-> x >>> y";
        this.asserter.assertExpression("(x, y)-> x >>> y", 10L, 42L, 2);
        this.asserter.assertExpression("(x, y)-> x >>> y", 0L, 42L, -2);
        this.asserter.assertExpression("(x, y)-> x >>> y", 0x3FFFFFFFFFFFFFF5L, -42L, 2);
        this.asserter.assertExpression("(x, y)-> x >>> y", 3L, -42L, -2);
    }

    @Test
    public void testLeftShiftLongValue() throws Exception {
        this.a360.assertExpression("2147483648 << 2", 0x200000000L, new Object[0]);
        this.a360.assertExpression("2147483648 << -2", 0L, new Object[0]);
        this.a360.assertExpression("-2147483649 << 2", -8589934596L, new Object[0]);
        this.a360.assertExpression("-2147483649 << -2", -4611686018427387904L, new Object[0]);
    }

    @Test
    public void testRightShiftLongValue() throws Exception {
        this.a360.assertExpression("8589934592 >> 2", 0x80000000L, new Object[0]);
        this.a360.assertExpression("8589934592 >> -2", 0L, new Object[0]);
        this.a360.assertExpression("-8589934592 >> 2", Integer.MIN_VALUE, new Object[0]);
        this.a360.assertExpression("-8589934592 >> -2", -1L, new Object[0]);
    }

    @Test
    public void testRightShiftBigValue() throws Exception {
        this.a360.assertExpression("9223372036854775808 >> 2", new BigInteger("9223372036854775808").shiftRight(2), new Object[0]);
        this.a360.assertExpression("9223372036854775808 >> -2", new BigInteger("9223372036854775808").shiftRight(-2), new Object[0]);
        this.a360.assertExpression("-9223372036854775809 >> 2", new BigInteger("-9223372036854775809").shiftRight(2), new Object[0]);
        this.a360.assertExpression("-9223372036854775809 >> -2", new BigInteger("-9223372036854775809").shiftRight(-2), new Object[0]);
    }

    static BigInteger shiftRightUnsigned(String bl, int r) {
        return ShiftOperatorsTest.shiftRightUnsigned(new BigInteger(bl), r);
    }

    static BigInteger shiftRightUnsigned(BigInteger bl, int r) {
        return bl.signum() < 0 ? bl.negate().shiftRight(r) : bl.shiftRight(r);
    }

    @Test
    public void testRightShiftUnsignedBigValue() throws Exception {
        this.a360.assertExpression("9223372036854775808 >>> 2", ShiftOperatorsTest.shiftRightUnsigned("9223372036854775808", 2), new Object[0]);
        this.a360.assertExpression("9223372036854775808 >>> -2", ShiftOperatorsTest.shiftRightUnsigned("9223372036854775808", -2), new Object[0]);
        this.a360.assertExpression("-9223372036854775809 >>> 2", ShiftOperatorsTest.shiftRightUnsigned("-9223372036854775809", 2), new Object[0]);
        this.a360.assertExpression("-9223372036854775809 >>> -2", ShiftOperatorsTest.shiftRightUnsigned("-9223372036854775809", -2), new Object[0]);
    }

    @Test
    public void testOverloadedShift() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new ShiftArithmetic(true)).create();
        StringBuilder x = new StringBuilder("1");
        JexlScript e = jexl.createScript("x << 'Left'", new String[]{"x"});
        Object o = e.execute(null, new Object[]{x});
        Assert.assertEquals((String)e.getSourceText(), (Object)"1Left", (Object)o.toString());
        e = jexl.createScript("'Right' >> x", new String[]{"x"});
        x = new StringBuilder("1");
        o = e.execute(null, new Object[]{x});
        Assert.assertEquals((String)e.getSourceText(), (Object)"1Right", (Object)x.toString());
        e = jexl.createScript("'Right' >>> x", new String[]{"x"});
        x = new StringBuilder("1");
        o = e.execute(null, new Object[]{x});
        Assert.assertEquals((String)e.getSourceText(), (Object)"1right", (Object)x.toString());
    }

    @Test
    public void testPrecedence() throws Exception {
        this.a360.assertExpression("40 + 2 << 1 + 1", 168, new Object[0]);
        this.a360.assertExpression("40 + (2 << 1) + 1", 45, new Object[0]);
        this.a360.assertExpression("(40 + 2) << (1 + 1)", 168, new Object[0]);
        this.a360.assertExpression("40 + 2L << 1 + 1", 168L, new Object[0]);
        this.a360.assertExpression("40 + (2L << 1) + 1", 45L, new Object[0]);
        this.a360.assertExpression("(40 + 2L) << (1 + 1)", 168L, new Object[0]);
        this.a360.assertExpression("40L + 2 << 1 + 1", 168L, new Object[0]);
        this.a360.assertExpression("40L + (2 << 1) + 1", 45L, new Object[0]);
        this.a360.assertExpression("(40L + 2) << (1 + 1)", 168L, new Object[0]);
    }

    public static class ShiftArithmetic
    extends JexlArithmetic {
        ShiftArithmetic(boolean flag) {
            super(flag);
        }

        public Object shiftLeft(StringBuilder c, String value) {
            c.append(value);
            return c;
        }

        public Object shiftRight(String value, StringBuilder c) {
            c.append(value);
            return c;
        }

        public Object shiftRightUnsigned(String value, StringBuilder c) {
            c.append(value.toLowerCase());
            return c;
        }
    }
}

