/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.annotations.NoJexl;

public class JexlEvalContext
implements JexlContext,
JexlContext.NamespaceResolver,
JexlContext.OptionsHandle {
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final JexlContext vars;
    private final JexlContext.NamespaceResolver ns;
    private final JexlOptions options = new JexlOptions();

    @NoJexl
    public JexlEvalContext() {
        this(EMPTY_MAP);
    }

    @NoJexl
    public JexlEvalContext(Map<String, Object> map) {
        this.vars = map == EMPTY_MAP ? new MapContext() : new MapContext(map);
        this.ns = null;
    }

    @NoJexl
    public JexlEvalContext(JexlContext context) {
        this(context, context instanceof JexlContext.NamespaceResolver ? (JexlContext.NamespaceResolver)context : null);
    }

    @NoJexl
    public JexlEvalContext(JexlContext context, JexlContext.NamespaceResolver namespace) {
        this.vars = context != null ? context : JexlEngine.EMPTY_CONTEXT;
        this.ns = namespace != null ? namespace : JexlEngine.EMPTY_NS;
    }

    @NoJexl
    public boolean has(String name) {
        return this.vars.has(name);
    }

    @NoJexl
    public Object get(String name) {
        return this.vars.get(name);
    }

    @NoJexl
    public void set(String name, Object value) {
        this.vars.set(name, value);
    }

    @NoJexl
    public Object resolveNamespace(String name) {
        return this.ns != null ? this.ns.resolveNamespace(name) : null;
    }

    @NoJexl
    public JexlOptions getEngineOptions() {
        return this.options;
    }
}

