/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.Engine32;
import org.apache.commons.jexl3.internal.OptionsContext;
import org.apache.commons.jexl3.internal.Util;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.junit.Assert;
import org.junit.Test;

public class Issues300Test {
    @Test
    public void test301a() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        String[] srcs = new String[]{"var x = null; x.0", "var x = null; x[0]", "var x = [null,1]; x[0][0]"};
        for (int i = 0; i < srcs.length; ++i) {
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            try {
                Object o = s.execute(null);
                if (i <= 0) continue;
                Assert.fail((String)(src + ": Should have failed"));
                continue;
            }
            catch (Exception ex) {
                Assert.assertTrue((boolean)ex.getMessage().contains("x"));
            }
        }
    }

    @Test
    public void tests301b() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic(new JexlArithmetic(false)).create();
        Object[] xs = new Object[]{null, null, new Object[]{null, 1}};
        String[] srcs = new String[]{"x.0", "x[0]", "x[0][0]"};
        MapContext ctxt = new MapContext();
        for (int i = 0; i < xs.length; ++i) {
            ctxt.set("x", xs[i]);
            String src = srcs[i];
            JexlScript s = jexl.createScript(src);
            try {
                Object o = s.execute(null);
                Assert.fail((String)(src + ": Should have failed"));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Test
    public void test302() {
        MapContext jc = new MapContext();
        String[] strs = new String[]{"{if (0) 1 else 2; var x = 4;}", "if (0) 1; else 2; ", "{ if (0) 1; else 2; }", "{ if (0) { if (false) 1 else -3 } else 2; }"};
        JexlEngine jexl = new JexlBuilder().create();
        for (String str : strs) {
            JexlScript e = jexl.createScript(str);
            Object o = e.execute((JexlContext)jc);
            int oo = ((Number)o).intValue() % 2;
            Assert.assertEquals((String)("Block result is wrong " + str), (long)0L, (long)oo);
        }
    }

    @Test
    public void test304() {
        String pkw;
        int i;
        JexlEngine jexlEngine = new JexlBuilder().strict(false).create();
        JexlExpression e304 = jexlEngine.createExpression("overview.limit.var");
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put("var", "4711");
        HashMap<String, HashMap<String, String>> map2 = new HashMap<String, HashMap<String, String>>();
        map2.put("limit", map3);
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("overview", map2);
        MapContext context = new MapContext(map);
        Object value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"4711", (Object)value);
        map.clear();
        map.put("overview.limit.var", Integer.valueOf(42));
        value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)42, (Object)value);
        CharSequence[] keywords = new String[]{"if", "else", "do", "while", "for", "break", "continue", "function", "return", "new", "size", "empty", "var", "let", "const", "null", "true", "false", "not", "div", "mod", "and", "or", "eq", "ne", "lt", "gt", "ge", "le"};
        for (i = 0; i < keywords.length; ++i) {
            pkw = "e304." + keywords[i];
            map.put(pkw, Integer.valueOf(42));
            e304 = jexlEngine.createExpression(pkw);
            value = e304.evaluate((JexlContext)context);
            Assert.assertEquals((Object)42, (Object)value);
        }
        for (i = 0; i < keywords.length; ++i) {
            pkw = "e304." + keywords[i] + "." + (String)keywords[keywords.length - 1 - i];
            map.put(pkw, Integer.valueOf(42));
            e304 = jexlEngine.createExpression(pkw);
            value = e304.evaluate((JexlContext)context);
            Assert.assertEquals((Object)42, (Object)value);
        }
        String allkw = "e304." + String.join((CharSequence)".", keywords);
        map.put(allkw, Integer.valueOf(42));
        e304 = jexlEngine.createExpression(allkw);
        value = e304.evaluate((JexlContext)context);
        Assert.assertEquals((Object)42, (Object)value);
    }

    @Test
    public void test305() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("{while(false) {}; var x = 1;}");
        String str0 = e.getParsedText();
        e = jexl.createScript(str0);
        Assert.assertNotNull((Object)e);
        String str1 = e.getParsedText();
        Assert.assertEquals((Object)str0, (Object)str1);
    }

    @Test
    public void test306() {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2");
        Object o1 = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o1);
        ctxt.set("x.y", null);
        Object o2 = e.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)2, (Object)o2);
    }

    @Test
    public void test306a() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void test306b() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript e = jexl.createScript("x?.y ?: 2", new String[]{"x"});
        Object o1 = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o1);
        Object o2 = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o2);
    }

    @Test
    public void test306c() {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void test306d() {
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript e = jexl.createScript("x.y[z.t] ?: 2", new String[]{"x"});
        Object o = e.execute(null, new Object[]{new Object()});
        Assert.assertEquals((Object)2, (Object)o);
        o = e.execute(null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void test309a() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = 12++;\n  </body>\n</html>");
            Assert.fail((String)"shoud have thrown exception");
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void test309b() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i = a b c;\n  </body>\n</html>");
            Assert.fail((String)"shoud have thrown exception");
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void test309c() {
        String src = "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JexlInfo info = new JexlInfo("template", 1, 1);
        try {
            JxltEngine.Template tmplt = jxlt.createTemplate(info, "<html lang=\"en\">\n  <body>\n    <h1>Hello World!</h1>\n$$ var i =12;\n  </body>\n</html>");
            String src1 = tmplt.asString();
            String src2 = tmplt.toString();
            Assert.assertEquals((Object)src1, (Object)src2);
        }
        catch (JexlException.Parsing xerror) {
            Assert.assertEquals((long)4L, (long)xerror.getInfo().getLine());
        }
    }

    @Test
    public void test314() {
        JexlEngine jexl = new JexlBuilder().strict(true).safe(false).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("cell()");
        Object result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)0, (Object)result);
        script = jexl.createScript("x.cell()", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("cell('1', '2')");
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)2, (Object)result);
        script = jexl.createScript("x.cell('1', '2')", new String[]{"x"});
        result = script.execute((JexlContext)ctxt, new Object[]{Arrays.asList(10, 20)});
        Assert.assertEquals((Object)44, (Object)result);
        vars.put("TVALOGAR", null);
        String jexlExp = "TVALOGAR==null?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
        jexlExp = "TVALOGAR.PEPITO==null?'SIMON':'SIMONAZO'";
        script = jexl.createScript(jexlExp);
        LinkedHashMap<String, Object> tva = new LinkedHashMap<String, Object>();
        tva.put("PEPITO", null);
        vars.put("TVALOGAR", tva);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
        vars.remove("TVALOGAR");
        ctxt.set("TVALOGAR.PEPITO", null);
        result = script.execute((JexlContext)ctxt);
        Assert.assertEquals((Object)"SIMON", (Object)result);
    }

    @Test
    public void test315() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        VaContext ctxt = new VaContext(vars);
        JexlScript script = jexl.createScript("a?? 42 + 10", new String[]{"a"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("- a??42 + +10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)-32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a? a : +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
        script = jexl.createScript("a ?: +42 + 10", new String[]{"a"});
        result = script.execute((JexlContext)ctxt, new Object[]{32});
        Assert.assertEquals((Object)32, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{null});
        Assert.assertEquals((Object)52, (Object)result);
    }

    @Test
    public void test317() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        MapContext ctxt = new MapContext();
        JexlInfo info = new JexlInfo("test317", 1, 1);
        JexlScript script = jexl.createScript(info, "var f = ()-> {x + x }; f", new String[]{"x"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertTrue((boolean)(result instanceof JexlScript));
        script = (JexlScript)result;
        info = JexlInfo.from((JexlScript)script);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)"test317", (Object)info.getName());
        result = script.execute((JexlContext)ctxt, new Object[]{21});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test322a() {
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext context = new MapContext();
        String[] ins = new String[]{"${'{'}", "${\"{\"}", "${\"{}\"}", "${'{42}'}", "${\"{\\\"\\\"}\"}"};
        String[] ctls = new String[]{"{", "{", "{}", "{42}", "{\"\"}"};
        for (int i = 0; i < ins.length; ++i) {
            JxltEngine.Template template;
            String src = ins[i];
            try {
                template = jxlt.createTemplate("$$", (Reader)new StringReader(src), new String[0]);
            }
            catch (JexlException xany) {
                Assert.fail((String)src);
                throw xany;
            }
            StringWriter strw = new StringWriter();
            template.evaluate((JexlContext)context, (Writer)strw);
            String output = strw.toString();
            Assert.assertEquals((Object)ctls[i], (Object)output);
        }
    }

    @Test
    public void test322b() {
        MapContext ctxt = new MapContext();
        String src = "L'utilisateur ${session.user.name} s'est connecte";
        JexlEngine jexl = new JexlBuilder().strict(true).create();
        JxltEngine jxlt = jexl.createJxltEngine();
        JxltEngine.Template template = jxlt.createTemplate("$$", (Reader)new StringReader("L'utilisateur ${session.user.name} s'est connecte"), new String[0]);
        ctxt.set("session", (Object)new Session322());
        StringWriter strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        String output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user", (Object)new User322());
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
        ctxt.set("session.user.name", (Object)"user322");
        strw = new StringWriter();
        template.evaluate((JexlContext)ctxt, (Writer)strw);
        output = strw.toString();
        Assert.assertEquals((Object)"L'utilisateur user322 s'est connecte", (Object)output);
    }

    @Test
    public void test323() {
        Object result;
        JexlScript script;
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap vars = new HashMap();
        MapContext jc = new MapContext(vars);
        try {
            script = jexl.createScript("a.n.t.variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t.variable is undefined!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        jc.set("a.n.t.variable", null);
        script = jexl.createScript("a.n.t.variable");
        result = script.execute((JexlContext)jc);
        Assert.assertNull((Object)result);
        jc.set("a.n.t", null);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        vars.remove("a.n.t");
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is undefined!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertTrue((boolean)xvar.toString().contains("a.n.t"));
        }
        ArrayList<Integer> inner = new ArrayList<Integer>();
        vars.put("a.n.t", inner);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Property xprop) {
            Assert.assertTrue((boolean)xprop.toString().contains("0"));
        }
        inner.add(42);
        try {
            script = jexl.createScript("a.n.t[0].variable");
            result = script.execute((JexlContext)jc);
            Assert.fail((String)"a.n.t is null!");
        }
        catch (JexlException.Property xprop) {
            Assert.assertTrue((boolean)xprop.toString().contains("variable"));
        }
    }

    @Test
    public void test324() {
        JexlEngine jexl = new JexlBuilder().create();
        String src42 = "new('java.lang.Integer', 42)";
        JexlExpression expr0 = jexl.createExpression("new('java.lang.Integer', 42)");
        Assert.assertEquals((Object)42, (Object)expr0.evaluate(null));
        String parsed = expr0.getParsedText();
        Assert.assertEquals((Object)"new('java.lang.Integer', 42)", (Object)parsed);
        try {
            JexlExpression expr = jexl.createExpression("new()");
            Assert.fail((String)"should not parse");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.toString().contains(")"));
        }
    }

    @Test
    public void test325() {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        HashMap<String, Object> map = new HashMap<String, Object>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object get(Object key) {
                return super.get(key == null ? "" : key);
            }

            @Override
            public Object put(String key, Object value) {
                return super.put(key == null ? "" : key, value);
            }
        };
        map.put("42", 42);
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("map[null] = 42", new String[]{"map"});
        Object result = script.execute((JexlContext)jc, new Object[]{map});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("map[key]", new String[]{"map", "key"});
        result = script.execute((JexlContext)jc, new Object[]{map, null});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)jc, new Object[]{map, "42"});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test330() {
        JexlEngine jexl = new JexlBuilder().create();
        String longExpression = "'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'";
        try {
            jexl.createExpression("'THIS IS A VERY VERY VERY VERY VERY VERY VERY VERY VERY LONG STRING CONCATENATION ' + VARIABLE ' <--- error: missing + between VARIABLE and literal'");
            Assert.fail((String)"parsing malformed expression did not throw exception");
        }
        catch (JexlException.Parsing exception) {
            Assert.assertTrue((boolean)exception.getMessage().contains("VARIABLE"));
        }
    }

    @Test
    public void test331() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext ctxt = new MapContext();
        JexlScript script = jexl.createScript("a + '\\n' + b", new String[]{"a", "b"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{"hello", "world"});
        Assert.assertTrue((boolean)result.toString().contains("\n"));
    }

    @Test
    public void test347() {
        String src = "A.B == 5";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("A.B == 5");
        Object result = script.execute(null);
        Assert.assertFalse((boolean)((Boolean)result));
        jexl = new JexlBuilder().strict(true).safe(false).create();
        MapContext ctxt = new MapContext();
        script = jexl.createScript("A.B == 5");
        try {
            result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"should only succeed with safe navigation");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
        ctxt.set("A", null);
        try {
            result = script.execute((JexlContext)ctxt);
            Assert.fail((String)"should only succeed with safe navigation");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
        ctxt.set("A.B", null);
        result = script.execute((JexlContext)ctxt);
        Assert.assertFalse((boolean)((Boolean)result));
    }

    @Test
    public void test349() {
        String text = "(A ? C.D : E)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlExpression expr = jexl.createExpression(text);
        JexlScript script = jexl.createScript(text);
    }

    static JexlContext pragmaticContext() {
        JexlOptions opts = new JexlOptions();
        opts.setFlags(new String[]{"-strict", "-cancellable", "-lexical", "-lexicalShade", "+safe", "+sharedInstance"});
        return new JexlTestCase.PragmaticContext(opts);
    }

    @Test
    public void testPropagateOptions() {
        String src0 = "`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        String text = "#pragma script.mode pro50\n()->{ ()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(text);
        JexlContext context = Issues300Test.pragmaticContext();
        JexlScript closure = (JexlScript)script.execute(context);
        OptionsContext opts = new OptionsContext();
        Object result = closure.execute((JexlContext)opts);
        Assert.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result);
        String text0 = "#pragma script.mode pro50\n()->{ `${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`; }";
        JexlScript script0 = jexl.createScript(text0);
        context = Issues300Test.pragmaticContext();
        Object result0 = script0.execute(context);
        Assert.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result0);
        String text1 = "#pragma script.mode pro50\n`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        JexlScript script1 = jexl.createScript(text1);
        context = Issues300Test.pragmaticContext();
        Object result1 = script1.execute(context);
        Assert.assertEquals((Object)"+strict +cancellable +lexical +lexicalShade -sharedInstance -safe", (Object)result1);
        String text2 = "`${$options.strict?'+':'-'}strict ${$options.cancellable?'+':'-'}cancellable ${$options.lexical?'+':'-'}lexical ${$options.lexicalShade?'+':'-'}lexicalShade ${$options.sharedInstance?'+':'-'}sharedInstance ${$options.safe?'+':'-'}safe`";
        JexlScript script2 = jexl.createScript(text2);
        context = Issues300Test.pragmaticContext();
        Object result2 = script2.execute(context);
        Assert.assertEquals((Object)"-strict -cancellable -lexical -lexicalShade +sharedInstance +safe", (Object)result2);
    }

    @Test
    public void test361a_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false));
        Object result = this.run361a((JexlEngine)jexl);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void test361a_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        try {
            Object result = this.run361a(jexl);
            Assert.fail((String)"null arg should fail");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    private Object run361a(JexlEngine jexl) {
        String src = "()-> { ()-> { if (versionFile != null) { return 'foo'; } else { return 'bar'; }} }";
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null);
        JexlScript rs = (JexlScript)result;
        return rs.execute(null);
    }

    @Test
    public void test361b_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        try {
            Object result = this.run361b(jexl);
            Assert.fail((String)"null arg should fail");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void test361b_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false).strict(false));
        Object result = this.run361b((JexlEngine)jexl);
        Assert.assertNotNull((Object)result);
    }

    private Object run361b(JexlEngine jexl) {
        String src = "()-> { ()-> {var voa = vaf.value;\nif (voa != NaN && voa <= 0){ return 'foo'; } else { return 'bar'; }} }";
        MapContext context = new MapContext();
        Map<String, Object> vaf = Collections.singletonMap("value", null);
        context.set("vaf", vaf);
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null);
        JexlScript rs = (JexlScript)result;
        return rs.execute((JexlContext)context);
    }

    @Test
    public void test361_33() {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        try {
            this.run361c(jexl);
            Assert.fail((String)"null arg should fail");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    @Test
    public void test361c_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().safe(false).strict(false));
        String result = this.run361c((JexlEngine)jexl);
        Assert.assertNotNull((Object)result);
    }

    private String run361c(JexlEngine jexl) {
        String src = "$$var t = null;\n$$if (t < 0) {\n'foo'\n$$} else {\n'bar'\n$$}";
        JxltEngine jxlt = jexl.createJxltEngine();
        MapContext context = new MapContext();
        Map<String, Object> vaf = Collections.singletonMap("value", null);
        context.set("vaf", vaf);
        JxltEngine.Template template = jxlt.createTemplate(src);
        StringWriter strw = new StringWriter();
        template.evaluate((JexlContext)context, (Writer)strw);
        return strw.toString();
    }

    @Test
    public void test361d_32() {
        Engine32 jexl = new Engine32(new JexlBuilder().lexical(false).lexicalShade(false).safe(false));
        Object result = this.run361d((JexlEngine)jexl);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void test361d_33() {
        JexlEngine jexl = new JexlBuilder().lexical(true).lexicalShade(true).safe(false).strict(true).create();
        try {
            Object result = this.run361d(jexl);
            Assert.fail((String)"null arg should fail");
        }
        catch (JexlException xany) {
            Assert.assertNotNull((Object)((Object)xany));
        }
    }

    private Object run361d(JexlEngine jexl) {
        String src = "var foo = 42; var foo = 43;";
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null);
        return result;
    }

    @Test
    public void test367() {
        String text = "var toto; function foo(x) { x }; var tata = 3; foo(3)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(text);
        Object result = script.execute(null);
        Assert.assertEquals((Object)3, (Object)result);
        String s0 = script.getParsedText();
        String s1 = script.getSourceText();
        Assert.assertNotEquals((Object)s0, (Object)s1);
    }

    @Test
    public void test370() {
        Var370 var370 = new Var370();
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        ObjectContext ctxt = new ObjectContext(jexl, (Object)var370);
        JexlExpression get = jexl.createExpression("name");
        var370.setName("John");
        Assert.assertEquals((Object)"John", (Object)get.evaluate((JexlContext)ctxt));
        Assert.assertTrue((boolean)ctxt.has("name"));
        var370.setName(null);
        Assert.assertNull((Object)get.evaluate((JexlContext)ctxt));
        Assert.assertTrue((boolean)ctxt.has("name"));
        get = jexl.createExpression("phone");
        Assert.assertFalse((boolean)ctxt.has("phone"));
        try {
            get.evaluate((JexlContext)ctxt);
            Assert.fail((String)"phone should be undefined!");
        }
        catch (JexlException.Variable xvar) {
            Assert.assertEquals((Object)"phone", (Object)xvar.getVariable());
        }
    }

    @Test
    public void test374() {
        JexlEngine engine = new JexlBuilder().cache(512).strict(true).silent(false).antish(false).safe(false).create();
        JexlExpression expr = engine.createExpression("nested.name");
        TestObject374 myObject = new TestObject374();
        myObject.setName("John");
        ObjectContext context = new ObjectContext(engine, (Object)myObject);
        try {
            Object result = expr.evaluate((JexlContext)context);
            Assert.fail((String)("An exception expected, but got: " + result));
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void test375() {
        JexlSandbox jexlSandbox = new JexlSandbox(false);
        jexlSandbox.allow(Type375.class.getName());
        JexlEngine engine = new JexlBuilder().sandbox(jexlSandbox).create();
        MapContext context = new MapContext();
        context.set("Type", Type375.class);
        Object result = engine.createScript("Type.valueOf('DOMICILE')").execute((JexlContext)context);
        Assert.assertEquals((Object)((Object)Type375.DOMICILE), (Object)result);
        result = engine.createScript("Type.DOMICILE").execute((JexlContext)context);
        Assert.assertEquals((Object)((Object)Type375.DOMICILE), (Object)result);
    }

    @Test
    public void test377() {
        String text = "function add(x, y) { x + y } add(a, b)";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(text, new String[]{"a", "b"});
        Object result = script.execute(null, new Object[]{20, 22});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test379a() {
        String src = "#pragma jexl.import java.util\nconst map = new LinkedHashMap({0 : 'zero'});";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("#pragma jexl.import java.util\nconst map = new LinkedHashMap({0 : 'zero'});");
        Assert.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof LinkedHashMap));
        Assert.assertEquals((long)1L, (long)((Map)result).size());
    }

    @Test
    public void test373b() {
        String src = "var i = ++1";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlInfo info = new JexlInfo("badscript", 0, 0);
        try {
            JexlScript script = jexl.createScript(info, "var i = ++1", new String[0]);
            Assert.fail((String)"should not parse");
        }
        catch (JexlException.Parsing xparse) {
            String msg = xparse.getMessage();
            Assert.assertTrue((boolean)msg.contains("badscript"));
        }
    }

    @Test
    public void testBackslashes() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        String src = "\"\b\t\f\"";
        JexlScript s = jexl.createScript(src);
        Assert.assertNotNull((Object)s);
        String ctl = "\b\t\f";
        Assert.assertEquals((Object)ctl, (Object)s.execute(null));
        String parsed = s.getParsedText();
        Assert.assertEquals((Object)"'\\b\\t\\f'", (Object)parsed);
        s = jexl.createScript(src);
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((Object)ctl, (Object)s.execute(null));
        parsed = s.getParsedText();
        Assert.assertEquals((Object)"'\\b\\t\\f'", (Object)parsed);
    }

    @Test
    public void testSO20220930() {
        int i;
        ArrayList<Driver0930> values = new ArrayList<Driver0930>();
        for (i = 0; i < 8; ++i) {
            values.add(new Driver0930("drvr" + Integer.toOctalString(i)));
        }
        for (i = 0; i < 4; ++i) {
            values.add(new Driver0930("favorite" + Integer.toOctalString(i)));
        }
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        Context0930 context = new Context0930();
        context.set("values", values);
        context.set("Collectors", Collectors.class);
        String src32 = "values.stream().filter((driver) ->{ driver.attributeName =^ 'favorite' }).collect(Collectors.toList())";
        String src33 = "values.stream().filter(driver -> driver.attributeName =^ 'favorite').collect(Collectors.toList())";
        for (String src : Arrays.asList(src32, src33)) {
            JexlExpression s = jexl.createExpression(src);
            Assert.assertNotNull((Object)s);
            Object r = s.evaluate((JexlContext)context);
            Assert.assertNotNull((Object)r);
            List l = (List)r;
            Assert.assertEquals((long)4L, (long)l.size());
            for (Driver0930 d : l) {
                Assert.assertTrue((boolean)d.getAttributeName().startsWith("favorite"));
            }
        }
    }

    @Test
    public void test383() {
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic((JexlArithmetic)new Arithmetic383(true)).create();
        String src0 = "if (a) 1; else 2;";
        String src1 = "if (!a) 1; else 2;";
        JexlScript s0 = jexl.createScript(src0, new String[]{"a"});
        JexlScript s1 = jexl.createScript(src1, new String[]{"a"});
        Assert.assertEquals((Object)2, (Object)s0.execute(null, new Object[]{null}));
        Assert.assertEquals((Object)1, (Object)s1.execute(null, new Object[]{null}));
        s0 = jexl.createScript(src0);
        s1 = jexl.createScript(src1);
        try {
            Assert.assertEquals((Object)2, (Object)s0.execute(null, new Object[]{null}));
        }
        catch (JexlException.Variable xvar) {
            Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
        }
        try {
            Assert.assertEquals((Object)1, (Object)s1.execute(null, new Object[]{null}));
        }
        catch (JexlException.Variable xvar) {
            Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
        }
        MapContext ctxt = new MapContext();
        ctxt.set("a", null);
        Assert.assertEquals((Object)2, (Object)s0.execute((JexlContext)ctxt, new Object[]{null}));
        Assert.assertEquals((Object)1, (Object)s1.execute((JexlContext)ctxt, new Object[]{null}));
    }

    @Test
    public void test384a() {
        MapContext ctxt;
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        for (String src0 : Arrays.asList("'ABC' + null", "null + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s0 = jexl.createScript(src0);
            try {
                s0.execute((JexlContext)ctxt, new Object[]{null});
                Assert.fail((String)"null argument should throw");
            }
            catch (JexlException xvar) {
                Assert.assertTrue((boolean)xvar.toString().contains("+"));
            }
        }
        for (String src1 : Arrays.asList("'ABC' + a", "a + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s1 = jexl.createScript(src1, new String[]{"a"});
            try {
                s1.execute((JexlContext)ctxt, new Object[]{null});
                Assert.fail((String)"null argument should throw");
            }
            catch (JexlException.Variable xvar) {
                Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
            }
            s1 = jexl.createScript(src1);
            try {
                s1.execute((JexlContext)ctxt, new Object[]{null});
                Assert.fail((String)"null argument should throw");
            }
            catch (JexlException.Variable xvar) {
                Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
                Assert.assertTrue((boolean)xvar.isUndefined());
            }
            ctxt.set("a", null);
            try {
                s1.execute((JexlContext)ctxt, new Object[]{null});
                Assert.fail((String)"null argument should throw");
            }
            catch (JexlException.Variable xvar) {
                Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
                Assert.assertFalse((boolean)xvar.isUndefined());
            }
        }
    }

    @Test
    public void test384b() {
        MapContext ctxt;
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic384(true)).safe(false).strict(true).create();
        for (String src0 : Arrays.asList("'ABC' + null", "null + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s0 = jexl.createScript(src0);
            Assert.assertEquals((Object)"ABC", (Object)s0.execute((JexlContext)ctxt));
        }
        for (String src1 : Arrays.asList("'ABC' + a", "a + 'ABC'")) {
            ctxt = new MapContext();
            JexlScript s1 = jexl.createScript(src1, new String[]{"a"});
            Assert.assertEquals((Object)"ABC", (Object)s1.execute((JexlContext)ctxt, new Object[]{null}));
            s1 = jexl.createScript(src1);
            try {
                s1.execute((JexlContext)ctxt, new Object[]{null});
                Assert.fail((String)"null argument should throw");
            }
            catch (JexlException.Variable xvar) {
                Assert.assertEquals((Object)"a", (Object)xvar.getVariable());
                Assert.assertTrue((boolean)xvar.isUndefined());
            }
            ctxt.set("a", null);
            Assert.assertEquals((Object)"ABC", (Object)s1.execute((JexlContext)ctxt, new Object[]{null}));
        }
    }

    @Test
    public void test390() throws Exception {
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).debug(true).create();
        JexlScript script = null;
        String src = "if (true) #pragma one 42";
        try {
            script = jexl.createScript(src);
            Assert.fail((String)"should have failed parsing");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getDetail().contains("pragma"));
        }
        src = "if (true) { #pragma one 42 }";
        script = jexl.createScript(src);
        Object result = script.execute(null);
        Util.debuggerCheck(jexl);
    }

    @Test
    public void test384c() {
        Arithmetic384c ja = new Arithmetic384c(true);
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).arithmetic((JexlArithmetic)ja).create();
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("3 < 4").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("6 <= 8").evaluate(null)));
        Assert.assertFalse((boolean)ja.toBoolean(jexl.createExpression("6 == 7").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("4 > 2").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("8 > 6").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("7 != 6").evaluate(null)));
        Assert.assertEquals((long)6L, (long)ja.getCmpCalls());
    }

    @Test
    public void test384d() {
        Arithmetic384d ja = new Arithmetic384d(true);
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).arithmetic((JexlArithmetic)ja).create();
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("3 < 4").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("6 <= 8").evaluate(null)));
        Assert.assertFalse((boolean)ja.toBoolean(jexl.createExpression("6 == 7").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("4 > 2").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("8 > 6").evaluate(null)));
        Assert.assertTrue((boolean)ja.toBoolean(jexl.createExpression("7 != 6").evaluate(null)));
        Assert.assertEquals((long)6L, (long)ja.getCmpCalls());
    }

    @Test
    public void test393() {
        String src = "const total = 0;\nif (true) {\n  total = 1;\n}\ntotal; ";
        JexlEngine jexl = new JexlBuilder().safe(false).strict(true).create();
        try {
            JexlScript script = jexl.createScript(src);
            Assert.fail((String)"should fail on const total assignment");
        }
        catch (JexlException.Parsing xparse) {
            Assert.assertTrue((boolean)xparse.getMessage().contains("total"));
        }
    }

    @Test
    public void testDow() {
        String src = "(y, m, d)->{\n// will return 0 for Sunday, 6 for Saturday\nconst t = [0, 3, 2, 5, 0, 3, 5, 1, 4, 6, 2, 4];\nif (m < 3) { --y }\n(y + y/4 - y/100 + y/400 + t[m-1] + d) % 7;\n}";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript(src);
        Object r = script.execute(null, new Object[]{2023, 3, 1});
        Assert.assertTrue((boolean)(r instanceof Number));
        Number dow = (Number)r;
        Assert.assertEquals((long)3L, (long)dow.intValue());
        r = script.execute(null, new Object[]{1969, 7, 20});
        Assert.assertTrue((boolean)(r instanceof Number));
        dow = (Number)r;
        Assert.assertEquals((long)0L, (long)dow.intValue());
    }

    @Test
    public void testIssue394() {
        StringBuilder x = new StringBuilder("foobar");
        Assert.assertEquals((Object)"foobar", (Object)x.toString());
        String src = "x -> x.setLength(3)";
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript(src);
        Object result = script.execute(null, new Object[]{x});
        Assert.assertEquals((Object)"foo", (Object)x.toString());
    }

    public static class Arithmetic384d
    extends Arithmetic384c {
        public Arithmetic384d(boolean astrict) {
            super(astrict);
        }

        public Arithmetic384d(boolean astrict, MathContext bigdContext, int bigdScale) {
            super(astrict, bigdContext, bigdScale);
        }
    }

    public static class Arithmetic384c
    extends JexlArithmetic {
        AtomicInteger cmp = new AtomicInteger(0);

        int getCmpCalls() {
            return this.cmp.get();
        }

        public Arithmetic384c(boolean astrict) {
            super(astrict);
        }

        public Arithmetic384c(boolean astrict, MathContext bigdContext, int bigdScale) {
            super(astrict, bigdContext, bigdScale);
        }

        protected int compare(Object l, Object r, String op) {
            this.cmp.incrementAndGet();
            return super.compare(l, r, op);
        }
    }

    public static class Arithmetic384
    extends JexlArithmetic {
        public Arithmetic384(boolean astrict) {
            super(astrict);
        }

        public boolean isStrict(JexlOperator op) {
            if (JexlOperator.ADD == op) {
                return false;
            }
            return super.isStrict(op);
        }
    }

    public static class Arithmetic383
    extends JexlArithmetic {
        public Arithmetic383(boolean astrict) {
            super(astrict);
        }

        public boolean isStrict(JexlOperator op) {
            switch (op) {
                case NOT: 
                case CONDITION: {
                    return false;
                }
            }
            return super.isStrict(op);
        }
    }

    public static class Context0930
    extends MapContext {
        public Stream<?> filter(Stream<?> stream, JexlScript filter) {
            return stream.filter(x -> Boolean.TRUE.equals(filter.execute((JexlContext)this, new Object[]{x})));
        }
    }

    public static class Driver0930 {
        private String name;

        Driver0930(String n) {
            this.name = n;
        }

        public String getAttributeName() {
            return this.name;
        }
    }

    public static enum Type375 {
        DELIVERY_ADDRESS,
        DOMICILE;

    }

    public static class TestObject374 {
        private String name;
        private TestObject374 nested = null;

        public String getName() {
            return this.name;
        }

        public void setName(String pName) {
            this.name = pName;
        }

        public TestObject374 getNested() {
            return this.nested;
        }

        public void setNested(TestObject374 pNested) {
            this.nested = pNested;
        }
    }

    public static class Var370 {
        private String name = null;

        public void setName(String s) {
            this.name = s;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Session322 {
        public User322 getUser() {
            return new User322();
        }
    }

    public static class User322 {
        public String getName() {
            return "user322";
        }
    }

    public static class VaContext
    extends MapContext {
        VaContext(Map<String, Object> vars) {
            super(vars);
        }

        public int cell(String ... ms) {
            return ms.length;
        }

        public int cell(List<?> l, String ... ms) {
            return 42 + this.cell(ms);
        }
    }
}

