/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class DoWhileTest
extends JexlTestCase {
    public DoWhileTest() {
        super("DoWhileTest");
    }

    @Test
    public void testSimpleWhileFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("do {} while (false)");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
        e = this.JEXL.createScript("do {} while (false); 23");
        o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)23, (Object)o);
    }

    @Test
    public void testWhileExecutesExpressionWhenLooping() throws Exception {
        JexlScript e = this.JEXL.createScript("do x = x + 1 while (x < 10)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)1);
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
        Assert.assertEquals((Object)10, (Object)jc.get("x"));
        e = this.JEXL.createScript("var x = 0; do x += 1; while (x < 23)");
        o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)23, (Object)o);
        jc.set("x", (Object)1);
        e = this.JEXL.createScript("do x += 1; while (x < 23); return 42;");
        o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)23, (Object)jc.get("x"));
        Assert.assertEquals((Object)42, (Object)o);
    }

    @Test
    public void testWhileWithBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("do { x = x + 1; y = y * 2; } while (x < 10)");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        jc.set("y", (Object)new Integer(1));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(512), (Object)o);
        Assert.assertEquals((String)"x is wrong", (Object)new Integer(10), (Object)jc.get("x"));
        Assert.assertEquals((String)"y is wrong", (Object)new Integer(512), (Object)jc.get("y"));
    }

    @Test
    public void testForEachBreakInsideFunction() throws Exception {
        try {
            JexlScript e = this.JEXL.createScript("for (i : 1..2) {  y = function() { break; } }");
            Assert.fail((String)"break is out of loop!");
        }
        catch (JexlException.Parsing xparse) {
            String str = xparse.detailedMessage();
            Assert.assertTrue((boolean)str.contains("break"));
        }
    }

    @Test
    public void testForEachContinueInsideFunction() throws Exception {
        try {
            JexlScript e = this.JEXL.createScript("for (i : 1..2) {  y = function() { continue; } }");
            Assert.fail((String)"continue is out of loop!");
        }
        catch (JexlException.Parsing xparse) {
            String str = xparse.detailedMessage();
            Assert.assertTrue((boolean)str.contains("continue"));
        }
    }

    @Test
    public void testForEachLambda() throws Exception {
        JexlScript e = this.JEXL.createScript("(x)->{ for (i : 1..2) {  continue; var y = function() { 42; } break; } }");
        Assert.assertNotNull((Object)e);
    }

    @Test
    public void testEmptyBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; do ; while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
    }

    @Test
    public void testEmptyStmtBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; do {} while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
    }

    @Test
    public void testWhileEmptyBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; while((i+=1) < 10); i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
    }

    @Test
    public void testWhileEmptyStmtBody() throws Exception {
        JexlScript e = this.JEXL.createScript("var i = 0; while((i+=1) < 10) {}; i");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((Object)10, (Object)o);
    }

    @Test
    public void testForLoop0() {
        String src = "(l)->{ for(let x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(src);
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }

    @Test
    public void testForLoop1() {
        String src = "(l)->{ for(var x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(src);
        ArrayList l = new ArrayList();
        Object result = script.execute(null, new Object[]{l});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }

    @Test
    public void testForLoop2() {
        String src = "(l)->{ for(x = 0; x < 4; ++x) { l.add(x); } }";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript(src);
        ArrayList l = new ArrayList();
        MapContext ctxt = new MapContext();
        Object result = script.execute((JexlContext)ctxt, new Object[]{l});
        Assert.assertNotNull((Object)result);
        Assert.assertEquals(Arrays.asList(0, 1, 2, 3), l);
    }
}

