/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.junit.Assert;
import org.junit.Test;

public class ContextNamespaceTest
extends JexlTestCase {
    static AtomicInteger nsnsCtor = new AtomicInteger(0);

    public ContextNamespaceTest() {
        super("ContextNamespaceTest");
    }

    @Test
    public void testThreadedContext() {
        JexlEngine jexl = new JexlBuilder().create();
        TaxesContext context = new TaxesContext(18.6);
        String strs = "taxes:vat(1000)";
        JexlScript staxes = jexl.createScript("taxes:vat(1000)");
        Object result = staxes.execute((JexlContext)context);
        Assert.assertEquals((Object)186.0, (Object)result);
    }

    @Test
    public void testNamespacePragma() {
        JexlEngine jexl = new JexlBuilder().create();
        TaxesContext context = new TaxesContext(18.6);
        String strs = "#pragma jexl.namespace.tax org.apache.commons.jexl3.ContextNamespaceTest$Taxes\ntax:vat(2000)";
        JexlScript staxes = jexl.createScript("#pragma jexl.namespace.tax org.apache.commons.jexl3.ContextNamespaceTest$Taxes\ntax:vat(2000)");
        Object result = staxes.execute((JexlContext)context);
        Assert.assertEquals((Object)372.0, (Object)result);
    }

    @Test
    public void testNamespace346a() {
        Context346 ctxt = new Context346();
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        String src = "x != null ? x : func(y)";
        JexlScript script = jexl.createScript(src, new String[]{"x", "y"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{null, 1});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{169, -169});
        Assert.assertEquals((Object)169, (Object)result);
    }

    @Test
    public void testNamespace346b() {
        MapContext ctxt = new MapContext();
        HashMap<String, Class<Math>> ns = new HashMap<String, Class<Math>>();
        ns.put("x", Math.class);
        ns.put(null, Math.class);
        JexlEngine jexl = new JexlBuilder().safe(false).namespaces(ns).create();
        String src = "x != null ? x : abs(y)";
        JexlScript script = jexl.createScript(src, new String[]{"x", "y"});
        Object result = script.execute((JexlContext)ctxt, new Object[]{null, 42});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute((JexlContext)ctxt, new Object[]{169, -169});
        Assert.assertEquals((Object)169, (Object)result);
    }

    @Test
    public void testNamespace348a() {
        MapContext ctxt = new MapContext();
        HashMap<String, Class<Ns348>> ns = new HashMap<String, Class<Ns348>>();
        ns.put("ns", Ns348.class);
        JexlEngine jexl = new JexlBuilder().safe(false).namespaces(ns).create();
        this.run348a(jexl, (JexlContext)ctxt);
        this.run348b(jexl, (JexlContext)ctxt);
        this.run348c(jexl, (JexlContext)ctxt);
        this.run348d(jexl, (JexlContext)ctxt);
    }

    @Test
    public void testNamespace348b() {
        ContextNs348 ctxt = new ContextNs348();
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        this.run348a(jexl, (JexlContext)ctxt, "ns:");
        this.run348b(jexl, (JexlContext)ctxt, "ns:");
        this.run348c(jexl, (JexlContext)ctxt, "ns:");
        this.run348d(jexl, (JexlContext)ctxt, "ns:");
    }

    @Test
    public void testNamespace348c() {
        ContextNs348 ctxt = new ContextNs348();
        HashMap<String, Class<Ns348>> ns = new HashMap<String, Class<Ns348>>();
        ns.put("ns", Ns348.class);
        JexlFeatures f = new JexlFeatures();
        f.namespaceTest(n -> true);
        JexlEngine jexl = new JexlBuilder().namespaces(ns).features(f).safe(false).create();
        this.run348a(jexl, (JexlContext)ctxt);
        this.run348b(jexl, (JexlContext)ctxt);
        this.run348c(jexl, (JexlContext)ctxt);
        this.run348d(jexl, (JexlContext)ctxt);
    }

    @Test
    public void testNamespace348d() {
        ContextNs348 ctxt = new ContextNs348();
        JexlFeatures f = new JexlFeatures();
        f.namespaceTest(n -> true);
        JexlEngine jexl = new JexlBuilder().features(f).safe(false).create();
        this.run348a(jexl, (JexlContext)ctxt);
        this.run348b(jexl, (JexlContext)ctxt);
        this.run348c(jexl, (JexlContext)ctxt);
        this.run348d(jexl, (JexlContext)ctxt);
    }

    private void run348a(JexlEngine jexl, JexlContext ctxt) {
        this.run348a(jexl, ctxt, "ns : ");
    }

    private void run348a(JexlEngine jexl, JexlContext ctxt, String ns) {
        String src = "empty(x) ? " + ns + "func(y) : z";
        JexlScript script = jexl.createScript(src, new String[]{"x", "y", "z"});
        Object result = script.execute(ctxt, new Object[]{null, 1, 169});
        Assert.assertEquals((Object)42, (Object)result);
        result = script.execute(ctxt, new Object[]{"42", 1, 169});
        Assert.assertEquals((Object)169, (Object)result);
    }

    private void run348b(JexlEngine jexl, JexlContext ctxt) {
        this.run348b(jexl, ctxt, "ns : ");
    }

    private void run348b(JexlEngine jexl, JexlContext ctxt, String ns) {
        String src = "empty(x) ? " + ns + "func(y) : z";
        JexlScript script = jexl.createScript(src);
        ctxt.set("x", null);
        ctxt.set("y", (Object)1);
        ctxt.set("z", (Object)169);
        Object result = script.execute(ctxt);
        Assert.assertEquals((Object)42, (Object)result);
        ctxt.set("x", (Object)"42");
        result = script.execute(ctxt);
        Assert.assertEquals((Object)169, (Object)result);
        result = script.execute(ctxt);
        Assert.assertEquals((Object)169, (Object)result);
    }

    private void run348c(JexlEngine jexl, JexlContext ctxt) {
        this.run348c(jexl, ctxt, "ns : ");
    }

    private void run348c(JexlEngine jexl, JexlContext ctxt, String ns) {
        String src = "empty(x) ? z : " + ns + "func(y)";
        JexlScript script = jexl.createScript(src, new String[]{"x", "z", "y"});
        Object result = script.execute(ctxt, new Object[]{null, 169, 1});
        Assert.assertEquals((String)src, (Object)169, (Object)result);
        result = script.execute(ctxt, new Object[]{"42", 169, 1});
        Assert.assertEquals((String)src, (Object)42, (Object)result);
    }

    private void run348d(JexlEngine jexl, JexlContext ctxt) {
        this.run348d(jexl, ctxt, "ns : ");
    }

    private void run348d(JexlEngine jexl, JexlContext ctxt, String ns) {
        String src = "empty(x) ? z : " + ns + "func(y)";
        JexlScript script = null;
        try {
            script = jexl.createScript(src);
        }
        catch (JexlException.Parsing xparse) {
            Assert.fail((String)src);
        }
        ctxt.set("x", null);
        ctxt.set("z", (Object)169);
        ctxt.set("y", (Object)1);
        Object result = script.execute(ctxt);
        Assert.assertEquals((String)src, (Object)169, (Object)result);
        ctxt.set("x", (Object)"42");
        result = script.execute(ctxt);
        Assert.assertEquals((String)src, (Object)42, (Object)result);
    }

    @Test
    public void testNamespacePragmaString() {
        JexlEngine jexl = new JexlBuilder().create();
        MapContext context = new MapContext();
        String strs = "#pragma jexl.namespace.str java.lang.String\nstr:format('%04d', 42)";
        JexlScript staxes = jexl.createScript("#pragma jexl.namespace.str java.lang.String\nstr:format('%04d', 42)");
        Object result = staxes.execute((JexlContext)context);
        Assert.assertEquals((Object)"0042", (Object)result);
    }

    @Test
    public void testObjectContext() {
        JexlEngine jexl = new JexlBuilder().strict(true).silent(false).create();
        Vat vat = new Vat(18.6);
        ObjectContext ctxt = new ObjectContext(jexl, (Object)vat);
        Assert.assertEquals((double)18.6, (double)((Double)ctxt.get("VAT")), (double)1.0E-4);
        ctxt.set("VAT", (Object)20.0);
        Assert.assertEquals((double)20.0, (double)((Double)ctxt.get("VAT")), (double)1.0E-4);
        try {
            ctxt.get("vat");
            Assert.fail((String)"should have failed");
        }
        catch (JexlException.Property property) {
            // empty catch block
        }
        try {
            ctxt.set("vat", (Object)33.0);
            Assert.fail((String)"should have failed");
        }
        catch (JexlException.Property property) {
            // empty catch block
        }
    }

    @Test
    public void testNsNsContext0() {
        nsnsCtor.set(0);
        String clsName = NsNs.class.getName();
        this.runNsNsContext(Collections.singletonMap("nsns", clsName));
    }

    @Test
    public void testNsNsContext1() {
        nsnsCtor.set(0);
        this.runNsNsContext(Collections.singletonMap("nsns", NsNs.class));
    }

    private void runNsNsContext(Map<String, Object> nsMap) {
        MapContext ctxt = new MapContext();
        ctxt.set("NUMBER", (Object)19);
        JexlEngine jexl = new JexlBuilder().strict(true).silent(false).cache(32).namespaces(nsMap).create();
        JexlScript script = jexl.createScript("x ->{ nsns:callIt(x); nsns:callIt(x); }");
        Number result = (Number)script.execute((JexlContext)ctxt, new Object[]{23});
        Assert.assertEquals((Object)42, (Object)result);
        Assert.assertEquals((long)1L, (long)nsnsCtor.get());
        result = (Number)script.execute((JexlContext)ctxt, new Object[]{623});
        Assert.assertEquals((Object)642, (Object)result);
        Assert.assertEquals((long)2L, (long)nsnsCtor.get());
    }

    @Test
    public void testStaticNs0() {
        this.runStaticNsContext(Collections.singletonMap("sns", StaticNs.class));
    }

    @Test
    public void testStaticNs1() {
        this.runStaticNsContext(Collections.singletonMap("sns", StaticNs.class.getName()));
    }

    private void runStaticNsContext(Map<String, Object> nsMap) {
        MapContext ctxt = new MapContext();
        JexlEngine jexl = new JexlBuilder().strict(true).silent(false).cache(32).namespaces(nsMap).create();
        JexlScript script = jexl.createScript("x ->{ sns:callIt(x); sns:callIt(x); }");
        Number result = (Number)script.execute((JexlContext)ctxt, new Object[]{23});
        Assert.assertEquals((Object)42, (Object)result);
        result = (Number)script.execute((JexlContext)ctxt, new Object[]{623});
        Assert.assertEquals((Object)642, (Object)result);
    }

    public static class StaticNs {
        private StaticNs() {
        }

        public static int callIt(int n) {
            return n + 19;
        }
    }

    public static class NsNs {
        private final int constVar;

        public NsNs(JexlContext ctxt) {
            nsnsCtor.incrementAndGet();
            Object n = ctxt.get("NUMBER");
            this.constVar = n instanceof Number ? ((Number)n).intValue() : -1;
        }

        public int callIt(int n) {
            return n + this.constVar;
        }
    }

    public static class Vat {
        private double vat;

        Vat(double vat) {
            this.vat = vat;
        }

        public double getVAT() {
            return this.vat;
        }

        public void setVAT(double vat) {
            this.vat = vat;
        }

        public double getvat() {
            throw new UnsupportedOperationException("no way");
        }

        public void setvat(double vat) {
            throw new UnsupportedOperationException("no way");
        }
    }

    public static class ContextNs348
    extends MapContext
    implements JexlContext.NamespaceResolver {
        ContextNs348() {
        }

        public Object resolveNamespace(String name) {
            return "ns".equals(name) ? new Ns348() : null;
        }
    }

    public static class Ns348 {
        public static int func(int y) {
            return 42 * y;
        }
    }

    public static class Context346
    extends MapContext {
        public int func(int y) {
            return 42 * y;
        }
    }

    public static class TaxesContext
    extends MapContext
    implements JexlContext.ThreadLocal,
    JexlContext.NamespaceResolver {
        private Taxes taxes = null;
        private final double vat;

        TaxesContext(double vat) {
            this.vat = vat;
        }

        public Object resolveNamespace(String name) {
            if ("taxes".equals(name)) {
                if (this.taxes == null) {
                    this.taxes = new Taxes(this.vat);
                }
                return this.taxes;
            }
            return null;
        }

        public double getVAT() {
            return this.vat;
        }
    }

    public static class Taxes {
        private final double vat;

        public Taxes(TaxesContext ctxt) {
            this.vat = ctxt.getVAT();
        }

        public Taxes(double d) {
            this.vat = d;
        }

        public double vat(double n) {
            return n * this.vat / 100.0;
        }
    }
}

