/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.internal.ArrayBuilder;
import org.apache.commons.jexl3.internal.MapBuilder;
import org.apache.commons.jexl3.internal.SetBuilder;
import org.junit.Assert;
import org.junit.Test;

public class CollectionLiteralTest
extends JexlTestCase {
    public CollectionLiteralTest() {
        super("CollectionLiteralTest");
    }

    @Test
    public void testMapLBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("{ 'x':(x)->{ 1 + x; }, 'y' : (y)->{ y - 1; } }");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assert.assertNotNull((Object)result);
            Assert.assertNotSame(previous, (Object)result);
            previous = result;
            Assert.assertEquals((long)(1 + i), (long)jc.maps.get());
        }
    }

    @Test
    public void testSetBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("{ (x)->{ 1 + x; }, (y)->{ y - 1; } }");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assert.assertNotNull((Object)result);
            Assert.assertNotSame(previous, (Object)result);
            previous = result;
            Assert.assertEquals((long)(1 + i), (long)jc.sets.get());
        }
    }

    @Test
    public void testArrayBuilder() {
        Arithmetic363 jc = new Arithmetic363(true);
        JexlEngine jexl = new JexlBuilder().cache(4).arithmetic((JexlArithmetic)jc).create();
        JexlScript script = jexl.createScript("[ (x)->{ 1 + x; }, (y)->{ y - 1; } ]");
        Object previous = null;
        for (int i = 0; i < 4; ++i) {
            Object result = script.execute(null);
            Assert.assertNotNull((Object)result);
            Assert.assertNotSame(previous, (Object)result);
            previous = result;
            Assert.assertEquals((long)(1 + i), (long)jc.arrays.get());
        }
    }

    static class CountingArrayBuilder
    extends ArrayBuilder {
        final AtomicInteger count;

        public CountingArrayBuilder(AtomicInteger ai, int size) {
            super(size);
            this.count = ai;
        }

        public Object create(boolean extended) {
            Object array = super.create(extended);
            this.count.incrementAndGet();
            return array;
        }
    }

    static class CountingMapBuilder
    extends MapBuilder {
        final AtomicInteger count;

        public CountingMapBuilder(AtomicInteger ai, int size) {
            super(size);
            this.count = ai;
        }

        public Map<Object, Object> create() {
            Map map = super.create();
            this.count.incrementAndGet();
            return map;
        }
    }

    static class CountingSetBuilder
    extends SetBuilder {
        final AtomicInteger count;

        public CountingSetBuilder(AtomicInteger ai, int size) {
            super(size);
            this.count = ai;
        }

        public Set<?> create() {
            Set set = super.create();
            this.count.incrementAndGet();
            return set;
        }
    }

    public static class Arithmetic363
    extends JexlArithmetic {
        final AtomicInteger maps = new AtomicInteger(0);
        final AtomicInteger sets = new AtomicInteger(0);
        final AtomicInteger arrays = new AtomicInteger(0);

        public Arithmetic363(boolean strict) {
            super(strict);
        }

        public JexlArithmetic.MapBuilder mapBuilder(int size) {
            return new CountingMapBuilder(this.maps, size);
        }

        public JexlArithmetic.SetBuilder setBuilder(int size) {
            return new CountingSetBuilder(this.sets, size);
        }

        public JexlArithmetic.ArrayBuilder arrayBuilder(int size) {
            return new CountingArrayBuilder(this.arrays, size);
        }
    }
}

