/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp2.datasources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.HashMap;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.TestConnectionPool;
import org.apache.commons.dbcp2.TesterDriver;
import org.apache.commons.dbcp2.cpdsadapter.DriverAdapterCPDS;
import org.apache.commons.dbcp2.datasources.PerUserPoolDataSource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPerUserPoolDataSource
extends TestConnectionPool {
    private static final Duration DURATION_1_MILLISECOND = Duration.ofMillis(1L);
    private String user;
    private DataSource ds;

    @Override
    protected Connection getConnection() throws SQLException {
        return this.ds.getConnection(this.user, "bar");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.user = "foo";
        DriverAdapterCPDS pcds = new DriverAdapterCPDS();
        pcds.setDriver("org.apache.commons.dbcp2.TesterDriver");
        pcds.setUrl("jdbc:apache:commons:testdriver");
        pcds.setUser(this.user);
        pcds.setPassword("bar");
        pcds.setAccessToUnderlyingConnectionAllowed(true);
        PerUserPoolDataSource tds = new PerUserPoolDataSource();
        tds.setConnectionPoolDataSource((ConnectionPoolDataSource)pcds);
        tds.setDefaultMaxTotal(this.getMaxTotal());
        tds.setDefaultMaxWait(this.getMaxWaitDuration());
        tds.setPerUserMaxTotal(this.user, Integer.valueOf(this.getMaxTotal()));
        tds.setPerUserMaxWait(this.user, this.getMaxWaitDuration());
        tds.setDefaultTransactionIsolation(2);
        tds.setDefaultAutoCommit(Boolean.TRUE);
        this.ds = tds;
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        ((PerUserPoolDataSource)this.ds).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangePassword() throws Exception {
        Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection(this.user, "bay"));
        Connection con1 = this.ds.getConnection(this.user, "bar");
        Connection con2 = this.ds.getConnection(this.user, "bar");
        Connection con3 = this.ds.getConnection(this.user, "bar");
        con1.close();
        con2.close();
        TesterDriver.addUser(this.user, "bay");
        try {
            Connection con4 = this.ds.getConnection(this.user, "bay");
            Assertions.assertEquals((int)0, (int)((PerUserPoolDataSource)this.ds).getNumIdle(this.user), (String)"Should be no idle connections in the pool");
            con4.close();
            Assertions.assertEquals((int)1, (int)((PerUserPoolDataSource)this.ds).getNumIdle(this.user), (String)"Should be one idle connection in the pool");
            try (Connection c2 = this.ds.getConnection(this.user, "bar");){
                Assertions.fail((String)"Should have generated SQLException");
            }
            catch (SQLException c2) {
                // empty catch block
            }
            Connection con5 = this.ds.getConnection(this.user, "bay");
            con3.close();
            this.ds.getConnection(this.user, "bay").close();
            Assertions.assertEquals((int)1, (int)((PerUserPoolDataSource)this.ds).getNumIdle(this.user), (String)"Should be one idle connection in the pool");
            con5.close();
        }
        finally {
            TesterDriver.addUser(this.user, "bar");
        }
    }

    @Override
    @Test
    public void testClosing() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection();
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testClosingWithUserName() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        c[0].close();
        Assertions.assertTrue((boolean)c[0].isClosed());
        c[0] = this.ds.getConnection("u1", "p1");
        for (Connection element : c) {
            element.close();
        }
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection("u1", "p1");
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testDefaultUser1() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"mkh", "hanafey", "jsmith"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], "password");
            Assertions.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    @Test
    public void testDefaultUser2() throws Exception {
        int i;
        TesterDriver.addUser("mkh", "password");
        TesterDriver.addUser("hanafey", "password");
        TesterDriver.addUser("jsmith", "password");
        PerUserPoolDataSource puds = (PerUserPoolDataSource)this.ds;
        puds.setPerUserMaxTotal("jsmith", Integer.valueOf(2));
        String[] users = new String[]{"jsmith", "hanafey", "mkh"};
        String password = "password";
        Connection[] c = new Connection[users.length];
        for (i = 0; i < users.length; ++i) {
            c[i] = puds.getConnection(users[i], "password");
            Assertions.assertEquals((Object)users[i], (Object)this.getUsername(c[i]));
        }
        for (i = 0; i < users.length; ++i) {
            c[i].close();
        }
    }

    @Test
    public void testDepreactedAccessors() {
        try (PerUserPoolDataSource ds = new PerUserPoolDataSource();){
            int i = 0;
            ds.setDefaultMaxWaitMillis((long)(++i));
            Assertions.assertEquals((long)i, (long)ds.getDefaultMaxWaitMillis());
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getDefaultMaxWait());
            ds.setDefaultMinEvictableIdleTimeMillis((long)(++i));
            Assertions.assertEquals((long)i, (long)ds.getDefaultMinEvictableIdleTimeMillis());
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getDefaultMinEvictableIdleDuration());
            ds.setDefaultSoftMinEvictableIdleTimeMillis((long)(++i));
            Assertions.assertEquals((long)i, (long)ds.getDefaultSoftMinEvictableIdleTimeMillis());
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getDefaultSoftMinEvictableIdleDuration());
            ds.setDefaultTimeBetweenEvictionRunsMillis((long)(++i));
            Assertions.assertEquals((long)i, (long)ds.getDefaultTimeBetweenEvictionRunsMillis());
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getDefaultDurationBetweenEvictionRuns());
            ds.setPerUserMaxWaitMillis(this.user, Long.valueOf(++i));
            Assertions.assertEquals((long)i, (long)ds.getPerUserMaxWaitMillis(this.user));
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getPerUserMaxWaitDuration(this.user));
            ds.setPerUserMinEvictableIdleTimeMillis(this.user, Long.valueOf(++i));
            Assertions.assertEquals((long)i, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getPerUserMinEvictableIdleDuration(this.user));
            ds.setPerUserSoftMinEvictableIdleTimeMillis(this.user, Long.valueOf(++i));
            Assertions.assertEquals((long)i, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getPerUserSoftMinEvictableIdleDuration(this.user));
            ds.setPerUserTimeBetweenEvictionRunsMillis(this.user, Long.valueOf(++i));
            Assertions.assertEquals((long)i, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
            Assertions.assertEquals((Object)Duration.ofMillis(i), (Object)ds.getPerUserDurationBetweenEvictionRuns(this.user));
        }
    }

    @Test
    public void testIncorrectPassword() throws SQLException {
        block8: {
            Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection("u1", "zlsafjk"));
            this.ds.getConnection("u1", "p1").close();
            try (Connection c = this.ds.getConnection("u1", "x");){
                Assertions.fail((String)"Able to retrieve connection with incorrect password");
            }
            catch (SQLException e) {
                if (e.getMessage().startsWith("Given password did not match")) break block8;
                throw e;
            }
        }
        this.ds.getConnection("u1", "p1").close();
        this.ds.getConnection(this.user, "bar").close();
        Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection("foob", "ar"));
        Assertions.assertThrows(SQLException.class, () -> this.ds.getConnection(this.user, "baz"));
    }

    @Override
    @Test
    public void testMaxTotal() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assertions.assertNotNull((Object)c[i]);
        }
        try (Connection conn = this.ds.getConnection();){
            Assertions.fail((String)"Allowed to open more than DefaultMaxTotal connections.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testMaxWaitMillisZero() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setDefaultMaxWait(Duration.ZERO);
        tds.setPerUserMaxTotal("u1", Integer.valueOf(1));
        try (Connection conn = tds.getConnection("u1", "p1");){
            Assertions.assertThrows(SQLException.class, () -> tds.getConnection("u1", "p1"));
        }
    }

    @Test
    public void testMultipleThreads1() throws Exception {
        Duration defaultMaxWaitDuration = Duration.ofMillis(430L);
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWait(defaultMaxWaitDuration);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWait(this.user, defaultMaxWaitDuration);
        this.multipleThreads(Duration.ofMillis(1L), false, false, defaultMaxWaitDuration);
    }

    @Test
    public void testMultipleThreads2() throws Exception {
        Duration defaultMaxWaitDuration = Duration.ofMillis(500L);
        ((PerUserPoolDataSource)this.ds).setDefaultMaxWait(defaultMaxWaitDuration);
        ((PerUserPoolDataSource)this.ds).setPerUserMaxWait(this.user, defaultMaxWaitDuration);
        this.multipleThreads(defaultMaxWaitDuration.multipliedBy(2L), true, true, defaultMaxWaitDuration);
    }

    @Override
    @Test
    public void testOpening() throws Exception {
        Connection[] c = new Connection[this.getMaxTotal()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = this.ds.getConnection();
            Assertions.assertNotNull((Object)c[i]);
            for (int j = 0; j <= i; ++j) {
                Assertions.assertFalse((boolean)c[j].isClosed());
            }
        }
        for (Connection element : c) {
            element.close();
        }
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("key"));
        userDefaultBlockWhenExhausted = new HashMap();
        userDefaultBlockWhenExhausted.put("anonymous", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("anonymous"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.TRUE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("key"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> userDefaultBlockWhenExhausted = new HashMap<String, Boolean>();
        userDefaultBlockWhenExhausted.put("key", Boolean.FALSE);
        ds.setPerUserBlockWhenExhausted(userDefaultBlockWhenExhausted);
        Assertions.assertEquals((Object)ds.getDefaultBlockWhenExhausted(), (Object)ds.getPerUserBlockWhenExhausted("missingkey"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
        ds.setPerUserBlockWhenExhausted("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted("anotheruser"));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserBlockWhenExhausted(this.user));
    }

    @Test
    public void testPerUserBlockWhenExhaustedWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserBlockWhenExhausted("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserBlockWhenExhausted("missingkey"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultAutoCommit("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("anonymous"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserDefaultAutoCommit(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserDefaultAutoCommit("key"));
    }

    @Test
    public void testPerUserDefaultAutoCommitMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultAutoCommit(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultAutoCommit("missingkey"));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
        ds.setPerUserDefaultAutoCommit("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit("anotheruser"));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultAutoCommit(this.user));
    }

    @Test
    public void testPerUserDefaultAutoCommitWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultAutoCommit("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertNull((Object)ds.getPerUserDefaultAutoCommit("missingkey"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultReadOnly("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("anonymous"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserDefaultReadOnly(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserDefaultReadOnly("key"));
    }

    @Test
    public void testPerUserDefaultReadOnlyMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserDefaultReadOnly(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultReadOnly("missingkey"));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
        ds.setPerUserDefaultReadOnly("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly("anotheruser"));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserDefaultReadOnly(this.user));
    }

    @Test
    public void testPerUserDefaultReadOnlyWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultReadOnly("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertNull((Object)ds.getPerUserDefaultReadOnly("missingkey"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultTransactionIsolation("key"));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation("anonymous"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assertions.assertEquals((Integer)1, (Integer)ds.getPerUserDefaultTransactionIsolation("key"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserDefaultTransactionIsolation(values);
        Assertions.assertNull((Object)ds.getPerUserDefaultTransactionIsolation("missingkey"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation(this.user));
        ds.setPerUserDefaultTransactionIsolation("anotheruser", Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation(this.user));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation("anotheruser"));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserDefaultTransactionIsolation(this.user));
    }

    @Test
    public void testPerUserDefaultTransactionIsolationWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserDefaultTransactionIsolation("whatismyuseragain?", Integer.valueOf(0));
        Assertions.assertNull((Object)ds.getPerUserDefaultTransactionIsolation("missingkey"));
    }

    @Test
    public void testPerUserDurationBetweenEvictionRunsMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserDurationBetweenEvictionRuns(values);
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserDurationBetweenEvictionRuns("key"));
        values = new HashMap();
        values.put("anonymous", Duration.ZERO);
        ds.setPerUserDurationBetweenEvictionRuns(values);
        Assertions.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
        Assertions.assertEquals((Object)ds.getDefaultDurationBetweenEvictionRuns(), (Object)ds.getPerUserDurationBetweenEvictionRuns("key"));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("anonymous"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserDurationBetweenEvictionRuns("anonymous"));
    }

    @Test
    public void testPerUserDurationBetweenEvictionRunsMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", DURATION_1_MILLISECOND);
        ds.setPerUserDurationBetweenEvictionRuns(values);
        Assertions.assertEquals((long)1L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("key"));
        Assertions.assertEquals((Object)DURATION_1_MILLISECOND, (Object)ds.getPerUserDurationBetweenEvictionRuns("key"));
    }

    @Test
    public void testPerUserDurationBetweenEvictionRunsMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserDurationBetweenEvictionRuns(values);
        Assertions.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("missingkey"));
        Assertions.assertEquals((Object)ds.getDefaultDurationBetweenEvictionRuns(), (Object)ds.getPerUserDurationBetweenEvictionRuns("missingkey"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("key"));
        values = new HashMap();
        values.put("anonymous", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assertions.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("key"));
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("anonymous"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "test");
        ds.setPerUserEvictionPolicyClassName(values);
        Assertions.assertEquals((Object)"test", (Object)ds.getPerUserEvictionPolicyClassName("key"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("key", "bar");
        ds.setPerUserEvictionPolicyClassName(values);
        Assertions.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("missingkey"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName(this.user, "bar");
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
        ds.setPerUserEvictionPolicyClassName("anotheruser", "bar");
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName("anotheruser"));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName(this.user, "bar");
        Assertions.assertEquals((Object)"bar", (Object)ds.getPerUserEvictionPolicyClassName(this.user));
    }

    @Test
    public void testPerUserEvictionPolicyClassNameWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserEvictionPolicyClassName("whatismyuseragain?", "bar");
        Assertions.assertEquals((Object)ds.getDefaultEvictionPolicyClassName(), (Object)ds.getPerUserEvictionPolicyClassName("missingkey"));
    }

    @Test
    public void testPerUserLifoMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assertions.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("anonymous"));
    }

    @Test
    public void testPerUserLifoMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserLifo(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserLifo("key"));
    }

    @Test
    public void testPerUserLifoMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserLifo(values);
        Assertions.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("missingkey"));
    }

    @Test
    public void testPerUserLifoWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
        ds.setPerUserLifo("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo("anotheruser"));
    }

    @Test
    public void testPerUserLifoWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserLifo(this.user));
    }

    @Test
    public void testPerUserLifoWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserLifo("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)ds.getDefaultLifo(), (Object)ds.getPerUserLifo("missingkey"));
    }

    @Test
    public void testPerUserMaxIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxIdle(values);
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMaxIdle(values);
        Assertions.assertEquals((Integer)ds.getDefaultMaxIdle(), (Integer)ds.getPerUserMaxIdle("key"));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle("anonymous"));
    }

    @Test
    public void testPerUserMaxIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMaxIdle(values);
        Assertions.assertEquals((Integer)1, (Integer)ds.getPerUserMaxIdle("key"));
    }

    @Test
    public void testPerUserMaxIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxIdle(values);
        Assertions.assertEquals((Integer)ds.getDefaultMaxIdle(), (Integer)ds.getPerUserMaxIdle("missingkey"));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle(this.user));
        ds.setPerUserMaxIdle("anotheruser", Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle(this.user));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle("anotheruser"));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxIdle(this.user));
    }

    @Test
    public void testPerUserMaxIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxIdle("whatismyuseragain?", Integer.valueOf(0));
        Assertions.assertEquals((Integer)ds.getDefaultMaxIdle(), (Integer)ds.getPerUserMaxIdle("missingkey"));
    }

    @Test
    public void testPerUserMaxTotalMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxTotal(values);
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMaxTotal(values);
        Assertions.assertEquals((Integer)ds.getDefaultMaxTotal(), (Integer)ds.getPerUserMaxTotal("key"));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal("anonymous"));
    }

    @Test
    public void testPerUserMaxTotalMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMaxTotal(values);
        Assertions.assertEquals((Integer)1, (Integer)ds.getPerUserMaxTotal("key"));
    }

    @Test
    public void testPerUserMaxTotalMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMaxTotal(values);
        Assertions.assertEquals((Integer)ds.getDefaultMaxTotal(), (Integer)ds.getPerUserMaxTotal("missingkey"));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal(this.user));
        ds.setPerUserMaxTotal("anotheruser", Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal(this.user));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal("anotheruser"));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMaxTotal(this.user));
    }

    @Test
    public void testPerUserMaxTotalWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxTotal("whatismyuseragain?", Integer.valueOf(0));
        Assertions.assertEquals((Integer)ds.getDefaultMaxTotal(), (Integer)ds.getPerUserMaxTotal("missingkey"));
    }

    @Test
    public void testPerUserMaxWaitDurationMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserMaxWaitDuration(values);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserMaxWaitDuration("key"));
        values = new HashMap();
        values.put("anonymous", Duration.ZERO);
        ds.setPerUserMaxWaitDuration(values);
        Assertions.assertEquals((Object)ds.getDefaultMaxWait(), (Object)ds.getPerUserMaxWaitDuration("key"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserMaxWaitDuration("anonymous"));
    }

    @Test
    public void testPerUserMaxWaitDurationMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", DURATION_1_MILLISECOND);
        ds.setPerUserMaxWaitDuration(values);
        Assertions.assertEquals((Object)DURATION_1_MILLISECOND, (Object)ds.getPerUserMaxWaitDuration("key"));
    }

    @Test
    public void testPerUserMaxWaitDurationMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserMaxWaitDuration(values);
        Assertions.assertEquals((Object)ds.getDefaultMaxWait(), (Object)ds.getPerUserMaxWaitDuration("missingkey"));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapInitialized_Deprecated() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
        ds.setPerUserMaxWaitMillis("anotheruser", Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis("anotheruser"));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapNotInitialized_Deprecated() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMaxWaitMillis(this.user));
    }

    @Test
    public void testPerUserMaxWaitMillisWithUserMapNotInitializedMissingKey_Deprecated() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMaxWaitMillis("whatismyuseragain?", Long.valueOf(0L));
        Assertions.assertEquals((long)ds.getDefaultMaxWaitMillis(), (long)ds.getPerUserMaxWaitMillis("missingkey"));
    }

    @Test
    public void testPerUserMethods() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        tds.setPerUserMaxTotal("u1", Integer.valueOf(5));
        tds.setPerUserMaxTotal("u2", Integer.valueOf(5));
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u2"));
        Assertions.assertEquals((int)0, (int)tds.getNumIdle());
        Assertions.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        try (Connection conn = tds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)1, (int)tds.getNumActive());
            Assertions.assertEquals((int)0, (int)tds.getNumActive("u1"));
            Assertions.assertEquals((int)0, (int)tds.getNumActive("u2"));
            Assertions.assertEquals((int)0, (int)tds.getNumIdle());
            Assertions.assertEquals((int)0, (int)tds.getNumIdle("u1"));
            Assertions.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        }
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u2"));
        Assertions.assertEquals((int)1, (int)tds.getNumIdle());
        Assertions.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        conn = tds.getConnection("u1", "p1");
        try {
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)0, (int)tds.getNumActive());
            Assertions.assertEquals((int)1, (int)tds.getNumActive("u1"));
            Assertions.assertEquals((int)0, (int)tds.getNumActive("u2"));
            Assertions.assertEquals((int)1, (int)tds.getNumIdle());
            Assertions.assertEquals((int)0, (int)tds.getNumIdle("u1"));
            Assertions.assertEquals((int)0, (int)tds.getNumIdle("u2"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u2"));
        Assertions.assertEquals((int)1, (int)tds.getNumIdle());
        Assertions.assertEquals((int)1, (int)tds.getNumIdle("u1"));
        Assertions.assertEquals((int)0, (int)tds.getNumIdle("u2"));
    }

    @Test
    public void testPerUserMinEvictableIdleDurationMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserMinEvictableIdle(values);
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserMinEvictableIdleDuration("key"));
        values = new HashMap();
        values.put("anonymous", Duration.ZERO);
        ds.setPerUserMinEvictableIdle(values);
        Assertions.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)ds.getDefaultMinEvictableIdleDuration(), (Object)ds.getPerUserMinEvictableIdleDuration("key"));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("anonymous"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserMinEvictableIdleDuration("anonymous"));
    }

    @Test
    public void testPerUserMinEvictableIdleDurationMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", DURATION_1_MILLISECOND);
        ds.setPerUserMinEvictableIdle(values);
        Assertions.assertEquals((long)1L, (long)ds.getPerUserMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)DURATION_1_MILLISECOND, (Object)ds.getPerUserMinEvictableIdleDuration("key"));
    }

    @Test
    public void testPerUserMinEvictableIdleDurationMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserMinEvictableIdle(values);
        Assertions.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("missingkey"));
        Assertions.assertEquals((Object)ds.getDefaultMinEvictableIdleDuration(), (Object)ds.getPerUserMinEvictableIdleDuration("missingkey"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
        ds.setPerUserMinEvictableIdleTimeMillis("anotheruser", Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis("anotheruser"));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserMinEvictableIdleTimeMillis(this.user));
    }

    @Test
    public void testPerUserMinEvictableIdleTimeMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinEvictableIdleTimeMillis("whatismyuseragain?", Long.valueOf(0L));
        Assertions.assertEquals((long)ds.getDefaultMinEvictableIdleTimeMillis(), (long)ds.getPerUserMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserMinIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMinIdle(values);
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserMinIdle(values);
        Assertions.assertEquals((Integer)ds.getDefaultMinIdle(), (Integer)ds.getPerUserMinIdle("key"));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle("anonymous"));
    }

    @Test
    public void testPerUserMinIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserMinIdle(values);
        Assertions.assertEquals((Integer)1, (Integer)ds.getPerUserMinIdle("key"));
    }

    @Test
    public void testPerUserMinIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserMinIdle(values);
        Assertions.assertEquals((Integer)ds.getDefaultMinIdle(), (Integer)ds.getPerUserMinIdle("missingkey"));
    }

    @Test
    public void testPerUserMinIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle(this.user));
        ds.setPerUserMinIdle("anotheruser", Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle(this.user));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle("anotheruser"));
    }

    @Test
    public void testPerUserMinIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserMinIdle(this.user));
    }

    @Test
    public void testPerUserMinIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserMinIdle("whatismyuseragain?", Integer.valueOf(0));
        Assertions.assertEquals((Integer)ds.getDefaultMinIdle(), (Integer)ds.getPerUserMinIdle("missingkey"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun("key"));
        values = new HashMap();
        values.put("anonymous", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assertions.assertEquals((Integer)ds.getDefaultNumTestsPerEvictionRun(), (Integer)ds.getPerUserNumTestsPerEvictionRun("key"));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun("anonymous"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 1);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assertions.assertEquals((Integer)1, (Integer)ds.getPerUserNumTestsPerEvictionRun("key"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("key", 0);
        ds.setPerUserNumTestsPerEvictionRun(values);
        Assertions.assertEquals((Integer)ds.getDefaultNumTestsPerEvictionRun(), (Integer)ds.getPerUserNumTestsPerEvictionRun("missingkey"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun(this.user));
        ds.setPerUserNumTestsPerEvictionRun("anotheruser", Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun(this.user));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun("anotheruser"));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun(this.user, Integer.valueOf(0));
        Assertions.assertEquals((Integer)0, (Integer)ds.getPerUserNumTestsPerEvictionRun(this.user));
    }

    @Test
    public void testPerUserNumTestsPerEvictionRunWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserNumTestsPerEvictionRun("whatismyuseragain?", Integer.valueOf(0));
        Assertions.assertEquals((Integer)ds.getDefaultNumTestsPerEvictionRun(), (Integer)ds.getPerUserNumTestsPerEvictionRun("missingkey"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleDurationMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserSoftMinEvictableIdle(values);
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserSoftMinEvictableIdleDuration("key"));
        values = new HashMap();
        values.put("anonymous", Duration.ZERO);
        ds.setPerUserSoftMinEvictableIdle(values);
        Assertions.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)ds.getDefaultSoftMinEvictableIdleDuration(), (Object)ds.getPerUserSoftMinEvictableIdleDuration("key"));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("anonymous"));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)ds.getPerUserSoftMinEvictableIdleDuration("anonymous"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleDurationMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", DURATION_1_MILLISECOND);
        ds.setPerUserSoftMinEvictableIdle(values);
        Assertions.assertEquals((long)1L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("key"));
        Assertions.assertEquals((Object)DURATION_1_MILLISECOND, (Object)ds.getPerUserSoftMinEvictableIdleDuration("key"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleDurationMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Duration> values = new HashMap<String, Duration>();
        values.put("key", Duration.ZERO);
        ds.setPerUserSoftMinEvictableIdle(values);
        Assertions.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("missingkey"));
        Assertions.assertEquals((Object)ds.getDefaultSoftMinEvictableIdleDuration(), (Object)ds.getPerUserSoftMinEvictableIdleDuration("missingkey"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
        ds.setPerUserSoftMinEvictableIdleTimeMillis("anotheruser", Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("anotheruser"));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserSoftMinEvictableIdleTimeMillis(this.user));
    }

    @Test
    public void testPerUserSoftMinEvictableIdleTimeMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserSoftMinEvictableIdleTimeMillis("whatismyuseragain?", Long.valueOf(0L));
        Assertions.assertEquals((long)ds.getDefaultSoftMinEvictableIdleTimeMillis(), (long)ds.getPerUserSoftMinEvictableIdleTimeMillis("missingkey"));
    }

    @Test
    public void testPerUserTestOnBorrowMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("anonymous"));
    }

    @Test
    public void testPerUserTestOnBorrowMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnBorrow(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnBorrow("key"));
    }

    @Test
    public void testPerUserTestOnBorrowMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnBorrow(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("missingkey"));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
        ds.setPerUserTestOnBorrow("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow("anotheruser"));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnBorrow(this.user));
    }

    @Test
    public void testPerUserTestOnBorrowWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnBorrow("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)ds.getDefaultTestOnBorrow(), (Object)ds.getPerUserTestOnBorrow("missingkey"));
    }

    @Test
    public void testPerUserTestOnCreateMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("anonymous"));
    }

    @Test
    public void testPerUserTestOnCreateMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnCreate(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnCreate("key"));
    }

    @Test
    public void testPerUserTestOnCreateMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnCreate(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("missingkey"));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
        ds.setPerUserTestOnCreate("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate("anotheruser"));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnCreate(this.user));
    }

    @Test
    public void testPerUserTestOnCreateWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnCreate("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)ds.getDefaultTestOnCreate(), (Object)ds.getPerUserTestOnCreate("missingkey"));
    }

    @Test
    public void testPerUserTestOnReturnMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("anonymous"));
    }

    @Test
    public void testPerUserTestOnReturnMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestOnReturn(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestOnReturn("key"));
    }

    @Test
    public void testPerUserTestOnReturnMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestOnReturn(values);
        Assertions.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("missingkey"));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
        ds.setPerUserTestOnReturn("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn("anotheruser"));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestOnReturn(this.user));
    }

    @Test
    public void testPerUserTestOnReturnWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestOnReturn("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)ds.getDefaultTestOnReturn(), (Object)ds.getPerUserTestOnReturn("missingkey"));
    }

    @Test
    public void testPerUserTestWhileIdleMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("key"));
        values = new HashMap();
        values.put("anonymous", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assertions.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("key"));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("anonymous"));
    }

    @Test
    public void testPerUserTestWhileIdleMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.TRUE);
        ds.setPerUserTestWhileIdle(values);
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ds.getPerUserTestWhileIdle("key"));
    }

    @Test
    public void testPerUserTestWhileIdleMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.put("key", Boolean.FALSE);
        ds.setPerUserTestWhileIdle(values);
        Assertions.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("missingkey"));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
        ds.setPerUserTestWhileIdle("anotheruser", Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle("anotheruser"));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle(this.user, Boolean.FALSE);
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ds.getPerUserTestWhileIdle(this.user));
    }

    @Test
    public void testPerUserTestWhileIdleWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTestWhileIdle("whatismyuseragain?", Boolean.FALSE);
        Assertions.assertEquals((Object)ds.getDefaultTestWhileIdle(), (Object)ds.getPerUserTestWhileIdle("missingkey"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
        ds.setPerUserTimeBetweenEvictionRunsMillis("anotheruser", Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis("anotheruser"));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapNotInitialized() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis(this.user, Long.valueOf(0L));
        Assertions.assertEquals((long)0L, (long)ds.getPerUserTimeBetweenEvictionRunsMillis(this.user));
    }

    @Test
    public void testPerUserTimeBetweenEvictionRunsMillisWithUserMapNotInitializedMissingKey() {
        PerUserPoolDataSource ds = (PerUserPoolDataSource)this.ds;
        ds.setPerUserTimeBetweenEvictionRunsMillis("whatismyuseragain?", Long.valueOf(0L));
        Assertions.assertEquals((long)ds.getDefaultTimeBetweenEvictionRunsMillis(), (long)ds.getPerUserTimeBetweenEvictionRunsMillis("missingkey"));
    }

    @Test
    public void testSerialization() throws Exception {
        Connection conn = this.ds.getConnection();
        conn.close();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.ds);
        out.close();
        byte[] b = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(bais);
        Object obj = in.readObject();
        in.close();
        Assertions.assertEquals((int)1, (int)((PerUserPoolDataSource)obj).getNumIdle());
    }

    @Override
    @Test
    public void testSimple() throws Exception {
        try (Connection conn = this.ds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Override
    @Test
    public void testSimple2() throws Exception {
        Connection conn = this.ds.getConnection();
        Assertions.assertNotNull((Object)conn);
        PreparedStatement stmt = conn.prepareStatement("select * from dual");
        Assertions.assertNotNull((Object)stmt);
        ResultSet rset = stmt.executeQuery();
        Assertions.assertNotNull((Object)rset);
        Assertions.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assertions.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assertions.assertNotNull((Object)rset);
        Assertions.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        try (Statement s = conn.createStatement();){
            Assertions.fail((String)"Can't use closed connections");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = this.ds.getConnection();
        Assertions.assertNotNull((Object)conn);
        stmt = conn.prepareStatement("select * from dual");
        Assertions.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assertions.assertNotNull((Object)rset);
        Assertions.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        stmt = conn.prepareStatement("select * from dual");
        Assertions.assertNotNull((Object)stmt);
        rset = stmt.executeQuery();
        Assertions.assertNotNull((Object)rset);
        Assertions.assertTrue((boolean)rset.next());
        rset.close();
        stmt.close();
        conn.close();
        conn = null;
    }

    @Test
    public void testSimpleWithUsername() throws Exception {
        try (Connection conn = this.ds.getConnection("u1", "p1");){
            Assertions.assertNotNull((Object)conn);
            try (PreparedStatement stmt = conn.prepareStatement("select * from dual");){
                Assertions.assertNotNull((Object)stmt);
                try (ResultSet rset = stmt.executeQuery();){
                    Assertions.assertNotNull((Object)rset);
                    Assertions.assertTrue((boolean)rset.next());
                }
            }
        }
    }

    @Test
    public void testTransactionIsolationBehavior() throws Exception {
        try (Connection conn = this.getConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)2, (int)conn.getTransactionIsolation());
            conn.setTransactionIsolation(1);
        }
        Connection conn2 = this.getConnection();
        Assertions.assertEquals((int)2, (int)conn2.getTransactionIsolation());
        Connection conn3 = this.getConnection();
        Assertions.assertEquals((int)2, (int)conn3.getTransactionIsolation());
        conn2.close();
        conn3.close();
    }

    @Test
    public void testUnregisteredUser() throws Exception {
        PerUserPoolDataSource tds = (PerUserPoolDataSource)this.ds;
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)0, (int)tds.getNumIdle());
        try (Connection conn = tds.getConnection();){
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)1, (int)tds.getNumActive());
            Assertions.assertEquals((int)0, (int)tds.getNumIdle());
        }
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)1, (int)tds.getNumIdle());
        conn = tds.getConnection("u1", "p1");
        try {
            Assertions.assertNotNull((Object)conn);
            Assertions.assertEquals((int)0, (int)tds.getNumActive());
            Assertions.assertEquals((int)1, (int)tds.getNumIdle());
            Assertions.assertEquals((int)1, (int)tds.getNumActive("u1"));
            Assertions.assertEquals((int)0, (int)tds.getNumIdle("u1"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        Assertions.assertEquals((int)0, (int)tds.getNumActive());
        Assertions.assertEquals((int)1, (int)tds.getNumIdle());
        Assertions.assertEquals((int)0, (int)tds.getNumActive("u1"));
        Assertions.assertEquals((int)1, (int)tds.getNumIdle("u1"));
    }
}

