/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.QueryResult;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestQueryResult {
    private static final String ATTR = "testAttribute";
    private static final Object VALUE = "Value of my attribute";
    private static ImmutableNode resultNode;
    private static ImmutableNode attributeNode;

    @BeforeAll
    public static void setUpBeforeClass() {
        resultNode = new ImmutableNode.Builder().name("resultNode").value((Object)42).create();
        attributeNode = new ImmutableNode.Builder().name("attributeNode").addAttribute(ATTR, VALUE).create();
    }

    @Test
    public void testEqualsFalse() {
        QueryResult nodeRes = QueryResult.createNodeResult((Object)resultNode);
        QueryResult attrRes = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        ConfigurationAssert.checkEquals(nodeRes, attrRes, false);
        QueryResult res = QueryResult.createNodeResult((Object)attributeNode);
        ConfigurationAssert.checkEquals(nodeRes, res, false);
        res = QueryResult.createAttributeResult((Object)attributeNode, (String)"otherAttr");
        ConfigurationAssert.checkEquals(attrRes, res, false);
        res = QueryResult.createAttributeResult((Object)resultNode, (String)ATTR);
        ConfigurationAssert.checkEquals(attrRes, res, false);
    }

    @Test
    public void testEqualsOtherObjects() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(result, null, false);
        ConfigurationAssert.checkEquals(result, this, false);
    }

    @Test
    public void testEqualsTrue() {
        QueryResult r1 = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(r1, r1, true);
        QueryResult r2 = QueryResult.createNodeResult((Object)resultNode);
        ConfigurationAssert.checkEquals(r1, r2, true);
        r1 = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        r2 = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        ConfigurationAssert.checkEquals(r1, r2, true);
    }

    @Test
    public void testGetAttributeValue() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        Assertions.assertEquals((Object)VALUE, (Object)result.getAttributeValue(new InMemoryNodeModel().getNodeHandler()));
    }

    @Test
    public void testGetAttributeValueNoAttributeResult() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        NodeHandler nodeHandler = new InMemoryNodeModel().getNodeHandler();
        Assertions.assertThrows(IllegalStateException.class, () -> result.getAttributeValue(nodeHandler));
    }

    @Test
    public void testIsAttributeResultFalse() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        Assertions.assertFalse((boolean)result.isAttributeResult());
    }

    @Test
    public void testIsAttributeResultTrue() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        Assertions.assertTrue((boolean)result.isAttributeResult());
    }

    @Test
    public void testToStringAttributeResult() {
        QueryResult result = QueryResult.createAttributeResult((Object)attributeNode, (String)ATTR);
        String s = result.toString();
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)"attribute=testAttribute"));
        MatcherAssert.assertThat((Object)s, (Matcher)CoreMatchers.containsString((String)("parentNode=" + attributeNode)));
    }

    @Test
    public void testToStringNodeResult() {
        QueryResult result = QueryResult.createNodeResult((Object)resultNode);
        MatcherAssert.assertThat((Object)result.toString(), (Matcher)CoreMatchers.containsString((String)("resultNode=" + resultNode)));
    }
}

