/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.NodeAddData;
import org.apache.commons.configuration2.tree.NodeHandler;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDefaultExpressionEngine {
    private static final String[] tables = new String[]{"users", "documents"};
    private static final String[] tabTypes = new String[]{"system", "application"};
    private static final String[][] fields = new String[][]{{"uid", "uname", "firstName", "lastName", "email"}, {"docid", "name", "creationDate", "authorID", "version"}};
    private static ImmutableNode root;
    private static NodeHandler<ImmutableNode> handler;
    private DefaultExpressionEngine engine;

    private static ImmutableNode createFieldNode(String name) {
        ImmutableNode.Builder nodeFieldBuilder = new ImmutableNode.Builder(1);
        nodeFieldBuilder.addChild(TestDefaultExpressionEngine.createNode("name", name));
        return nodeFieldBuilder.name("field").create();
    }

    private static ImmutableNode createNode(String name, Object value) {
        return new ImmutableNode.Builder().name(name).value(value).create();
    }

    @BeforeAll
    public static void setUpBeforeClass() {
        root = TestDefaultExpressionEngine.setUpNodes();
        handler = new InMemoryNodeModel(root).getNodeHandler();
    }

    private static ImmutableNode setUpNodes() {
        ImmutableNode.Builder nodeTablesBuilder = new ImmutableNode.Builder(tables.length);
        nodeTablesBuilder.name("tables");
        for (int i = 0; i < tables.length; ++i) {
            ImmutableNode.Builder nodeTableBuilder = new ImmutableNode.Builder(2);
            nodeTableBuilder.name("table");
            nodeTableBuilder.addChild(new ImmutableNode.Builder().name("name").value((Object)tables[i]).create());
            nodeTableBuilder.addAttribute("type", (Object)tabTypes[i]);
            ImmutableNode.Builder nodeFieldsBuilder = new ImmutableNode.Builder(fields[i].length);
            for (int j = 0; j < fields[i].length; ++j) {
                nodeFieldsBuilder.addChild(TestDefaultExpressionEngine.createFieldNode(fields[i][j]));
            }
            nodeTableBuilder.addChild(nodeFieldsBuilder.name("fields").create());
            nodeTablesBuilder.addChild(nodeTableBuilder.create());
        }
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder();
        rootBuilder.addChild(nodeTablesBuilder.create());
        ImmutableNode.Builder nodeConnBuilder = new ImmutableNode.Builder();
        nodeConnBuilder.name("connection.settings");
        nodeConnBuilder.addChild(TestDefaultExpressionEngine.createNode("usr.name", "scott"));
        nodeConnBuilder.addChild(TestDefaultExpressionEngine.createNode("usr.pwd", "tiger"));
        rootBuilder.addAttribute("test", (Object)"true");
        rootBuilder.addChild(nodeConnBuilder.create());
        return rootBuilder.create();
    }

    private void checkAttributeValue(String key, String attr, Object expValue) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, attr, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assertions.assertTrue((boolean)result.isAttributeResult());
        Assertions.assertEquals((Object)expValue, (Object)result.getAttributeValue(handler), (String)("Wrong attribute value for key " + key));
    }

    private List<QueryResult<ImmutableNode>> checkKey(String key, String name, int count) {
        List<QueryResult<ImmutableNode>> nodes = this.query(key, count);
        for (QueryResult<ImmutableNode> result : nodes) {
            if (result.isAttributeResult()) {
                Assertions.assertEquals((Object)name, (Object)result.getAttributeName(), (String)("Wrong attribute name for key " + key));
                continue;
            }
            Assertions.assertEquals((Object)name, (Object)((ImmutableNode)result.getNode()).getNodeName(), (String)("Wrong result node for key " + key));
        }
        return nodes;
    }

    private void checkKeyValue(String key, String name, String value) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, name, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assertions.assertFalse((boolean)result.isAttributeResult());
        Assertions.assertEquals((Object)value, (Object)((ImmutableNode)result.getNode()).getValue(), (String)("Wrong value for key " + key));
    }

    private void checkNodePath(NodeAddData<ImmutableNode> data, String ... expected) {
        Assertions.assertEquals(Arrays.asList(expected), (Object)data.getPathNodes());
    }

    private void checkQueryRootNode(String key) {
        List<QueryResult<ImmutableNode>> results = this.checkKey(key, null, 1);
        QueryResult<ImmutableNode> result = results.get(0);
        Assertions.assertFalse((boolean)result.isAttributeResult());
        Assertions.assertSame((Object)root, (Object)result.getNode());
    }

    private ImmutableNode fetchNode(String key) {
        QueryResult<ImmutableNode> result = this.query(key, 1).get(0);
        Assertions.assertFalse((boolean)result.isAttributeResult());
        return (ImmutableNode)result.getNode();
    }

    private List<QueryResult<ImmutableNode>> query(String key, int expCount) {
        List nodes = this.engine.query((Object)root, key, handler);
        Assertions.assertEquals((int)expCount, (int)nodes.size());
        return nodes;
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.engine = DefaultExpressionEngine.INSTANCE;
    }

    private void setUpAlternativeMatcher() {
        NodeMatcher<String> matcher = new NodeMatcher<String>(){

            public <T> boolean matches(T node, NodeHandler<T> handler, String criterion) {
                return handler.nodeName(node).equals(StringUtils.remove((String)criterion, (char)'_'));
            }
        };
        this.engine = new DefaultExpressionEngine(this.engine.getSymbols(), (NodeMatcher)matcher);
    }

    private void setUpAlternativeSyntax() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder().setAttributeEnd(null).setAttributeStart("@").setPropertyDelimiter("/").setEscapedDelimiter(null).setIndexStart("[").setIndexEnd("]").create();
        this.engine = new DefaultExpressionEngine(symbols);
    }

    @Test
    public void testAttributeKey() {
        Assertions.assertEquals((Object)"tables.table[@type]", (Object)this.engine.attributeKey("tables.table", "type"));
    }

    @Test
    public void testAttributeKeyNoParent() {
        Assertions.assertEquals((Object)"[@test]", (Object)this.engine.attributeKey(null, "test"));
    }

    @Test
    public void testAttributeKeyRoot() {
        Assertions.assertEquals((Object)"[@test]", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testAttributeKeyWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        Assertions.assertEquals((Object)"@test", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testCanonicalKeyNoDuplicates() {
        ImmutableNode node = this.fetchNode("tables.table(0).name");
        Assertions.assertEquals((Object)"table.name(0)", (Object)this.engine.canonicalKey((Object)node, "table", handler));
    }

    @Test
    public void testCanonicalKeyNoParentKey() {
        ImmutableNode node = this.fetchNode("tables.table(0).fields.field(1).name");
        Assertions.assertEquals((Object)"name(0)", (Object)this.engine.canonicalKey((Object)node, null, handler));
    }

    @Test
    public void testCanonicalKeyRootNoParentKey() {
        Assertions.assertEquals((Object)"", (Object)this.engine.canonicalKey((Object)root, null, handler));
    }

    @Test
    public void testCanonicalKeyRootWithParentKey() {
        Assertions.assertEquals((Object)"parent", (Object)this.engine.canonicalKey((Object)root, "parent", handler));
    }

    @Test
    public void testCanonicalKeyWithDuplicates() {
        ImmutableNode tab1 = this.fetchNode("tables.table(0)");
        ImmutableNode tab2 = this.fetchNode("tables.table(1)");
        Assertions.assertEquals((Object)"tables.table(0)", (Object)this.engine.canonicalKey((Object)tab1, "tables", handler));
        Assertions.assertEquals((Object)"tables.table(1)", (Object)this.engine.canonicalKey((Object)tab2, "tables", handler));
    }

    @Test
    public void testDefaultSymbols() {
        Assertions.assertSame((Object)DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, (Object)this.engine.getSymbols());
    }

    @Test
    public void testInitNoSymbols() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new DefaultExpressionEngine(null));
    }

    @Test
    public void testNodeKey() {
        ImmutableNode node = (ImmutableNode)root.getChildren().get(0);
        Assertions.assertEquals((Object)"tables", (Object)this.engine.nodeKey((Object)node, "", handler));
        Assertions.assertEquals((Object)"test.tables", (Object)this.engine.nodeKey((Object)node, "test", handler));
        Assertions.assertEquals((Object)"a.full.parent.key.tables", (Object)this.engine.nodeKey((Object)node, "a.full.parent.key", handler));
    }

    @Test
    public void testNodeKeyWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        Assertions.assertEquals((Object)"tables/table", (Object)this.engine.nodeKey((Object)((ImmutableNode)((ImmutableNode)root.getChildren().get(0)).getChildren().get(0)), "tables", handler));
    }

    @Test
    public void testNodeKeyWithAlternativeSyntaxAttributePropertyDelimiter() {
        this.setUpAlternativeSyntax();
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(this.engine.getSymbols()).setAttributeStart(this.engine.getSymbols().getPropertyDelimiter()).create();
        this.engine = new DefaultExpressionEngine(symbols);
        Assertions.assertEquals((Object)"/test", (Object)this.engine.attributeKey("", "test"));
    }

    @Test
    public void testNodeKeyWithEscapedDelimiters() {
        ImmutableNode node = (ImmutableNode)root.getChildren().get(1);
        Assertions.assertEquals((Object)"connection..settings", (Object)this.engine.nodeKey((Object)node, "", handler));
        Assertions.assertEquals((Object)"connection..settings.usr..name", (Object)this.engine.nodeKey((Object)((ImmutableNode)node.getChildren().get(0)), this.engine.nodeKey((Object)node, "", handler), handler));
    }

    @Test
    public void testNodeKeyWithRoot() {
        Assertions.assertEquals((Object)"", (Object)this.engine.nodeKey((Object)root, null, handler));
        Assertions.assertEquals((Object)"test", (Object)this.engine.nodeKey((Object)root, "test", handler));
    }

    @Test
    public void testPrepareAddAttribute() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0)[@tableSpace]", handler);
        Assertions.assertEquals((Object)tables[0], (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
        Assertions.assertEquals((Object)"tableSpace", (Object)data.getNewNodeName());
        Assertions.assertTrue((boolean)data.isAttribute());
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
    }

    @Test
    public void testPrepareAddAttributeRoot() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "[@newAttr]", handler);
        Assertions.assertSame((Object)root, (Object)data.getParent());
        Assertions.assertEquals((Object)"newAttr", (Object)data.getNewNodeName());
        Assertions.assertTrue((boolean)data.isAttribute());
    }

    @Test
    public void testPrepareAddDirectly() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "newNode", handler);
        Assertions.assertSame((Object)root, (Object)data.getParent());
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
        Assertions.assertEquals((Object)"newNode", (Object)data.getNewNodeName());
        Assertions.assertFalse((boolean)data.isAttribute());
        data = this.engine.prepareAdd((Object)root, "tables.table.fields.field.name", handler);
        Assertions.assertEquals((Object)"name", (Object)data.getNewNodeName());
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
        Assertions.assertEquals((Object)"field", (Object)((ImmutableNode)data.getParent()).getNodeName());
        ImmutableNode nd = (ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0);
        Assertions.assertEquals((Object)"name", (Object)nd.getNodeName());
        Assertions.assertEquals((Object)"version", (Object)nd.getValue());
    }

    @Test
    public void testPrepareAddEmptyKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.engine.prepareAdd((Object)root, "", handler));
    }

    @Test
    public void testPrepareAddInvalidKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.engine.prepareAdd((Object)root, "tables.table(0)[@type].new", handler));
    }

    @Test
    public void testPrepareAddInvalidKeyAttribute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.engine.prepareAdd((Object)root, "a.complete.new.path.with.an[@attribute].at.a.non.allowed[@position]", handler));
    }

    @Test
    public void testPrepareAddNullKey() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.engine.prepareAdd((Object)root, null, handler));
    }

    @Test
    public void testPrepareAddWithAlternativeMatcher() {
        this.setUpAlternativeMatcher();
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables_.table._fields__._field.name", handler);
        Assertions.assertEquals((Object)"name", (Object)data.getNewNodeName());
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
    }

    @Test
    public void testPrepareAddWithAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables/table[0]/test", handler);
        Assertions.assertEquals((Object)"test", (Object)data.getNewNodeName());
        Assertions.assertFalse((boolean)data.isAttribute());
        Assertions.assertEquals((Object)tables[0], (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
        data = this.engine.prepareAdd((Object)root, "a/complete/new/path@attr", handler);
        Assertions.assertEquals((Object)"attr", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new", "path");
        Assertions.assertSame((Object)root, (Object)data.getParent());
    }

    @Test
    public void testPrepareAddWithIndex() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0).tableSpace", handler);
        Assertions.assertEquals((Object)"tableSpace", (Object)data.getNewNodeName());
        Assertions.assertTrue((boolean)data.getPathNodes().isEmpty());
        Assertions.assertEquals((Object)"table", (Object)((ImmutableNode)data.getParent()).getNodeName());
        ImmutableNode node = (ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0);
        Assertions.assertEquals((Object)tables[0], (Object)node.getValue());
        data = this.engine.prepareAdd((Object)root, "tables.table(1).fields.field(2).alias", handler);
        Assertions.assertEquals((Object)"alias", (Object)data.getNewNodeName());
        Assertions.assertEquals((Object)"field", (Object)((ImmutableNode)data.getParent()).getNodeName());
        Assertions.assertEquals((Object)"creationDate", (Object)((ImmutableNode)((ImmutableNode)data.getParent()).getChildren().get(0)).getValue());
    }

    @Test
    public void testPrepareAddWithPath() {
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(1).fields.field(-1).name", handler);
        Assertions.assertEquals((Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "field");
        Assertions.assertEquals((Object)"fields", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "tables.table(-1).name", handler);
        Assertions.assertEquals((Object)"name", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "table");
        Assertions.assertEquals((Object)"tables", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "a.complete.new.path", handler);
        Assertions.assertEquals((Object)"path", (Object)data.getNewNodeName());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new");
        Assertions.assertSame((Object)root, (Object)data.getParent());
    }

    @Test
    public void testPrepareAddWithSameAttributeDelimiter() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setAttributeEnd(null).setAttributeStart(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS.getPropertyDelimiter()).create();
        this.engine = new DefaultExpressionEngine(symbols);
        NodeAddData data = this.engine.prepareAdd((Object)root, "tables.table(0).test", handler);
        Assertions.assertEquals((Object)"test", (Object)data.getNewNodeName());
        Assertions.assertFalse((boolean)data.isAttribute());
        Assertions.assertEquals((Object)"table", (Object)((ImmutableNode)data.getParent()).getNodeName());
        data = this.engine.prepareAdd((Object)root, "a.complete.new.path", handler);
        Assertions.assertFalse((boolean)data.isAttribute());
        this.checkNodePath((NodeAddData<ImmutableNode>)data, "a", "complete", "new");
    }

    @Test
    public void testQueryAlternativeSyntax() {
        this.setUpAlternativeSyntax();
        this.checkKeyValue("tables/table[1]/name", "name", tables[1]);
        this.checkAttributeValue("tables/table[0]@type", "type", tabTypes[0]);
        this.checkAttributeValue("@test", "test", "true");
        this.checkKeyValue("connection.settings/usr.name", "usr.name", "scott");
    }

    @Test
    public void testQueryAttributeEmulation() {
        DefaultExpressionEngineSymbols symbols = new DefaultExpressionEngineSymbols.Builder(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS).setAttributeEnd(null).setAttributeStart(".").create();
        this.engine = new DefaultExpressionEngine(symbols);
        this.checkKeyValue("tables.table(0).name", "name", tables[0]);
        this.checkAttributeValue("tables.table(0).type", "type", tabTypes[0]);
        this.checkKey("tables.table.type", "type", 2);
    }

    @Test
    public void testQueryEscapedKeys() {
        this.checkKeyValue("connection..settings.usr..name", "usr.name", "scott");
        this.checkKeyValue("connection..settings.usr..pwd", "usr.pwd", "tiger");
    }

    @Test
    public void testQueryKeys() {
        this.checkKey("tables.table.name", "name", 2);
        this.checkKey("tables.table.fields.field.name", "name", 10);
        this.checkKey("tables.table[@type]", "type", 2);
        this.checkKey("tables.table(0).fields.field.name", "name", 5);
        this.checkKey("tables.table(1).fields.field.name", "name", 5);
        this.checkKey("tables.table.fields.field(1).name", "name", 2);
    }

    @Test
    public void testQueryKeyWithAlternativeMatcher() {
        this.setUpAlternativeMatcher();
        this.checkKey("tables_._table_.name_", "name", 2);
    }

    @Test
    public void testQueryNodes() {
        for (int i = 0; i < tables.length; ++i) {
            this.checkKeyValue("tables.table(" + i + ").name", "name", tables[i]);
            this.checkAttributeValue("tables.table(" + i + ")[@type]", "type", tabTypes[i]);
            for (int j = 0; j < fields[i].length; ++j) {
                this.checkKeyValue("tables.table(" + i + ").fields.field(" + j + ").name", "name", fields[i][j]);
            }
        }
    }

    @Test
    public void testQueryNonExistingKeys() {
        this.checkKey("tables.tablespace.name", null, 0);
        this.checkKey("tables.table(2).name", null, 0);
        this.checkKey("a complete unknown key", null, 0);
        this.checkKey("tables.table(0).fields.field(-1).name", null, 0);
        this.checkKey("tables.table(0).fields.field(28).name", null, 0);
        this.checkKey("tables.table(0).fields.field().name", null, 0);
        this.checkKey("connection.settings.usr.name", null, 0);
        this.checkKey("tables.table(0)[@type].additional", null, 0);
    }

    @Test
    public void testQueryRootAttribute() {
        this.checkAttributeValue("[@test]", "test", "true");
    }

    @Test
    public void testQueryRootNodeEmptyKey() {
        this.checkQueryRootNode("");
    }

    @Test
    public void testQueryRootNodeNullKey() {
        this.checkQueryRootNode(null);
    }
}

